/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.ir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.BaseIrGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrPredicatesKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrSerializablePropertiesKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrSerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializationBaseContext;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerIrGeneratorKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerSearchUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.extensions.SerializationPluginContext;
import org.jetbrains.kotlinx.serialization.compiler.resolve.ISerializablePropertiesKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerialEntityNames;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPreGenerator;", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/BaseIrGenerator;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "compilerContext", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generate", "", "preGenerateWriteSelfMethodIfNeeded", "preGenerateDeserializationConstructorIfNeeded", "makeNullableIfNotPrimitive", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Companion", "kotlinx-serialization-compiler-plugin.backend"})
@SourceDebugExtension(value={"SMAP\nIrPreGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrPreGenerator.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPreGenerator\n+ 2 IrPredicates.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPredicatesKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n279#2:157\n249#3:158\n243#3:159\n237#3,10:160\n289#3:184\n283#3,13:185\n1269#4,2:170\n1283#4,4:172\n1547#4:176\n1618#4,3:177\n1862#4,3:180\n1#5:183\n*S KotlinDebug\n*F\n+ 1 IrPreGenerator.kt\norg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPreGenerator\n*L\n49#1:157\n56#1:158\n56#1:159\n56#1:160,10\n119#1:184\n119#1:185,13\n65#1:170,2\n65#1:172,4\n73#1:176\n73#1:177,3\n94#1:180,3\n*E\n"})
public final class IrPreGenerator
extends BaseIrGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrClass irClass;

    public IrPreGenerator(@NotNull IrClass irClass, @NotNull SerializationPluginContext compilerContext) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)compilerContext, (String)"compilerContext");
        super(irClass, compilerContext);
        this.irClass = irClass;
    }

    @NotNull
    public final IrClass getIrClass() {
        return this.irClass;
    }

    private final void generate() {
        this.preGenerateWriteSelfMethodIfNeeded();
        this.preGenerateDeserializationConstructorIfNeeded();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void preGenerateWriteSelfMethodIfNeeded() {
        void $this$mapTo$iv$iv;
        Object object;
        DescriptorVisibility descriptorVisibility;
        if (!JvmPlatformKt.isJvm((TargetPlatform)this.getCompilerContext().getPlatform())) {
            return;
        }
        if (!IrPredicatesKt.isInternalSerializable(this.irClass)) {
            return;
        }
        IrClassSymbol irClassSymbol = SerializerSearchUtilKt.classSerializer(this.irClass, this.getCompilerContext());
        IrClassSymbol irClassSymbol2 = irClassSymbol;
        if (irClassSymbol == null) return;
        if ((irClassSymbol2 = (IrClass)irClassSymbol2.getOwner()) == null) {
            return;
        }
        IrClassSymbol serializerDescriptor = irClassSymbol2;
        IrClass $this$shouldHaveSpecificSyntheticMethods$iv = this.irClass;
        boolean $i$f$shouldHaveSpecificSyntheticMethods = false;
        if (IrDeclarationsKt.isSingleFieldValueClass((IrClass)$this$shouldHaveSpecificSyntheticMethods$iv)) return;
        if (!IrPredicatesKt.isAbstractOrSealedSerializableClass($this$shouldHaveSpecificSyntheticMethods$iv)) {
            boolean bl = false;
            if (IrPredicatesKt.findPluginGeneratedMethod((IrClass)serializerDescriptor, "serialize", this.getCompilerContext().getAfterK2()) == null) return;
        }
        boolean bl = true;
        if (!bl) {
            return;
        }
        if (IrPredicatesKt.findWriteSelfMethod(this.irClass) != null) {
            return;
        }
        IrClass $this$addFunction$iv = this.irClass;
        boolean $i$f$addFunction = false;
        IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
        boolean $i$f$addFunction2 = false;
        IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv$iv$iv = new IrFunctionBuilder();
        boolean bl2 = false;
        IrFunctionBuilder $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241 = $this$buildFun_u24lambda_u2420$iv$iv$iv;
        boolean bl3 = false;
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setName(SerialEntityNames.INSTANCE.getWRITE_SELF_NAME());
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setReturnType(this.getCompilerContext().getIrBuiltIns().getUnitType());
        if (this.irClass.getModality() == Modality.FINAL) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.INTERNAL;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"INTERNAL");
        } else {
            DescriptorVisibility descriptorVisibility3 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PUBLIC");
        }
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setVisibility(descriptorVisibility);
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setModality(Modality.FINAL);
        $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241.setOrigin((IrDeclarationOrigin)SerializerIrGeneratorKt.getSERIALIZATION_PLUGIN_ORIGIN());
        IrFactory function$iv$iv = $this$buildFun$iv$iv$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2420$iv$iv$iv);
        boolean bl4 = false;
        ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add(function$iv$iv);
        function$iv$iv.setParent((IrDeclarationParent)((IrDeclarationContainer)$this$addFunction$iv));
        IrFactory method = $this$buildFun$iv$iv$iv;
        this.excludeFromJsExport((IrDeclaration)method);
        Iterable $this$associateWith$iv = this.irClass.getTypeParameters();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            $this$preGenerateWriteSelfMethodIfNeeded_u24lambda_u241 = (IrTypeParameter)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl5 = false;
            IrTypeParametersContainer irTypeParametersContainer = (IrTypeParametersContainer)method;
            String string = it.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            IrTypeParameter irTypeParameter = DeclarationBuildersKt.addTypeParameter$default((IrTypeParametersContainer)irTypeParametersContainer, (String)string, (IrType)this.getCompilerContext().getIrBuiltIns().getAnyNType(), null, (int)4, null);
            object.put(t, irTypeParameter);
        }
        Map typeParamsMap = result$iv;
        IrValueParameter irValueParameter = this.irClass.getThisReceiver();
        method.setDispatchReceiverParameter(irValueParameter != null ? IrUtilsKt.copyTo$default((IrValueParameter)irValueParameter, (IrFunction)((IrFunction)method), null, (int)0, (int)0, (int)0, null, (Map)typeParamsMap, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8126, null) : null);
        Iterable $this$map$iv = typeParamsMap.values();
        boolean $i$f$map = false;
        $this$associateWithTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter bl5 = (IrTypeParameter)item$iv$iv;
            object = destination$iv$iv;
            boolean bl6 = false;
            object.add(IrTypesKt.getDefaultType((IrTypeParameter)it));
        }
        List typeParamsAsArguments = (List)destination$iv$iv;
        IrFunction irFunction = (IrFunction)method;
        Name name = Name.identifier((String)"self");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        DeclarationBuildersKt.addValueParameter((IrFunction)irFunction, (Name)name, (IrType)((IrType)IrTypesKt.typeWith((IrClass)this.irClass, (List)typeParamsAsArguments)), (IrDeclarationOrigin)((IrDeclarationOrigin)SerializerIrGeneratorKt.getSERIALIZATION_PLUGIN_ORIGIN()));
        IrFunction irFunction2 = (IrFunction)method;
        Name name2 = Name.identifier((String)"output");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        DeclarationBuildersKt.addValueParameter((IrFunction)irFunction2, (Name)name2, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)SerializerSearchUtilKt.getClassFromRuntime(this.getCompilerContext(), "CompositeEncoder", new FqName[0]))), (IrDeclarationOrigin)((IrDeclarationOrigin)SerializerIrGeneratorKt.getSERIALIZATION_PLUGIN_ORIGIN()));
        IrClassSymbol serialDescriptorSymbol = SerializerSearchUtilKt.getClassFromRuntime(this.getCompilerContext(), "SerialDescriptor", new FqName[0]);
        IrFunction irFunction3 = (IrFunction)method;
        Name name3 = Name.identifier((String)"serialDesc");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        DeclarationBuildersKt.addValueParameter((IrFunction)irFunction3, (Name)name3, (IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)serialDescriptorSymbol)), (IrDeclarationOrigin)((IrDeclarationOrigin)SerializerIrGeneratorKt.getSERIALIZATION_PLUGIN_ORIGIN()));
        IrClassSymbol kSerializerSymbol = SerializerSearchUtilKt.getClassFromRuntime(this.getCompilerContext(), "KSerializer", new FqName[0]);
        Iterable $this$forEachIndexed$iv = typeParamsAsArguments;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrSimpleType bl6 = (IrSimpleType)item$iv;
            int i = n;
            boolean bl7 = false;
            IrFunction irFunction4 = (IrFunction)method;
            Name name4 = Name.identifier((String)("typeSerial" + i));
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
            IrType[] irTypeArray = new IrType[]{it};
            DeclarationBuildersKt.addValueParameter((IrFunction)irFunction4, (Name)name4, (IrType)((IrType)IrTypesKt.typeWith((IrClassifierSymbol)((IrClassifierSymbol)kSerializerSymbol), (IrType[])irTypeArray)), (IrDeclarationOrigin)((IrDeclarationOrigin)SerializerIrGeneratorKt.getSERIALIZATION_PLUGIN_ORIGIN()));
        }
        IrClassSymbol irClassSymbol3 = this.getCompilerContext().referenceClass(AnnotationUtilKt.getJVM_STATIC_ANNOTATION_CLASS_ID());
        if (irClassSymbol3 != null) {
            IrClassSymbol it = irClassSymbol3;
            boolean bl8 = false;
            method.setAnnotations(CollectionsKt.plus((Collection)method.getAnnotations(), (Object)this.createAnnotationCallWithoutArgs((IrElement)method, it)));
        }
        this.getCompilerContext().getMetadataDeclarationRegistrar().registerFunctionAsMetadataVisible((IrSimpleFunction)method);
        method.setDispatchReceiverParameter(null);
    }

    private final void preGenerateDeserializationConstructorIfNeeded() {
        DescriptorVisibility descriptorVisibility;
        IrClass irClass;
        if (!IrPredicatesKt.isInternalSerializable(this.irClass)) {
            return;
        }
        if (IrPredicatesKt.getHasCompanionObjectAsSerializer(this.irClass) && ((irClass = AdditionalIrUtilsKt.companionObject((IrClass)this.irClass)) != null ? IrPredicatesKt.findPluginGeneratedMethod(irClass, "deserialize", this.getCompilerContext().getAfterK2()) : null) == null) {
            return;
        }
        if (IrDeclarationsKt.isSingleFieldValueClass((IrClass)this.irClass)) {
            return;
        }
        if (IrPredicatesKt.findSerializableSyntheticConstructor(this.irClass) != null) {
            return;
        }
        IrClass $this$addConstructor$iv = this.irClass;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2425$iv = $this$buildConstructor_u24lambda_u2424$iv$iv;
        boolean bl2 = false;
        IrFunctionBuilder $this$preGenerateDeserializationConstructorIfNeeded_u24lambda_u246 = $this$addConstructor_u24lambda_u2425$iv;
        boolean bl3 = false;
        $this$preGenerateDeserializationConstructorIfNeeded_u24lambda_u246.setOrigin((IrDeclarationOrigin)SerializerIrGeneratorKt.getSERIALIZATION_PLUGIN_ORIGIN());
        if (this.irClass.getModality() == Modality.FINAL) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.INTERNAL;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"INTERNAL");
        } else {
            DescriptorVisibility descriptorVisibility3 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PUBLIC");
        }
        $this$preGenerateDeserializationConstructorIfNeeded_u24lambda_u246.setVisibility(descriptorVisibility);
        $this$addConstructor_u24lambda_u2425$iv.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        IrFactory constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2424$iv$iv);
        boolean bl4 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        IrClass $this$preGenerateDeserializationConstructorIfNeeded_u24lambda_u247 = $this$addConstructor$iv = $this$buildConstructor$iv$iv;
        boolean bl5 = false;
        this.excludeFromJsExport((IrDeclaration)$this$preGenerateDeserializationConstructorIfNeeded_u24lambda_u247);
        IrClass ctor = $this$addConstructor$iv;
        SerializationBaseContext serializationBaseContext = this.getCompilerContext();
        String string = SerialEntityNames.INSTANCE.getSERIAL_CTOR_MARKER_NAME().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        IrClassSymbol markerClassSymbol = SerializerSearchUtilKt.getClassFromInternalSerializationPackage(serializationBaseContext, string);
        List<IrSerializableProperty> serializableProperties2 = IrSerializablePropertiesKt.serializablePropertiesForIrBackend$default(this.irClass, null, null, 6, null).getSerializableProperties();
        int bitMaskSlotsCount = ISerializablePropertiesKt.bitMaskSlotCount(serializableProperties2);
        int n = 0;
        while (n < bitMaskSlotsCount) {
            int it = n++;
            boolean bl6 = false;
            IrFunction irFunction = (IrFunction)ctor;
            Name name = Name.identifier((String)("seen" + it));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            DeclarationBuildersKt.addValueParameter((IrFunction)irFunction, (Name)name, (IrType)this.getCompilerContext().getIrBuiltIns().getIntType(), (IrDeclarationOrigin)((IrDeclarationOrigin)SerializerIrGeneratorKt.getSERIALIZATION_PLUGIN_ORIGIN()));
        }
        for (IrSerializableProperty prop : serializableProperties2) {
            DeclarationBuildersKt.addValueParameter((IrFunction)((IrFunction)ctor), (Name)prop.getOriginalDescriptorName(), (IrType)this.makeNullableIfNotPrimitive((IrType)prop.getType()), (IrDeclarationOrigin)((IrDeclarationOrigin)SerializerIrGeneratorKt.getSERIALIZATION_PLUGIN_ORIGIN()));
        }
        DeclarationBuildersKt.addValueParameter((IrFunction)((IrFunction)ctor), (Name)SerialEntityNames.INSTANCE.getDummyParamName(), (IrType)IrTypesKt.makeNullable((IrType)IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)markerClassSymbol))), (IrDeclarationOrigin)((IrDeclarationOrigin)SerializerIrGeneratorKt.getSERIALIZATION_PLUGIN_ORIGIN()));
        this.getCompilerContext().getMetadataDeclarationRegistrar().registerConstructorAsMetadataVisible((IrConstructor)ctor);
    }

    private final IrType makeNullableIfNotPrimitive(IrType $this$makeNullableIfNotPrimitive) {
        return IrTypePredicatesKt.isPrimitiveType((IrType)$this$makeNullableIfNotPrimitive, (boolean)false) ? $this$makeNullableIfNotPrimitive : IrTypesKt.makeNullable((IrType)$this$makeNullableIfNotPrimitive);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrPreGenerator$Companion;", "", "<init>", "()V", "generate", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "compilerContext", "Lorg/jetbrains/kotlinx/serialization/compiler/extensions/SerializationPluginContext;", "kotlinx-serialization-compiler-plugin.backend"})
    public static final class Companion {
        private Companion() {
        }

        public final void generate(@NotNull IrClass irClass, @NotNull SerializationPluginContext compilerContext) {
            Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
            Intrinsics.checkNotNullParameter((Object)compilerContext, (String)"compilerContext");
            if (!IrPredicatesKt.isInternalSerializable(irClass)) {
                return;
            }
            new IrPreGenerator(irClass, compilerContext).generate();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

