/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.substitutions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a$\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"getCallableSubstitution", "", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeProjection;", "baseCallable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "derivedCallable", "getCallableSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "getTypeSubstitution", "Ljava/util/LinkedHashMap;", "baseType", "Lorg/jetbrains/kotlin/types/KotlinType;", "derivedType", "getTypeSubstitutor", "ide-common"})
public final class SubstitutionUtilsKt {
    @Nullable
    public static final LinkedHashMap<TypeConstructor, TypeProjection> getTypeSubstitution(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)baseType, (String)"baseType");
        Intrinsics.checkNotNullParameter((Object)derivedType, (String)"derivedType");
        KotlinType kotlinType2 = TypeCheckingProcedure.findCorrespondingSupertype((KotlinType)derivedType, (KotlinType)baseType);
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType substitutedType = kotlinType = kotlinType2;
        LinkedHashMap<TypeConstructor, TypeProjection> substitution = new LinkedHashMap<TypeConstructor, TypeProjection>(substitutedType.getArguments().size());
        List list2 = baseType.getConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"baseType.constructor.parameters");
        for (List list2 : CollectionsKt.zip((Iterable)list2, (Iterable)substitutedType.getArguments())) {
            TypeParameterDescriptor param = (TypeParameterDescriptor)list2.component1();
            TypeProjection arg = (TypeProjection)list2.component2();
            Map map = substitution;
            TypeConstructor typeConstructor = param.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor, (String)"param.typeConstructor");
            boolean bl = false;
            map.put(typeConstructor, arg);
        }
        return substitution;
    }

    @Nullable
    public static final Map<TypeConstructor, TypeProjection> getCallableSubstitution(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        ClassDescriptor classDescriptor;
        Intrinsics.checkNotNullParameter((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkNotNullParameter((Object)derivedCallable, (String)"derivedCallable");
        DeclarationDescriptor declarationDescriptor = baseCallable.getContainingDeclaration();
        ClassDescriptor classDescriptor2 = classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor baseClass = classDescriptor;
        Object object = derivedCallable.getContainingDeclaration();
        ClassDescriptor classDescriptor3 = declarationDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor derivedClass = declarationDescriptor;
        Object object22 = baseClass.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)object22, (String)"baseClass.defaultType");
        KotlinType kotlinType = (KotlinType)object22;
        object22 = derivedClass.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)object22, (String)"derivedClass.defaultType");
        object = SubstitutionUtilsKt.getTypeSubstitution(kotlinType, (KotlinType)object22);
        if (object == null) {
            return null;
        }
        Object substitution = object;
        object22 = baseCallable.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)object22, (String)"baseCallable.typeParameters");
        Iterable iterable = (Iterable)object22;
        object22 = derivedCallable.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)object22, (String)"derivedCallable.typeParameters");
        for (Object object22 : CollectionsKt.zip((Iterable)iterable, (Iterable)((Iterable)object22))) {
            TypeParameterDescriptor baseParam = (TypeParameterDescriptor)object22.component1();
            TypeParameterDescriptor derivedParam = (TypeParameterDescriptor)object22.component2();
            Map map = (Map)substitution;
            TypeConstructor typeConstructor = baseParam.getTypeConstructor();
            Intrinsics.checkNotNullExpressionValue((Object)typeConstructor, (String)"baseParam.typeConstructor");
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl((KotlinType)derivedParam.getDefaultType());
            boolean bl = false;
            map.put(typeConstructor, typeProjectionImpl);
        }
        return (Map)substitution;
    }

    @Nullable
    public static final TypeSubstitutor getCallableSubstitutor(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        TypeSubstitutor typeSubstitutor;
        Intrinsics.checkNotNullParameter((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkNotNullParameter((Object)derivedCallable, (String)"derivedCallable");
        Map<TypeConstructor, TypeProjection> map = SubstitutionUtilsKt.getCallableSubstitution(baseCallable, derivedCallable);
        if (map == null) {
            typeSubstitutor = null;
        } else {
            Map<TypeConstructor, TypeProjection> map2 = map;
            boolean bl = false;
            boolean bl2 = false;
            Map<TypeConstructor, TypeProjection> it = map2;
            boolean bl3 = false;
            typeSubstitutor = TypeSubstitutor.create(it);
        }
        return typeSubstitutor;
    }

    @Nullable
    public static final TypeSubstitutor getTypeSubstitutor(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        TypeSubstitutor typeSubstitutor;
        Intrinsics.checkNotNullParameter((Object)baseType, (String)"baseType");
        Intrinsics.checkNotNullParameter((Object)derivedType, (String)"derivedType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(baseType, derivedType);
        if (linkedHashMap == null) {
            typeSubstitutor = null;
        } else {
            LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap2 = linkedHashMap;
            boolean bl = false;
            boolean bl2 = false;
            LinkedHashMap<TypeConstructor, TypeProjection> it = linkedHashMap2;
            boolean bl3 = false;
            typeSubstitutor = TypeSubstitutor.create((Map)it);
        }
        return typeSubstitutor;
    }
}

