/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.repl.js;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.scripting.compiler.plugin.impl.AbstractJsScriptlikeCodeAnalyser;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplCodeAnalyzerBase;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplCodeAnalyzerKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptPriorities;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/scripting/repl/js/JsReplCodeAnalyzer;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/impl/AbstractJsScriptlikeCodeAnalyser;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "dependencies", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "replState", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;Ljava/util/List;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplCodeAnalyzerBase$ResettableAnalyzerState;)V", "analyzeReplLine", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "linePsi", "Lorg/jetbrains/kotlin/psi/KtFile;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "kotlin-scripting-compiler"})
public final class JsReplCodeAnalyzer
extends AbstractJsScriptlikeCodeAnalyser {
    @NotNull
    private final ReplCodeAnalyzerBase.ResettableAnalyzerState replState;

    public JsReplCodeAnalyzer(@NotNull KotlinCoreEnvironment environment2, @NotNull List<? extends ModuleDescriptor> dependencies, @NotNull ReplCodeAnalyzerBase.ResettableAnalyzerState replState) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)replState, (String)"replState");
        super(environment2, dependencies);
        this.replState = replState;
    }

    @NotNull
    public final AnalysisResult analyzeReplLine(@NotNull KtFile linePsi, @NotNull ReplCodeLine codeLine) {
        AnalysisResult analysisResult;
        Intrinsics.checkNotNullParameter((Object)linePsi, (String)"linePsi");
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        KtScript ktScript = linePsi.getScript();
        Intrinsics.checkNotNull((Object)ktScript);
        ktScript.putUserData(ScriptPriorities.PRIORITY_KEY, (Object)codeLine.getNo());
        this.replState.submitLine(linePsi);
        AbstractJsScriptlikeCodeAnalyser.JsScriptAnalysisResult result = this.analysisImpl(linePsi);
        if (result.isSuccess()) {
            this.replState.lineSuccess(linePsi, ReplCodeAnalyzerKt.toSourceCode(codeLine), result.getScript());
            analysisResult = AnalysisResult.Companion.success(result.getBindingContext(), result.getModuleDescriptor());
        } else {
            this.replState.lineFailure(linePsi);
            analysisResult = AnalysisResult.Companion.compilationError(result.getBindingContext());
        }
        return analysisResult;
    }
}

