/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.BytesUrlUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0014J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0014J\u001a\u0010\r\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/impl/CompiledScriptClassLoader;", "Ljava/lang/ClassLoader;", "parent", "entries", "", "", "", "(Ljava/lang/ClassLoader;Ljava/util/Map;)V", "findClass", "Ljava/lang/Class;", "name", "findResource", "Ljava/net/URL;", "findResources", "Ljava/util/Enumeration;", "getResourceAsStream", "Ljava/io/InputStream;", "kotlin-scripting-compiler"})
public final class CompiledScriptClassLoader
extends ClassLoader {
    @NotNull
    private final Map<String, byte[]> entries;

    public CompiledScriptClassLoader(@Nullable ClassLoader parent, @NotNull Map<String, byte[]> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        super(parent);
        this.entries = entries;
    }

    @Override
    @Nullable
    protected Class<?> findClass(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String classPathName = Intrinsics.stringPlus((String)StringsKt.replace$default((String)name, (char)'.', (char)'/', (boolean)false, (int)4, null), (Object)".class");
        byte[] byArray = this.entries.get(classPathName);
        if (byArray == null) {
            return null;
        }
        byte[] classBytes = byArray;
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name) {
        ByteArrayInputStream byteArrayInputStream;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        byte[] byArray = this.entries.get(name);
        if (byArray == null) {
            byteArrayInputStream = null;
        } else {
            byte[] byArray2 = byArray;
            boolean bl = false;
            boolean bl2 = false;
            byte[] p0 = byArray2;
            boolean bl3 = false;
            byteArrayInputStream = new ByteArrayInputStream(p0);
        }
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        return byteArrayInputStream2 == null ? super.getResourceAsStream(name) : (InputStream)byteArrayInputStream2;
    }

    @Override
    @Nullable
    protected Enumeration<URL> findResources(@Nullable String name) {
        URL uRL;
        Enumeration<URL> fromParent = super.findResources(name);
        Object object = this.entries;
        boolean bl = false;
        byte[] byArray = object.get(name);
        if (byArray == null) {
            uRL = null;
        } else {
            object = byArray;
            bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            uRL = BytesUrlUtils.createBytesUrl((byte[])it);
        }
        URL uRL2 = uRL;
        if (uRL2 == null) {
            return fromParent;
        }
        Object object2 = uRL2;
        URL url = object2;
        Collection collection = CollectionsKt.listOf(url);
        Intrinsics.checkNotNullExpressionValue(fromParent, (String)"fromParent");
        object2 = fromParent;
        boolean bl4 = false;
        return Collections.enumeration(CollectionsKt.plus((Collection)collection, (Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)object2))));
    }

    @Override
    @Nullable
    protected URL findResource(@Nullable String name) {
        URL uRL;
        Object object = this.entries;
        boolean bl = false;
        byte[] byArray = object.get(name);
        if (byArray == null) {
            uRL = null;
        } else {
            object = byArray;
            bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            uRL = BytesUrlUtils.createBytesUrl((byte[])it);
        }
        URL uRL2 = uRL;
        return uRL2 == null ? super.findResource(name) : uRL2;
    }
}

