/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.script.AcceptedAnnotations;
import org.jetbrains.kotlin.script.InvalidScriptResolverAnnotation;
import org.jetbrains.kotlin.script.KotlinScriptExternalDependencies;
import org.jetbrains.kotlin.script.ScriptContents;
import org.jetbrains.kotlin.script.ScriptDependenciesResolver;
import org.jetbrains.kotlin.script.ScriptTemplateKt;
import org.jetbrains.kotlin.script.util.DependsOn;
import org.jetbrains.kotlin.script.util.Repository;
import org.jetbrains.kotlin.script.util.resolvers.FlatLibDirectoryResolver;
import org.jetbrains.kotlin.script.util.resolvers.MavenResolver;
import org.jetbrains.kotlin.script.util.resolvers.Resolver;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001cB!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\\\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u00122 \u0010\u0015\u001a\u001c\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020\u00190\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0017J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/script/util/KotlinAnnotatedScriptDependenciesResolver;", "Lorg/jetbrains/kotlin/script/ScriptDependenciesResolver;", "baseClassPath", "", "Ljava/io/File;", "resolvers", "", "Lorg/jetbrains/kotlin/script/util/resolvers/Resolver;", "(Ljava/util/List;Ljava/lang/Iterable;)V", "getBaseClassPath", "()Ljava/util/List;", "", "resolve", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/kotlin/script/KotlinScriptExternalDependencies;", "script", "Lorg/jetbrains/kotlin/script/ScriptContents;", "environment", "", "", "", "report", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/script/ScriptDependenciesResolver$ReportSeverity;", "Lorg/jetbrains/kotlin/script/ScriptContents$Position;", "", "previousDependencies", "resolveFromAnnotations", "ResolvedDependencies", "kotlin-script-util"})
public class KotlinAnnotatedScriptDependenciesResolver
implements ScriptDependenciesResolver {
    private final List<Resolver> resolvers;
    @NotNull
    private final List<File> baseClassPath;

    @AcceptedAnnotations(supportedAnnotationClasses={DependsOn.class, Repository.class})
    @NotNull
    public Future<KotlinScriptExternalDependencies> resolve(@NotNull ScriptContents script, @Nullable Map<String, ? extends Object> environment, @NotNull Function3<? super ScriptDependenciesResolver.ReportSeverity, ? super String, ? super ScriptContents.Position, Unit> report, @Nullable KotlinScriptExternalDependencies previousDependencies) {
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull(report, (String)"report");
        List<File> depsFromAnnotations = this.resolveFromAnnotations(script);
        return (Future)ScriptTemplateKt.asFuture((KotlinScriptExternalDependencies)(previousDependencies != null && depsFromAnnotations.isEmpty() ? previousDependencies : (KotlinScriptExternalDependencies)new ResolvedDependencies(previousDependencies, depsFromAnnotations)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> resolveFromAnnotations(ScriptContents script) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = script.getAnnotations();
        for (Object element$iv : $receiver$iv) {
            Annotation annotation;
            Annotation annotation2;
            block7: {
                Resolver resolver;
                block9: {
                    Object v1;
                    block6: {
                        Object $receiver;
                        Object object;
                        block8: {
                            annotation2 = (Annotation)element$iv;
                            annotation = annotation2;
                            if (!(annotation instanceof Repository)) break block7;
                            resolver = FlatLibDirectoryResolver.Companion.tryCreate((Repository)annotation2);
                            if (resolver == null) break block8;
                            $receiver = object = resolver;
                            this.resolvers.add((Resolver)$receiver);
                            resolver = (FlatLibDirectoryResolver)object;
                            if (resolver != null) break block9;
                        }
                        $receiver = object = (Iterable)this.resolvers;
                        Iterator $i$a$1$apply = $receiver.iterator();
                        while ($i$a$1$apply.hasNext()) {
                            Object t = $i$a$1$apply.next();
                            Resolver it = (Resolver)t;
                            if (!(it instanceof MavenResolver)) continue;
                            v1 = t;
                            break block6;
                        }
                        v1 = null;
                    }
                    Resolver resolver2 = v1;
                    resolver = resolver2 != null ? (Resolver)AddToStdlibKt.check((Object)resolver2, (Function1)((Function1)new Function1<Resolver, Boolean>(annotation2){
                        final /* synthetic */ Annotation $annotation;

                        public final boolean invoke(@NotNull Resolver it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            Resolver resolver = it;
                            if (resolver == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.script.util.resolvers.MavenResolver");
                            }
                            return ((MavenResolver)resolver).tryAddRepo((Repository)this.$annotation);
                        }
                        {
                            this.$annotation = annotation;
                            super(1);
                        }
                    })) : null;
                }
                if (resolver != null) continue;
                throw (Throwable)new IllegalArgumentException("Illegal argument for Repository annotation: " + annotation2);
            }
            if (annotation instanceof DependsOn) continue;
            if (annotation instanceof InvalidScriptResolverAnnotation) {
                throw (Throwable)new Exception("Invalid annotation " + ((InvalidScriptResolverAnnotation)annotation2).getName(), ((InvalidScriptResolverAnnotation)annotation2).getError());
            }
            throw (Throwable)new Exception("Unknown annotation " + annotation2.getClass());
        }
        $receiver$iv = CollectionsKt.filterIsInstance((Iterable)script.getAnnotations(), DependsOn.class);
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Iterable list$iv$iv;
            DependsOn dep = (DependsOn)element$iv$iv;
            if ((Iterable)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.resolvers), (Function1)((Function1)new Function1<Resolver, Iterable<? extends File>>(dep){
                final /* synthetic */ DependsOn $dep;

                @Nullable
                public final Iterable<File> invoke(@NotNull Resolver it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.tryResolve(this.$dep);
                }
                {
                    this.$dep = dependsOn;
                    super(1);
                }
            }))) == null) {
                throw (Throwable)new Exception("Unable to resolve dependency " + dep);
            }
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<File> getBaseClassPath() {
        return this.baseClassPath;
    }

    public KotlinAnnotatedScriptDependenciesResolver(@NotNull List<? extends File> baseClassPath, @NotNull Iterable<? extends Resolver> resolvers) {
        Intrinsics.checkParameterIsNotNull(baseClassPath, (String)"baseClassPath");
        Intrinsics.checkParameterIsNotNull(resolvers, (String)"resolvers");
        this.baseClassPath = baseClassPath;
        this.resolvers = CollectionsKt.toMutableList(resolvers);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/script/util/KotlinAnnotatedScriptDependenciesResolver$ResolvedDependencies;", "Lorg/jetbrains/kotlin/script/KotlinScriptExternalDependencies;", "previousDependencies", "depsFromAnnotations", "", "Ljava/io/File;", "(Lorg/jetbrains/kotlin/script/util/KotlinAnnotatedScriptDependenciesResolver;Lorg/jetbrains/kotlin/script/KotlinScriptExternalDependencies;Ljava/util/List;)V", "classpath", "getClasspath", "()Ljava/util/List;", "imports", "", "getImports", "kotlin-script-util"})
    public final class ResolvedDependencies
    implements KotlinScriptExternalDependencies {
        @NotNull
        private final List<File> classpath;
        @NotNull
        private final List<String> imports;

        @NotNull
        public List<File> getClasspath() {
            return this.classpath;
        }

        @NotNull
        public List<String> getImports() {
            return this.imports;
        }

        public ResolvedDependencies(@NotNull KotlinScriptExternalDependencies previousDependencies, List<? extends File> depsFromAnnotations) {
            Intrinsics.checkParameterIsNotNull(depsFromAnnotations, (String)"depsFromAnnotations");
            this.classpath = KotlinAnnotatedScriptDependenciesResolver.this.resolvers.isEmpty() ? KotlinAnnotatedScriptDependenciesResolver.this.getBaseClassPath() : CollectionsKt.plus((Collection)KotlinAnnotatedScriptDependenciesResolver.this.getBaseClassPath(), (Iterable)depsFromAnnotations);
            this.imports = previousDependencies != null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)(DependsOn.class.getPackage().getName() + ".*"));
        }

        @Nullable
        public String getJavaHome() {
            return KotlinScriptExternalDependencies.DefaultImpls.getJavaHome((KotlinScriptExternalDependencies)this);
        }

        @NotNull
        public Iterable<File> getScripts() {
            return KotlinScriptExternalDependencies.DefaultImpls.getScripts((KotlinScriptExternalDependencies)this);
        }

        @NotNull
        public Iterable<File> getSources() {
            return KotlinScriptExternalDependencies.DefaultImpls.getSources((KotlinScriptExternalDependencies)this);
        }

        public int compareTo(@NotNull KotlinScriptExternalDependencies other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return KotlinScriptExternalDependencies.DefaultImpls.compareTo((KotlinScriptExternalDependencies)this, (KotlinScriptExternalDependencies)other);
        }
    }
}

