/*
 * Copyright 2010-2025 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

@file:Suppress("unused")
package kotlinx.android.parcel

import android.os.Parcel

/**
 * The base interface for custom [Parcelize] serializers.
 */
interface Parceler<T> {
    /**
     * Writes the [T] instance state to the [parcel].
     */
    fun T.write(parcel: Parcel, flags: Int)

    /**
     * Reads the [T] instance state from the [parcel], constructs the new [T] instance and returns it.
     */
    fun create(parcel: Parcel): T

    /**
     * Returns a new [Array]<T> with the given array [size].
     */
    fun newArray(size: Int): Array<T> {
        throw NotImplementedError("Generated by Android Extensions automatically")
    }
}
