/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.structure;

import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;
import kotlin.reflect.jvm.internal.structure.ReflectJavaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lkotlin/reflect/jvm/internal/structure/ReflectJavaWildcardType;", "Lkotlin/reflect/jvm/internal/structure/ReflectJavaType;", "Lkotlin/reflect/jvm/internal/impl/load/java/structure/JavaWildcardType;", "reflectType", "Ljava/lang/reflect/WildcardType;", "(Ljava/lang/reflect/WildcardType;)V", "bound", "getBound", "()Lkotlin/reflect/jvm/internal/structure/ReflectJavaType;", "isExtends", "", "()Z", "getReflectType", "()Ljava/lang/reflect/WildcardType;", "descriptors.runtime"})
public final class ReflectJavaWildcardType
extends ReflectJavaType
implements JavaWildcardType {
    @NotNull
    private final WildcardType reflectType;

    @Override
    @Nullable
    public ReflectJavaType getBound() {
        ReflectJavaType reflectJavaType;
        Type[] upperBounds2 = this.getReflectType().getUpperBounds();
        Type[] lowerBounds = this.getReflectType().getLowerBounds();
        if (((Object[])upperBounds2).length > 1 || ((Object[])lowerBounds).length > 1) {
            throw (Throwable)new UnsupportedOperationException("Wildcard types with many bounds are not yet supported: " + this.getReflectType());
        }
        if (((Object[])lowerBounds).length == 1) {
            Intrinsics.checkExpressionValueIsNotNull(lowerBounds, "lowerBounds");
            Object object = ArraysKt.single((Object[])lowerBounds);
            Intrinsics.checkExpressionValueIsNotNull(object, "lowerBounds.single()");
            reflectJavaType = ReflectJavaType.Factory.create((Type)object);
        } else if (((Object[])upperBounds2).length == 1) {
            Intrinsics.checkExpressionValueIsNotNull(upperBounds2, "upperBounds");
            Object object = ArraysKt.single((Object[])upperBounds2);
            Type ub = (Type)object;
            if (Intrinsics.areEqual(ub, Object.class) ^ true) {
                Type type2 = ub;
                Intrinsics.checkExpressionValueIsNotNull(type2, "ub");
                reflectJavaType = ReflectJavaType.Factory.create(type2);
            } else {
                reflectJavaType = null;
            }
        } else {
            reflectJavaType = null;
        }
        return reflectJavaType;
    }

    @Override
    public boolean isExtends() {
        Type[] typeArray = this.getReflectType().getUpperBounds();
        Intrinsics.checkExpressionValueIsNotNull(typeArray, "reflectType.upperBounds");
        return Intrinsics.areEqual((Type)ArraysKt.firstOrNull((Object[])typeArray), Object.class) ^ true;
    }

    @Override
    @NotNull
    protected WildcardType getReflectType() {
        return this.reflectType;
    }

    public ReflectJavaWildcardType(@NotNull WildcardType reflectType) {
        Intrinsics.checkParameterIsNotNull(reflectType, "reflectType");
        this.reflectType = reflectType;
    }
}

