/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;

public final class FqNameUnsafe {
    private static final Name ROOT_NAME = Name.special("<root>");
    private static final Pattern SPLIT_BY_DOTS = Pattern.compile("\\.");
    private static final Function1<String, Name> STRING_TO_NAME = new Function1<String, Name>(){

        @Override
        public Name invoke(String name) {
            return Name.guessByFirstCharacter(name);
        }
    };
    @NotNull
    private final String fqName;
    private transient FqName safe;
    private transient FqNameUnsafe parent;
    private transient Name shortName;

    FqNameUnsafe(@NotNull String fqName2, @NotNull FqName safe) {
        this.fqName = fqName2;
        this.safe = safe;
    }

    public FqNameUnsafe(@NotNull String fqName2) {
        this.fqName = fqName2;
    }

    private FqNameUnsafe(@NotNull String fqName2, FqNameUnsafe parent, Name shortName) {
        this.fqName = fqName2;
        this.parent = parent;
        this.shortName = shortName;
    }

    private void compute() {
        int lastDot = this.fqName.lastIndexOf(46);
        if (lastDot >= 0) {
            this.shortName = Name.guessByFirstCharacter(this.fqName.substring(lastDot + 1));
            this.parent = new FqNameUnsafe(this.fqName.substring(0, lastDot));
        } else {
            this.shortName = Name.guessByFirstCharacter(this.fqName);
            this.parent = FqName.ROOT.toUnsafe();
        }
    }

    @NotNull
    public String asString() {
        return this.fqName;
    }

    public boolean isSafe() {
        return this.safe != null || this.asString().indexOf(60) < 0;
    }

    @NotNull
    public FqName toSafe() {
        if (this.safe != null) {
            return this.safe;
        }
        this.safe = new FqName(this);
        return this.safe;
    }

    public boolean isRoot() {
        return this.fqName.isEmpty();
    }

    @NotNull
    public FqNameUnsafe parent() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        return this.parent;
    }

    @NotNull
    public FqNameUnsafe child(@NotNull Name name) {
        String childFqName = this.isRoot() ? name.asString() : this.fqName + "." + name.asString();
        return new FqNameUnsafe(childFqName, this, name);
    }

    @NotNull
    public Name shortName() {
        if (this.shortName != null) {
            return this.shortName;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.compute();
        return this.shortName;
    }

    @NotNull
    public Name shortNameOrSpecial() {
        if (this.isRoot()) {
            return ROOT_NAME;
        }
        return this.shortName();
    }

    @NotNull
    public List<Name> pathSegments() {
        return this.isRoot() ? Collections.emptyList() : ArraysKt.map(SPLIT_BY_DOTS.split(this.fqName), STRING_TO_NAME);
    }

    public boolean startsWith(@NotNull Name segment) {
        int firstDot = this.fqName.indexOf(46);
        return !this.isRoot() && this.fqName.regionMatches(0, segment.asString(), 0, firstDot == -1 ? this.fqName.length() : firstDot);
    }

    @NotNull
    public static FqNameUnsafe topLevel(@NotNull Name shortName) {
        return new FqNameUnsafe(shortName.asString(), FqName.ROOT.toUnsafe(), shortName);
    }

    @NotNull
    public String toString() {
        return this.isRoot() ? ROOT_NAME.asString() : this.fqName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FqNameUnsafe)) {
            return false;
        }
        FqNameUnsafe that = (FqNameUnsafe)o;
        return this.fqName.equals(that.fqName);
    }

    public int hashCode() {
        return this.fqName.hashCode();
    }
}

