/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.internal.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.components.ReflectKotlinClassKt;
import kotlin.reflect.jvm.internal.components.SignatureSerializer;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.structure.ReflectClassUtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\r\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J$\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001a\u0010\u0018\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0019"}, d2={"Lkotlin/reflect/jvm/internal/components/ReflectClassStructure;", "", "()V", "loadClassAnnotations", "", "klass", "Ljava/lang/Class;", "visitor", "Lkotlin/reflect/jvm/internal/impl/load/kotlin/KotlinJvmBinaryClass$AnnotationVisitor;", "loadConstructorAnnotations", "memberVisitor", "Lkotlin/reflect/jvm/internal/impl/load/kotlin/KotlinJvmBinaryClass$MemberVisitor;", "loadFieldAnnotations", "loadMethodAnnotations", "processAnnotation", "annotation", "", "processAnnotationArgumentValue", "Lkotlin/reflect/jvm/internal/impl/load/kotlin/KotlinJvmBinaryClass$AnnotationArgumentVisitor;", "name", "Lkotlin/reflect/jvm/internal/impl/name/Name;", "value", "processAnnotationArguments", "annotationType", "visitMembers", "descriptors.runtime"})
final class ReflectClassStructure {
    public static final ReflectClassStructure INSTANCE;

    public final void loadClassAnnotations(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
        Annotation[] annotationArray = klass.getDeclaredAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation annotation;
            Annotation annotation2 = annotation = annotationArray[i];
            Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
            this.processAnnotation(visitor2, annotation2);
        }
        visitor2.visitEnd();
    }

    public final void visitMembers(@NotNull Class<?> klass, @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Intrinsics.checkParameterIsNotNull(klass, "klass");
        Intrinsics.checkParameterIsNotNull(memberVisitor, "memberVisitor");
        this.loadMethodAnnotations(klass, memberVisitor);
        this.loadConstructorAnnotations(klass, memberVisitor);
        this.loadFieldAnnotations(klass, memberVisitor);
    }

    private final void loadMethodAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Method[] methodArray = klass.getDeclaredMethods();
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Method method;
            Method method2 = method = methodArray[i];
            Intrinsics.checkExpressionValueIsNotNull(method2, "method");
            Name name = Name.identifier(method2.getName());
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(method.name)");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.methodDesc(method)) == null) {
                continue;
            }
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Annotation annotation2 = annotation;
                Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] annotationArray = method.getParameterAnnotations();
            Intrinsics.checkExpressionValueIsNotNull(annotationArray, "method.parameterAnnotations");
            for (IndexedValue<Object> indexedValue : ArraysKt.withIndex((Object[])annotationArray)) {
                int parameterIndex = indexedValue.component1();
                for (Annotation annotation : (Annotation[])indexedValue.component2()) {
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                    Class<KClass<Annotation>> annotationType = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation));
                    ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                    Annotation annotation3 = annotation;
                    Intrinsics.checkExpressionValueIsNotNull(annotation3, "annotation");
                    if (visitor2.visitParameterAnnotation(parameterIndex, classId, new ReflectAnnotationSource(annotation3)) == null) continue;
                    KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                    INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadConstructorAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        for (Constructor<?> constructor : klass.getDeclaredConstructors()) {
            Object[] objectArray;
            KotlinJvmBinaryClass.MethodAnnotationVisitor visitor2;
            Name name = Name.special("<init>");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.special(\"<init>\")");
            Constructor<?> constructor2 = constructor;
            Intrinsics.checkExpressionValueIsNotNull(constructor2, "constructor");
            if (memberVisitor.visitMethod(name, SignatureSerializer.INSTANCE.constructorDesc(constructor2)) == null) {
                continue;
            }
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor = visitor2;
                Annotation annotation2 = annotation;
                Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
                this.processAnnotation(annotationVisitor, annotation2);
            }
            Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
            Intrinsics.checkExpressionValueIsNotNull(parameterAnnotations, "parameterAnnotations");
            Object[] objectArray2 = objectArray = (Object[])parameterAnnotations;
            if (!(objectArray2.length == 0)) {
                int shift = ((Object[])constructor.getParameterTypes()).length - ((Object[])parameterAnnotations).length;
                for (IndexedValue<Object> indexedValue : ArraysKt.withIndex((Object[])parameterAnnotations)) {
                    int parameterIndex = indexedValue.component1();
                    for (Annotation annotation : (Annotation[])indexedValue.component2()) {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
                        Class<KClass<Annotation>> annotationType = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation));
                        ClassId classId = ReflectClassUtilKt.getClassId(annotationType);
                        Annotation annotation3 = annotation;
                        Intrinsics.checkExpressionValueIsNotNull(annotation3, "annotation");
                        if (visitor2.visitParameterAnnotation(parameterIndex + shift, classId, new ReflectAnnotationSource(annotation3)) == null) continue;
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor;
                        INSTANCE.processAnnotationArguments(it, annotation, annotationType);
                    }
                }
            }
            visitor2.visitEnd();
        }
    }

    private final void loadFieldAnnotations(Class<?> klass, KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        Field[] fieldArray = klass.getDeclaredFields();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            KotlinJvmBinaryClass.AnnotationVisitor visitor2;
            Field field;
            Field field2 = field = fieldArray[i];
            Intrinsics.checkExpressionValueIsNotNull(field2, "field");
            Name name = Name.identifier(field2.getName());
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(field.name)");
            if (memberVisitor.visitField(name, SignatureSerializer.INSTANCE.fieldDesc(field), null) == null) {
                continue;
            }
            Annotation[] annotationArray = field.getDeclaredAnnotations();
            int n2 = annotationArray.length;
            for (int j = 0; j < n2; ++j) {
                Annotation annotation;
                Annotation annotation2 = annotation = annotationArray[j];
                Intrinsics.checkExpressionValueIsNotNull(annotation2, "annotation");
                this.processAnnotation(visitor2, annotation2);
            }
            visitor2.visitEnd();
        }
    }

    private final void processAnnotation(KotlinJvmBinaryClass.AnnotationVisitor visitor2, Annotation annotation) {
        block0: {
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor;
            Class<KClass<Annotation>> annotationType = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(annotation));
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor2 = visitor2.visitAnnotation(ReflectClassUtilKt.getClassId(annotationType), new ReflectAnnotationSource(annotation));
            if (annotationArgumentVisitor2 == null) break block0;
            KotlinJvmBinaryClass.AnnotationArgumentVisitor it = annotationArgumentVisitor = annotationArgumentVisitor2;
            INSTANCE.processAnnotationArguments(it, annotation, annotationType);
        }
    }

    private final void processAnnotationArguments(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Annotation annotation, Class<?> annotationType) {
        for (Method method : annotationType.getDeclaredMethods()) {
            Object object;
            block3: {
                try {
                    if (method.invoke((Object)annotation, new Object[0]) != null) break block3;
                    Intrinsics.throwNpe();
                }
                catch (IllegalAccessException e) {
                    continue;
                }
            }
            Object value = object;
            Method method2 = method;
            Intrinsics.checkExpressionValueIsNotNull(method2, "method");
            Name name = Name.identifier(method2.getName());
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(method.name)");
            this.processAnnotationArgumentValue(visitor2, name, value);
        }
        visitor2.visitEnd();
    }

    private final void processAnnotationArgumentValue(KotlinJvmBinaryClass.AnnotationArgumentVisitor visitor2, Name name, Object value) {
        Class<?> clazz = value.getClass();
        if (ReflectKotlinClassKt.access$getTYPES_ELIGIBLE_FOR_SIMPLE_VISIT$p().contains(clazz)) {
            visitor2.visit(name, value);
        } else if (ReflectClassUtilKt.isEnumClassOrSpecializedEnumEntryClass(clazz)) {
            Class<?> clazz2 = clazz.isEnum() ? clazz : clazz.getEnclosingClass();
            Intrinsics.checkExpressionValueIsNotNull(clazz2, "(if (clazz.isEnum) clazz\u2026lse clazz.enclosingClass)");
            ClassId classId = ReflectClassUtilKt.getClassId(clazz2);
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
            }
            Name name2 = Name.identifier(((Enum)object).name());
            Intrinsics.checkExpressionValueIsNotNull(name2, "Name.identifier((value as Enum<*>).name)");
            visitor2.visitEnum(name, classId, name2);
        } else if (Annotation.class.isAssignableFrom(clazz)) {
            Class annotationClass;
            Class<?>[] classArray = clazz.getInterfaces();
            Intrinsics.checkExpressionValueIsNotNull(classArray, "clazz.interfaces");
            Class clazz3 = annotationClass = (Class)ArraysKt.single((Object[])classArray);
            Intrinsics.checkExpressionValueIsNotNull(clazz3, "annotationClass");
            KotlinJvmBinaryClass.AnnotationArgumentVisitor annotationArgumentVisitor = visitor2.visitAnnotation(name, ReflectClassUtilKt.getClassId(clazz3));
            if (annotationArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArgumentVisitor v = annotationArgumentVisitor;
            Object object = value;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Annotation");
            }
            this.processAnnotationArguments(v, (Annotation)object, annotationClass);
        } else if (clazz.isArray()) {
            Class<?> componentType;
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor annotationArrayArgumentVisitor = visitor2.visitArray(name);
            if (annotationArrayArgumentVisitor == null) {
                return;
            }
            KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor v = annotationArrayArgumentVisitor;
            Class<?> clazz4 = componentType = clazz.getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz4, "componentType");
            if (clazz4.isEnum()) {
                ClassId enumClassId = ReflectClassUtilKt.getClassId(componentType);
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                Object[] objectArray = (Object[])object;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object element;
                    Object object2 = element = objectArray[i];
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Enum<*>");
                    }
                    Name name3 = Name.identifier(((Enum)object2).name());
                    Intrinsics.checkExpressionValueIsNotNull(name3, "Name.identifier((element as Enum<*>).name)");
                    v.visitEnum(enumClassId, name3);
                }
            } else {
                Object object = value;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<*>");
                }
                for (Object element : (Object[])object) {
                    v.visit(element);
                }
            }
            v.visitEnd();
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported annotation argument value (" + clazz + "): " + value);
        }
    }

    private ReflectClassStructure() {
    }

    static {
        ReflectClassStructure reflectClassStructure;
        INSTANCE = reflectClassStructure = new ReflectClassStructure();
    }
}

