/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.tree.deserializer;

import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.Attributes;
import kotlin.metadata.ClassKind;
import kotlin.metadata.KmAnnotation;
import kotlin.metadata.KmClass;
import kotlin.metadata.internal.common.KmModuleFragment;
import kotlinx.metadata.klib.KlibEnumEntry;
import kotlinx.metadata.klib.KlibExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;
import org.jetbrains.kotlin.commonizer.cir.CirName;
import org.jetbrains.kotlin.commonizer.utils.NamesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006J$\u0010\u0013\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\u0015Rn\u0010\u0004\u001ab\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b \u0007*/\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b0\u000b\u00a2\u0006\u0002\b\n0\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess;", "", "<init>", "()V", "groupedByParentClassId", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess$ClassEntry;", "Lorg/jetbrains/annotations/NotNull;", "", "addClassesFromFragment", "", "fragment", "Lkotlin/metadata/internal/common/KmModuleFragment;", "classesInScope", "", "parentClassId", "forEachClassInScope", "block", "Lkotlin/Function1;", "ClassEntry", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nClassesToProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassesToProcess.kt\norg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,72:1\n1869#2:73\n1869#2,2:74\n1870#2:76\n1869#2,2:79\n216#3,2:77\n*S KotlinDebug\n*F\n+ 1 ClassesToProcess.kt\norg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess\n*L\n41#1:73\n46#1:74,2\n41#1:76\n69#1:79,2\n57#1:77,2\n*E\n"})
public final class ClassesToProcess {
    @NotNull
    private final Map<CirEntityId, List<ClassEntry>> groupedByParentClassId;

    public ClassesToProcess() {
        Map map = FactoryMap.create(arg_0 -> ClassesToProcess.groupedByParentClassId$lambda$1(ClassesToProcess::groupedByParentClassId$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"create(...)");
        this.groupedByParentClassId = map;
    }

    public final void addClassesFromFragment(@NotNull KmModuleFragment fragment) {
        Object element$iv;
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        LinkedHashMap klibEnumEntries = new LinkedHashMap();
        HashSet regularClassIds = new HashSet();
        Object $this$forEach$iv = fragment.getClasses();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            CirEntityId parentClassId;
            element$iv = iterator2.next();
            KmClass clazz2 = (KmClass)element$iv;
            boolean bl = false;
            CirEntityId classId = CirEntityId.Companion.create(clazz2.getName());
            CirEntityId cirEntityId = classId.getParentEntityId();
            if (cirEntityId == null) {
                cirEntityId = parentClassId = NamesKt.getNON_EXISTING_CLASSIFIER_ID();
            }
            if (Attributes.getKind(clazz2) == ClassKind.ENUM_CLASS) {
                Iterable $this$forEach$iv2 = KlibExtensionsKt.getKlibEnumEntries(clazz2);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    KlibEnumEntry entry = (KlibEnumEntry)element$iv2;
                    boolean bl2 = false;
                    CirEntityId enumEntryId = classId.createNestedEntityId(CirName.Companion.create(entry.getName()));
                    ((Map)klibEnumEntries).put(enumEntryId, new ClassEntry.EnumEntry(enumEntryId, entry.getAnnotations(), classId, clazz2));
                }
            }
            Object object = MapsKt.getValue(this.groupedByParentClassId, (Object)parentClassId);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            Collection collection = (Collection)object;
            collection.add(new ClassEntry.RegularClassEntry(classId, clazz2));
            ((Collection)regularClassIds).add(classId);
        }
        $this$forEach$iv = klibEnumEntries;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            CirEntityId enumEntryId = (CirEntityId)object.getKey();
            ClassEntry.EnumEntry enumEntry = (ClassEntry.EnumEntry)object.getValue();
            if (regularClassIds.contains(enumEntryId)) continue;
            Object object2 = MapsKt.getValue(this.groupedByParentClassId, (Object)enumEntry.getEnumClassId());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getValue(...)");
            ((Collection)object2).add(enumEntry);
        }
    }

    @NotNull
    public final List<ClassEntry> classesInScope(@Nullable CirEntityId parentClassId) {
        List list;
        CirEntityId cirEntityId = parentClassId;
        if (cirEntityId == null) {
            cirEntityId = NamesKt.getNON_EXISTING_CLASSIFIER_ID();
        }
        if ((list = this.groupedByParentClassId.get(cirEntityId)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void forEachClassInScope(@Nullable CirEntityId parentClassId, @NotNull Function1<? super ClassEntry, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Iterable $this$forEach$iv = this.classesInScope(parentClassId);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClassEntry classEntry = (ClassEntry)element$iv;
            boolean bl = false;
            block.invoke((Object)classEntry);
        }
    }

    private static final List groupedByParentClassId$lambda$0(CirEntityId it) {
        return new ArrayList();
    }

    private static final List groupedByParentClassId$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess$ClassEntry;", "", "<init>", "()V", "classId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "getClassId", "()Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "RegularClassEntry", "EnumEntry", "Lorg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess$ClassEntry$EnumEntry;", "Lorg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess$ClassEntry$RegularClassEntry;", "kotlin-klib-commonizer"})
    public static abstract class ClassEntry {
        private ClassEntry() {
        }

        @NotNull
        public abstract CirEntityId getClassId();

        public /* synthetic */ ClassEntry(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess$ClassEntry$EnumEntry;", "Lorg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess$ClassEntry;", "classId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "annotations", "", "Lkotlin/metadata/KmAnnotation;", "enumClassId", "enumClass", "Lkotlin/metadata/KmClass;", "<init>", "(Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;Ljava/util/List;Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;Lkotlin/metadata/KmClass;)V", "getClassId", "()Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "getAnnotations", "()Ljava/util/List;", "getEnumClassId", "getEnumClass", "()Lkotlin/metadata/KmClass;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-klib-commonizer"})
        public static final class EnumEntry
        extends ClassEntry {
            @NotNull
            private final CirEntityId classId;
            @NotNull
            private final List<KmAnnotation> annotations;
            @NotNull
            private final CirEntityId enumClassId;
            @NotNull
            private final KmClass enumClass;

            public EnumEntry(@NotNull CirEntityId classId, @NotNull List<KmAnnotation> annotations2, @NotNull CirEntityId enumClassId, @NotNull KmClass enumClass) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
                Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                Intrinsics.checkNotNullParameter((Object)enumClass, (String)"enumClass");
                super(null);
                this.classId = classId;
                this.annotations = annotations2;
                this.enumClassId = enumClassId;
                this.enumClass = enumClass;
            }

            @Override
            @NotNull
            public CirEntityId getClassId() {
                return this.classId;
            }

            @NotNull
            public final List<KmAnnotation> getAnnotations() {
                return this.annotations;
            }

            @NotNull
            public final CirEntityId getEnumClassId() {
                return this.enumClassId;
            }

            @NotNull
            public final KmClass getEnumClass() {
                return this.enumClass;
            }

            @NotNull
            public final CirEntityId component1() {
                return this.classId;
            }

            @NotNull
            public final List<KmAnnotation> component2() {
                return this.annotations;
            }

            @NotNull
            public final CirEntityId component3() {
                return this.enumClassId;
            }

            @NotNull
            public final KmClass component4() {
                return this.enumClass;
            }

            @NotNull
            public final EnumEntry copy(@NotNull CirEntityId classId, @NotNull List<KmAnnotation> annotations2, @NotNull CirEntityId enumClassId, @NotNull KmClass enumClass) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
                Intrinsics.checkNotNullParameter((Object)enumClassId, (String)"enumClassId");
                Intrinsics.checkNotNullParameter((Object)enumClass, (String)"enumClass");
                return new EnumEntry(classId, annotations2, enumClassId, enumClass);
            }

            public static /* synthetic */ EnumEntry copy$default(EnumEntry enumEntry, CirEntityId cirEntityId, List list, CirEntityId cirEntityId2, KmClass kmClass, int n, Object object) {
                if ((n & 1) != 0) {
                    cirEntityId = enumEntry.classId;
                }
                if ((n & 2) != 0) {
                    list = enumEntry.annotations;
                }
                if ((n & 4) != 0) {
                    cirEntityId2 = enumEntry.enumClassId;
                }
                if ((n & 8) != 0) {
                    kmClass = enumEntry.enumClass;
                }
                return enumEntry.copy(cirEntityId, list, cirEntityId2, kmClass);
            }

            @NotNull
            public String toString() {
                return "EnumEntry(classId=" + this.classId + ", annotations=" + this.annotations + ", enumClassId=" + this.enumClassId + ", enumClass=" + this.enumClass + ')';
            }

            public int hashCode() {
                int result = this.classId.hashCode();
                result = result * 31 + ((Object)this.annotations).hashCode();
                result = result * 31 + this.enumClassId.hashCode();
                result = result * 31 + this.enumClass.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof EnumEntry)) {
                    return false;
                }
                EnumEntry enumEntry = (EnumEntry)other;
                if (!Intrinsics.areEqual((Object)this.classId, (Object)enumEntry.classId)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.annotations, enumEntry.annotations)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.enumClassId, (Object)enumEntry.enumClassId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.enumClass, (Object)enumEntry.enumClass);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess$ClassEntry$RegularClassEntry;", "Lorg/jetbrains/kotlin/commonizer/tree/deserializer/ClassesToProcess$ClassEntry;", "classId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "clazz", "Lkotlin/metadata/KmClass;", "<init>", "(Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;Lkotlin/metadata/KmClass;)V", "getClassId", "()Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "getClazz", "()Lkotlin/metadata/KmClass;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-klib-commonizer"})
        public static final class RegularClassEntry
        extends ClassEntry {
            @NotNull
            private final CirEntityId classId;
            @NotNull
            private final KmClass clazz;

            public RegularClassEntry(@NotNull CirEntityId classId, @NotNull KmClass clazz2) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                Intrinsics.checkNotNullParameter((Object)clazz2, (String)"clazz");
                super(null);
                this.classId = classId;
                this.clazz = clazz2;
            }

            @Override
            @NotNull
            public CirEntityId getClassId() {
                return this.classId;
            }

            @NotNull
            public final KmClass getClazz() {
                return this.clazz;
            }

            @NotNull
            public final CirEntityId component1() {
                return this.classId;
            }

            @NotNull
            public final KmClass component2() {
                return this.clazz;
            }

            @NotNull
            public final RegularClassEntry copy(@NotNull CirEntityId classId, @NotNull KmClass clazz2) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                Intrinsics.checkNotNullParameter((Object)clazz2, (String)"clazz");
                return new RegularClassEntry(classId, clazz2);
            }

            public static /* synthetic */ RegularClassEntry copy$default(RegularClassEntry regularClassEntry, CirEntityId cirEntityId, KmClass kmClass, int n, Object object) {
                if ((n & 1) != 0) {
                    cirEntityId = regularClassEntry.classId;
                }
                if ((n & 2) != 0) {
                    kmClass = regularClassEntry.clazz;
                }
                return regularClassEntry.copy(cirEntityId, kmClass);
            }

            @NotNull
            public String toString() {
                return "RegularClassEntry(classId=" + this.classId + ", clazz=" + this.clazz + ')';
            }

            public int hashCode() {
                int result = this.classId.hashCode();
                result = result * 31 + this.clazz.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RegularClassEntry)) {
                    return false;
                }
                RegularClassEntry regularClassEntry = (RegularClassEntry)other;
                if (!Intrinsics.areEqual((Object)this.classId, (Object)regularClassEntry.classId)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.clazz, (Object)regularClassEntry.clazz);
            }
        }
    }
}

