/*
 * Decompiled with CFR 0.152.
 */
package kotlin.metadata.internal.library;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.metadata.internal.konan.file.File;
import kotlin.metadata.internal.konan.file.FileKt;
import kotlin.metadata.internal.konan.file.ZipFileSystemAccessor;
import kotlin.metadata.internal.konan.file.ZipUtilKt;
import kotlin.metadata.internal.library.KlibComponentLayout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u000f\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\bH&J'\u0010\t\u001a\u0002H\n\"\u0004\b\u0001\u0010\n2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\n0\bH&\u00a2\u0006\u0002\u0010\u000bJ-\u0010\f\u001a\u0002H\n\"\u0004\b\u0001\u0010\n2\u0006\u0010\r\u001a\u0002H\n2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\n0\b\u00a2\u0006\u0002\u0010\u000e\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lkotlin/metadata/internal/library/KlibLayoutReader;", "KCL", "Lkotlin/metadata/internal/library/KlibComponentLayout;", "", "()V", "readExtractingToTemp", "Lkotlin/metadata/internal/konan/file/File;", "readAction", "Lkotlin/Function1;", "readInPlace", "T", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readInPlaceOrFallback", "fallbackValueInCaseOfException", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "FromDirectory", "FromZipArchive", "Lkotlin/metadata/internal/library/KlibLayoutReader$FromDirectory;", "Lkotlin/metadata/internal/library/KlibLayoutReader$FromZipArchive;", "kotlin-util-klib"})
public abstract class KlibLayoutReader<KCL extends KlibComponentLayout> {
    private KlibLayoutReader() {
    }

    public abstract <T> T readInPlace(@NotNull Function1<? super KCL, ? extends T> var1);

    public final <T> T readInPlaceOrFallback(T fallbackValueInCaseOfException, @NotNull Function1<? super KCL, ? extends T> readAction) {
        T t;
        Intrinsics.checkNotNullParameter(readAction, (String)"readAction");
        try {
            t = this.readInPlace(readAction);
        }
        catch (IOException _) {
            t = fallbackValueInCaseOfException;
        }
        return t;
    }

    @NotNull
    public abstract File readExtractingToTemp(@NotNull Function1<? super KCL, File> var1);

    public /* synthetic */ KlibLayoutReader(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J'\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0002\u0010\u000e2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u000e0\u0007H\u0016\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\t\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0010"}, d2={"Lkotlin/metadata/internal/library/KlibLayoutReader$FromDirectory;", "KCL", "Lkotlin/metadata/internal/library/KlibComponentLayout;", "Lkotlin/metadata/internal/library/KlibLayoutReader;", "klibDir", "Lkotlin/metadata/internal/konan/file/File;", "layoutBuilder", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)V", "layout", "Lkotlin/metadata/internal/library/KlibComponentLayout;", "readExtractingToTemp", "readAction", "readInPlace", "T", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-util-klib"})
    public static final class FromDirectory<KCL extends KlibComponentLayout>
    extends KlibLayoutReader<KCL> {
        @NotNull
        private final KCL layout;

        public FromDirectory(@NotNull File klibDir, @NotNull Function1<? super File, ? extends KCL> layoutBuilder) {
            Intrinsics.checkNotNullParameter((Object)klibDir, (String)"klibDir");
            Intrinsics.checkNotNullParameter(layoutBuilder, (String)"layoutBuilder");
            super(null);
            this.layout = (KlibComponentLayout)layoutBuilder.invoke((Object)klibDir);
        }

        @Override
        public <T> T readInPlace(@NotNull Function1<? super KCL, ? extends T> readAction) {
            Intrinsics.checkNotNullParameter(readAction, (String)"readAction");
            return (T)readAction.invoke(this.layout);
        }

        @Override
        @NotNull
        public File readExtractingToTemp(@NotNull Function1<? super KCL, File> readAction) {
            Intrinsics.checkNotNullParameter(readAction, (String)"readAction");
            return (File)readAction.invoke(this.layout);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00050\tH\u0016J'\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0002\u0010\u000e2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u0002H\u000e0\tH\u0016\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkotlin/metadata/internal/library/KlibLayoutReader$FromZipArchive;", "KCL", "Lkotlin/metadata/internal/library/KlibComponentLayout;", "Lkotlin/metadata/internal/library/KlibLayoutReader;", "klibArchive", "Lkotlin/metadata/internal/konan/file/File;", "zipFileSystemAccessor", "Lkotlin/metadata/internal/konan/file/ZipFileSystemAccessor;", "layoutBuilder", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/konan/file/File;Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;Lkotlin/jvm/functions/Function1;)V", "readExtractingToTemp", "readAction", "readInPlace", "T", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-util-klib"})
    public static final class FromZipArchive<KCL extends KlibComponentLayout>
    extends KlibLayoutReader<KCL> {
        @NotNull
        private final File klibArchive;
        @NotNull
        private final ZipFileSystemAccessor zipFileSystemAccessor;
        @NotNull
        private final Function1<File, KCL> layoutBuilder;

        public FromZipArchive(@NotNull File klibArchive, @NotNull ZipFileSystemAccessor zipFileSystemAccessor, @NotNull Function1<? super File, ? extends KCL> layoutBuilder) {
            Intrinsics.checkNotNullParameter((Object)klibArchive, (String)"klibArchive");
            Intrinsics.checkNotNullParameter((Object)zipFileSystemAccessor, (String)"zipFileSystemAccessor");
            Intrinsics.checkNotNullParameter(layoutBuilder, (String)"layoutBuilder");
            super(null);
            this.klibArchive = klibArchive;
            this.zipFileSystemAccessor = zipFileSystemAccessor;
            this.layoutBuilder = layoutBuilder;
        }

        @Override
        public <T> T readInPlace(@NotNull Function1<? super KCL, ? extends T> readAction) {
            Intrinsics.checkNotNullParameter(readAction, (String)"readAction");
            return this.zipFileSystemAccessor.withZipFileSystem(this.klibArchive, (Function1)new Function1<FileSystem, T>(readAction, this){
                final /* synthetic */ Function1<KCL, T> $readAction;
                final /* synthetic */ FromZipArchive<KCL> this$0;
                {
                    this.$readAction = $readAction;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final T invoke(FileSystem zipFileSystem) {
                    Intrinsics.checkNotNullParameter((Object)zipFileSystem, (String)"zipFileSystem");
                    return (T)this.$readAction.invoke(FromZipArchive.access$getLayoutBuilder$p(this.this$0).invoke((Object)ZipUtilKt.file(zipFileSystem, "/")));
                }
            });
        }

        @Override
        @NotNull
        public File readExtractingToTemp(@NotNull Function1<? super KCL, File> readAction) {
            Intrinsics.checkNotNullParameter(readAction, (String)"readAction");
            return (File)this.readInPlace((Function1)new Function1<KCL, File>(readAction){
                final /* synthetic */ Function1<KCL, File> $readAction;
                {
                    this.$readAction = $readAction;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final File invoke(KCL layout) {
                    File file;
                    Intrinsics.checkNotNullParameter(layout, (String)"layout");
                    File fileOrDirectory = (File)this.$readAction.invoke(layout);
                    if (fileOrDirectory.isDirectory()) {
                        File tempDir = FileKt.createTempDir(fileOrDirectory.getName());
                        tempDir.deleteOnExitRecursively();
                        Iterable $this$forEach$iv = fileOrDirectory.getListFiles();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            File file2 = (File)element$iv;
                            boolean bl = false;
                            file2.copyTo(tempDir.child(file2.getName()));
                        }
                        file = tempDir;
                    } else if (fileOrDirectory.isFile()) {
                        void var3_4;
                        File tempFile = FileKt.createTempFile$default(fileOrDirectory.getName(), null, 2, null);
                        tempFile.deleteOnExitRecursively();
                        fileOrDirectory.copyTo(tempFile);
                        file = var3_4;
                    } else {
                        if (fileOrDirectory.getExists()) {
                            throw new ZipException("Non-existing file or directory in KLIB archive: " + fileOrDirectory);
                        }
                        throw new ZipException("Unsupported type of the file system object in KLIB archive: " + fileOrDirectory);
                    }
                    return file;
                }
            });
        }

        public static final /* synthetic */ Function1 access$getLayoutBuilder$p(FromZipArchive $this) {
            return $this.layoutBuilder;
        }
    }
}

