/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.mergedtree;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirClassifier;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;
import org.jetbrains.kotlin.commonizer.mergedtree.CirClassifierIndex;
import org.jetbrains.kotlin.commonizer.tree.CirTreeTypeAlias;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001BC\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/commonizer/mergedtree/CirClassifierIndexImpl;", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirClassifierIndex;", "allClassifierIds", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "classifiersById", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassifier;", "typeAliasesByUnderlyingType", "", "Lorg/jetbrains/kotlin/commonizer/tree/CirTreeTypeAlias;", "<init>", "(Ljava/util/Set;Ljava/util/Map;Ljava/util/Map;)V", "getAllClassifierIds", "()Ljava/util/Set;", "findClassifier", "id", "findTypeAliasesWithUnderlyingType", "underlyingClassifier", "kotlin-klib-commonizer"})
final class CirClassifierIndexImpl
implements CirClassifierIndex {
    @NotNull
    private final Set<CirEntityId> allClassifierIds;
    @NotNull
    private final Map<CirEntityId, CirClassifier> classifiersById;
    @NotNull
    private final Map<CirEntityId, List<CirTreeTypeAlias>> typeAliasesByUnderlyingType;

    public CirClassifierIndexImpl(@NotNull Set<CirEntityId> allClassifierIds, @NotNull Map<CirEntityId, ? extends CirClassifier> classifiersById, @NotNull Map<CirEntityId, ? extends List<CirTreeTypeAlias>> typeAliasesByUnderlyingType) {
        Intrinsics.checkNotNullParameter(allClassifierIds, (String)"allClassifierIds");
        Intrinsics.checkNotNullParameter(classifiersById, (String)"classifiersById");
        Intrinsics.checkNotNullParameter(typeAliasesByUnderlyingType, (String)"typeAliasesByUnderlyingType");
        this.allClassifierIds = allClassifierIds;
        this.classifiersById = classifiersById;
        this.typeAliasesByUnderlyingType = typeAliasesByUnderlyingType;
    }

    @Override
    @NotNull
    public Set<CirEntityId> getAllClassifierIds() {
        return this.allClassifierIds;
    }

    @Override
    @Nullable
    public CirClassifier findClassifier(@NotNull CirEntityId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.classifiersById.get(id);
    }

    @Override
    @NotNull
    public List<CirTreeTypeAlias> findTypeAliasesWithUnderlyingType(@NotNull CirEntityId underlyingClassifier) {
        Intrinsics.checkNotNullParameter((Object)underlyingClassifier, (String)"underlyingClassifier");
        List list = this.typeAliasesByUnderlyingType.get(underlyingClassifier);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

