/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.io.File;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.NativeLibraryLoader;
import org.jetbrains.kotlin.commonizer.NativeLibraryLoadingException;
import org.jetbrains.kotlin.commonizer.cli.CliLoggerAdapterKt;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/commonizer/DefaultNativeLibraryLoader;", "Lorg/jetbrains/kotlin/commonizer/NativeLibraryLoader;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "<init>", "(Lorg/jetbrains/kotlin/util/Logger;)V", "invoke", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrary;", "file", "Ljava/io/File;", "kotlin-klib-commonizer"})
public final class DefaultNativeLibraryLoader
implements NativeLibraryLoader {
    @NotNull
    private final Logger logger;

    public DefaultNativeLibraryLoader(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @Override
    @NotNull
    public NativeLibrary invoke(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            KotlinLibrary library = SingleFileResolveKt.resolveSingleFileKlib((org.jetbrains.kotlin.konan.file.File)new org.jetbrains.kotlin.konan.file.File(string), (Logger)this.logger, (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE));
            if (library.getVersions().getMetadataVersion() == null) {
                CliLoggerAdapterKt.errorAndExitJvmProcess(this.logger, "Library does not have metadata version specified in manifest: " + file);
                throw new KotlinNothingValueException();
            }
            return new NativeLibrary(library);
        }
        catch (Throwable cause) {
            throw new NativeLibraryLoadingException("Failed loading library at " + file.getPath(), cause);
        }
    }
}

