/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.NativeLibraryLoader;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrary;
import org.jetbrains.kotlin.commonizer.repository.Repository;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\t\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00030\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/commonizer/repository/FilesRepository;", "Lorg/jetbrains/kotlin/commonizer/repository/Repository;", "libraryFiles", "", "Ljava/io/File;", "libraryLoader", "Lorg/jetbrains/kotlin/commonizer/NativeLibraryLoader;", "<init>", "(Ljava/util/Set;Lorg/jetbrains/kotlin/commonizer/NativeLibraryLoader;)V", "librariesByKonanTargets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrary;", "getLibrariesByKonanTargets", "()Ljava/util/Map;", "librariesByKonanTargets$delegate", "Lkotlin/Lazy;", "getLibraries", "target", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "konanTargetOrThrow", "value", "", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nFilesRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilesRepository.kt\norg/jetbrains/kotlin/commonizer/repository/FilesRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,39:1\n1563#2:40\n1634#2,3:41\n1491#2:44\n1516#2,2:45\n1563#2:47\n1634#2,3:48\n1518#2:51\n1519#2,3:59\n1252#2,4:64\n382#3,7:52\n463#3:62\n413#3:63\n*S KotlinDebug\n*F\n+ 1 FilesRepository.kt\norg/jetbrains/kotlin/commonizer/repository/FilesRepository\n*L\n22#1:40\n22#1:41,3\n23#1:44\n23#1:45,2\n25#1:47\n25#1:48,3\n23#1:51\n23#1:59,3\n27#1:64,4\n23#1:52,7\n27#1:62\n27#1:63\n*E\n"})
public final class FilesRepository
implements Repository {
    @NotNull
    private final Set<File> libraryFiles;
    @NotNull
    private final NativeLibraryLoader libraryLoader;
    @NotNull
    private final Lazy librariesByKonanTargets$delegate;

    public FilesRepository(@NotNull Set<? extends File> libraryFiles, @NotNull NativeLibraryLoader libraryLoader) {
        Intrinsics.checkNotNullParameter(libraryFiles, (String)"libraryFiles");
        Intrinsics.checkNotNullParameter((Object)libraryLoader, (String)"libraryLoader");
        this.libraryFiles = libraryFiles;
        this.libraryLoader = libraryLoader;
        this.librariesByKonanTargets$delegate = LazyKt.lazy(() -> FilesRepository.librariesByKonanTargets_delegate$lambda$3(this));
    }

    private final Map<Set<KonanTarget>, Set<NativeLibrary>> getLibrariesByKonanTargets() {
        Lazy lazy = this.librariesByKonanTargets$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public Set<NativeLibrary> getLibraries(@NotNull CommonizerTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Set set = this.getLibrariesByKonanTargets().get(CommonizerTargetKt.getKonanTargets(target));
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final KonanTarget konanTargetOrThrow(String value) {
        KonanTarget konanTarget = (KonanTarget)KonanTarget.Companion.getPredefinedTargets().get(value);
        if (konanTarget == null) {
            throw new IllegalStateException(("Unexpected KonanTarget " + value).toString());
        }
        return konanTarget;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map librariesByKonanTargets_delegate$lambda$3(FilesRepository this$0) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map $this$groupByTo$iv$iv;
        Object object2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this$0.libraryFiles;
        NativeLibraryLoader nativeLibraryLoader = this$0.libraryLoader;
        boolean $i$f$map22 = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            File file = (File)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(nativeLibraryLoader.invoke((File)p0));
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        Iterable $i$f$map22 = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Object $i$f$mapTo22 = $this$groupByTo$iv$iv.iterator();
        while ($i$f$mapTo22.hasNext()) {
            Object object3;
            void $this$getOrPut$iv$iv$iv;
            Object element$iv$iv = $i$f$mapTo22.next();
            NativeLibrary library = (NativeLibrary)element$iv$iv;
            boolean bl = false;
            Object object4 = library.getManifestData().getCommonizerTarget();
            if (object4 == null || (object4 = CommonizerTargetKt.getKonanTargets((CommonizerTarget)object4)) == null) {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = library.getManifestData().getNativeTargets();
                boolean $i$f$map = false;
                object = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void p0;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl2 = false;
                    collection.add(this$0.konanTargetOrThrow((String)p0));
                }
                object4 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            }
            Object key$iv$iv = object4;
            Map map = destination$iv$iv2;
            Object key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $i$f$mapTo22 = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv2;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry $i$f$map = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object2 = object;
            boolean bl4 = false;
            List list = (List)entry.getValue();
            Set set = CollectionsKt.toSet((Iterable)list);
            object2.put(k, set);
        }
        return destination$iv$iv$iv;
    }
}

