/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.cir.CirClassOrTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;
import org.jetbrains.kotlin.commonizer.core.NullableSingleInvocationCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;
import org.jetbrains.kotlin.commonizer.mergedtree.PlatformIntWidth;
import org.jetbrains.kotlin.commonizer.mergedtree.PlatformWidthIndex;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH$J\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rH\u0096\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/PlatformDependentTypeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/NullableSingleInvocationCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassOrTypeAliasType;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "intPlatformId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "longPlatformId", "mixedPlatformId", "<init>", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;)V", "doCommonize", "values", "", "invoke", "inputTypeIsKnownAndMatchesPlatformBitWidth", "", "type", "target", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "Lorg/jetbrains/kotlin/commonizer/core/PlatformDependentTypeWithSingleArgumentCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/PlatformDependentTypeWithoutTypeArgumentCommonizer;", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nPlatformIntegerCommonizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformIntegerCommonizer.kt\norg/jetbrains/kotlin/commonizer/core/PlatformDependentTypeCommonizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n1755#2,3:233\n*S KotlinDebug\n*F\n+ 1 PlatformIntegerCommonizer.kt\norg/jetbrains/kotlin/commonizer/core/PlatformDependentTypeCommonizer\n*L\n57#1:233,3\n*E\n"})
abstract class PlatformDependentTypeCommonizer
implements NullableSingleInvocationCommonizer<CirClassOrTypeAliasType> {
    @NotNull
    private final CirKnownClassifiers classifiers;
    @NotNull
    private final CirEntityId intPlatformId;
    @NotNull
    private final CirEntityId longPlatformId;
    @NotNull
    private final CirEntityId mixedPlatformId;

    private PlatformDependentTypeCommonizer(CirKnownClassifiers classifiers2, CirEntityId intPlatformId, CirEntityId longPlatformId, CirEntityId mixedPlatformId) {
        this.classifiers = classifiers2;
        this.intPlatformId = intPlatformId;
        this.longPlatformId = longPlatformId;
        this.mixedPlatformId = mixedPlatformId;
    }

    @Nullable
    protected abstract CirClassOrTypeAliasType doCommonize(@NotNull List<? extends CirClassOrTypeAliasType> var1);

    @Override
    @Nullable
    public CirClassOrTypeAliasType invoke(@NotNull List<? extends CirClassOrTypeAliasType> values) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            List typesToCommonizeWithTargets = CollectionsKt.zip((Iterable)values, (Iterable)this.classifiers.getClassifierIndices().getTargets());
            Iterable $this$any$iv = typesToCommonizeWithTargets;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CommonizerTarget target;
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    CirClassOrTypeAliasType type2 = (CirClassOrTypeAliasType)pair.component1();
                    if (!(!this.inputTypeIsKnownAndMatchesPlatformBitWidth(type2, target = (CommonizerTarget)pair.component2()))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return this.doCommonize(values);
    }

    private final boolean inputTypeIsKnownAndMatchesPlatformBitWidth(CirClassOrTypeAliasType type2, CommonizerTarget target) {
        boolean bl;
        PlatformIntWidth platformIntWidth = PlatformWidthIndex.INSTANCE.platformWidthOf(target);
        switch (platformIntWidth == null ? -1 : WhenMappings.$EnumSwitchMapping$0[platformIntWidth.ordinal()]) {
            case 1: {
                if (Intrinsics.areEqual((Object)type2.getClassifierId(), (Object)this.intPlatformId) || Intrinsics.areEqual((Object)type2.getClassifierId(), (Object)this.mixedPlatformId)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (Intrinsics.areEqual((Object)type2.getClassifierId(), (Object)this.longPlatformId) || Intrinsics.areEqual((Object)type2.getClassifierId(), (Object)this.mixedPlatformId)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = Intrinsics.areEqual((Object)type2.getClassifierId(), (Object)this.mixedPlatformId);
                break;
            }
            case -1: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public /* synthetic */ PlatformDependentTypeCommonizer(CirKnownClassifiers classifiers2, CirEntityId intPlatformId, CirEntityId longPlatformId, CirEntityId mixedPlatformId, DefaultConstructorMarker $constructor_marker) {
        this(classifiers2, intPlatformId, longPlatformId, mixedPlatformId);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlatformIntWidth.values().length];
            try {
                nArray[PlatformIntWidth.INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformIntWidth.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlatformIntWidth.MIXED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

