/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.InputTargetsSelectorKt;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.commonizer.TargetDependent;
import org.jetbrains.kotlin.commonizer.TargetDependentKt;
import org.jetbrains.kotlin.commonizer.mergedtree.CirRootNode;
import org.jetbrains.kotlin.commonizer.tree.AssembelCirTreeKt;
import org.jetbrains.kotlin.commonizer.tree.CirTreeRoot;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u0003-./B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010$\u001a\u00020%J\u0012\u0010&\u001a\u00020%2\n\u0010'\u001a\u00060\u0006j\u0002`\u0007J\u0014\u0010(\u001a\u00020%2\n\u0010'\u001a\u00060\u0006j\u0002`\u0007H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00162\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0014\u0010+\u001a\u00020%2\n\u0010'\u001a\u00060\u0006j\u0002`\u0007H\u0002J\u0014\u0010,\u001a\u00020%2\n\u0010*\u001a\u00060\u0006j\u0002`\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u0018\u0012\b\u0012\u00060\u0013j\u0002`\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u0018\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0018\u001a\u001c\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u0006j\u0002`\u00070\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR+\u0010\u001e\u001a\u001c\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u00050\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001b\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerQueue;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "outputTargets", "", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "Lorg/jetbrains/kotlin/commonizer/OutputCommonizerTarget;", "deserializers", "Lorg/jetbrains/kotlin/commonizer/TargetDependent;", "Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Deserializer;", "commonizer", "Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Commonizer;", "serializer", "Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Serializer;", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Ljava/util/Set;Lorg/jetbrains/kotlin/commonizer/TargetDependent;Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Commonizer;Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Serializer;)V", "deserializedTargets", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "Lorg/jetbrains/kotlin/commonizer/InputCommonizerTarget;", "Lorg/jetbrains/kotlin/storage/NullableLazyValue;", "Lorg/jetbrains/kotlin/commonizer/tree/CirTreeRoot;", "commonizedTargets", "targetDependencies", "retainedDeserializedTargets", "getRetainedDeserializedTargets", "()Ljava/util/Set;", "retainedCommonizedTargets", "getRetainedCommonizedTargets", "retainedTargetDependencies", "", "getRetainedTargetDependencies", "()Ljava/util/Map;", "pendingOutputTargets", "getPendingOutputTargets", "invokeAll", "", "invokeTarget", "outputTarget", "enqueue", "commonize", "target", "registerTargetDependencies", "removeTargetDependencies", "Deserializer", "Commonizer", "Serializer", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nCommonizerQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonizerQueue.kt\norg/jetbrains/kotlin/commonizer/CommonizerQueue\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 TargetDependent.kt\norg/jetbrains/kotlin/commonizer/TargetDependentKt\n*L\n1#1,142:1\n412#2:143\n1246#3,4:144\n1863#3,2:148\n1863#3,2:150\n1279#3,2:154\n1293#3,4:156\n774#3:160\n865#3,2:161\n1863#3,2:163\n774#3:165\n865#3,2:166\n1863#3,2:168\n1#4:152\n100#5:153\n*S KotlinDebug\n*F\n+ 1 CommonizerQueue.kt\norg/jetbrains/kotlin/commonizer/CommonizerQueue\n*L\n55#1:143\n55#1:144,4\n139#1:148,2\n83#1:150,2\n104#1:154,2\n104#1:156,4\n128#1:160\n128#1:161,2\n129#1:163,2\n134#1:165\n134#1:166,2\n135#1:168,2\n104#1:153\n*E\n"})
public final class CommonizerQueue {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final Set<SharedCommonizerTarget> outputTargets;
    @NotNull
    private final TargetDependent<Deserializer> deserializers;
    @NotNull
    private final Commonizer commonizer;
    @NotNull
    private final Serializer serializer;
    @NotNull
    private final Map<CommonizerTarget, NullableLazyValue<CirTreeRoot>> deserializedTargets;
    @NotNull
    private final Map<SharedCommonizerTarget, NullableLazyValue<CirTreeRoot>> commonizedTargets;
    @NotNull
    private final Map<SharedCommonizerTarget, Set<CommonizerTarget>> targetDependencies;

    /*
     * WARNING - void declaration
     */
    public CommonizerQueue(@NotNull StorageManager storageManager, @NotNull Set<SharedCommonizerTarget> outputTargets, @NotNull TargetDependent<Deserializer> deserializers, @NotNull Commonizer commonizer, @NotNull Serializer serializer) {
        void destination$iv;
        void $this$mapValuesTo$iv;
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        Intrinsics.checkNotNullParameter(deserializers, (String)"deserializers");
        Intrinsics.checkNotNullParameter((Object)commonizer, (String)"commonizer");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        this.storageManager = storageManager;
        this.outputTargets = outputTargets;
        this.deserializers = deserializers;
        this.commonizer = commonizer;
        this.serializer = serializer;
        Map<CommonizerTarget, Deserializer> map = TargetDependentKt.toMap(this.deserializers);
        Map map2 = new LinkedHashMap();
        CommonizerQueue commonizerQueue = this;
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            void var14_19 = destination$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv;
            Object k = it$iv.getKey();
            void var20_24 = var14_19;
            boolean bl2 = false;
            Deserializer deserializer = (Deserializer)entry2.getValue();
            NullableLazyValue nullableLazyValue = this.storageManager.createNullableLazyValue(() -> CommonizerQueue.deserializedTargets$lambda$1$lambda$0(deserializer));
            var20_24.put(k, nullableLazyValue);
        }
        commonizerQueue.deserializedTargets = destination$iv;
        this.commonizedTargets = new LinkedHashMap();
        this.targetDependencies = new LinkedHashMap();
        Iterable $this$forEach$iv = this.outputTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SharedCommonizerTarget p0 = (SharedCommonizerTarget)element$iv;
            boolean bl = false;
            this.enqueue(p0);
        }
    }

    @NotNull
    public final Set<CommonizerTarget> getRetainedDeserializedTargets() {
        return this.deserializedTargets.keySet();
    }

    @NotNull
    public final Set<SharedCommonizerTarget> getRetainedCommonizedTargets() {
        return this.commonizedTargets.keySet();
    }

    @NotNull
    public final Map<SharedCommonizerTarget, Set<CommonizerTarget>> getRetainedTargetDependencies() {
        return MapsKt.toMap(this.targetDependencies);
    }

    @NotNull
    public final Set<CommonizerTarget> getPendingOutputTargets() {
        return this.targetDependencies.keySet();
    }

    public final void invokeAll() {
        Iterable $this$forEach$iv = this.outputTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SharedCommonizerTarget outputTarget = (SharedCommonizerTarget)element$iv;
            boolean bl = false;
            this.invokeTarget(outputTarget);
        }
        boolean bl = this.deserializedTargets.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CommonizerQueue$invokeAll$52 = false;
            String $i$a$-assert-CommonizerQueue$invokeAll$52 = "Expected 'deserializedTargets' to be empty. Found " + this.deserializedTargets.keySet();
            throw new AssertionError((Object)$i$a$-assert-CommonizerQueue$invokeAll$52);
        }
        bl = this.commonizedTargets.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CommonizerQueue$invokeAll$62 = false;
            String $i$a$-assert-CommonizerQueue$invokeAll$62 = "Expected 'commonizedTargets' to be empty. Found " + this.commonizedTargets.keySet();
            throw new AssertionError((Object)$i$a$-assert-CommonizerQueue$invokeAll$62);
        }
        bl = this.targetDependencies.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Expected 'targetDependencies' to be empty. Found " + this.targetDependencies;
            throw new AssertionError((Object)string2);
        }
    }

    public final void invokeTarget(@NotNull SharedCommonizerTarget outputTarget) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)outputTarget, (String)"outputTarget");
            NullableLazyValue<CirTreeRoot> nullableLazyValue = this.commonizedTargets.get(outputTarget);
            if (nullableLazyValue == null) break block0;
            CirTreeRoot cfr_ignored_0 = (CirTreeRoot)nullableLazyValue.invoke();
        }
    }

    private final void enqueue(SharedCommonizerTarget outputTarget) {
        this.registerTargetDependencies(outputTarget);
        this.commonizedTargets.put(outputTarget, (NullableLazyValue<CirTreeRoot>)this.storageManager.createNullableLazyValue(() -> CommonizerQueue.enqueue$lambda$6(this, outputTarget)));
    }

    /*
     * WARNING - void declaration
     */
    private final CirTreeRoot commonize(SharedCommonizerTarget target) {
        CirTreeRoot cirTreeRoot;
        CirRootNode cirRootNode;
        Set inputTargets = (Set)MapsKt.getValue(this.targetDependencies, (Object)target);
        boolean $i$f$EagerTargetDependent = false;
        Iterable $this$associateWith$iv$iv = inputTargets;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv$iv = $this$associateWith$iv$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv$iv : $this$associateWithTo$iv$iv$iv) {
            void inputTarget;
            CommonizerTarget commonizerTarget = (CommonizerTarget)element$iv$iv$iv;
            Object t = element$iv$iv$iv;
            Map map = result$iv$iv;
            boolean bl = false;
            NullableLazyValue<CirTreeRoot> nullableLazyValue = this.deserializedTargets.get(inputTarget);
            if (nullableLazyValue == null && (nullableLazyValue = this.commonizedTargets.get(inputTarget)) == null) {
                throw new IllegalStateException("Missing inputTarget " + inputTarget);
            }
            CirTreeRoot cirTreeRoot2 = (CirTreeRoot)nullableLazyValue.invoke();
            map.put(t, cirTreeRoot2);
        }
        TargetDependent<CirTreeRoot> inputDeclarations = TargetDependentKt.toTargetDependent(result$iv$iv);
        CirRootNode it = cirRootNode = this.commonizer.invoke(inputDeclarations, target);
        boolean bl = false;
        this.removeTargetDependencies(target);
        CirRootNode cirRootNode2 = cirRootNode;
        if (cirRootNode2 != null) {
            CirRootNode cirRootNode3;
            CirRootNode commonizedDeclarations = cirRootNode3 = cirRootNode2;
            boolean bl2 = false;
            this.serializer.invoke(commonizedDeclarations, target);
            cirTreeRoot = AssembelCirTreeKt.assembleCirTree(cirRootNode3);
        } else {
            cirTreeRoot = null;
        }
        return cirTreeRoot;
    }

    private final void registerTargetDependencies(SharedCommonizerTarget outputTarget) {
        this.targetDependencies.put(outputTarget, InputTargetsSelectorKt.selectInputTargets(SetsKt.plus(this.outputTargets, (Iterable)this.deserializers.getTargets()), outputTarget));
    }

    /*
     * WARNING - void declaration
     */
    private final void removeTargetDependencies(SharedCommonizerTarget target) {
        void $this$filterTo$iv$iv;
        Object p0;
        void $this$forEach$iv;
        CommonizerTarget it;
        void $this$filterTo$iv$iv2;
        if (this.targetDependencies.remove(target) == null) {
            return;
        }
        Set referencedDependencyTargets = CollectionsKt.toSet((Iterable)CollectionsKt.flatten((Iterable)this.targetDependencies.values()));
        Iterable $this$filter$iv = this.commonizedTargets.keySet();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (SharedCommonizerTarget)element$iv$iv;
            boolean bl = false;
            if (!(!referencedDependencyTargets.contains(it) && !this.getPendingOutputTargets().contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Map<SharedCommonizerTarget, NullableLazyValue<CirTreeRoot>> $i$f$filter22 = this.commonizedTargets;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (SharedCommonizerTarget)element$iv;
            boolean bl = false;
            $i$f$filter22.remove(p0);
        }
        $this$filter$iv = this.deserializedTargets.keySet();
        boolean $i$f$filter = false;
        Iterable $i$f$forEach22 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CommonizerTarget)element$iv$iv;
            boolean bl = false;
            if (!(!referencedDependencyTargets.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Map<CommonizerTarget, NullableLazyValue<CirTreeRoot>> map = this.deserializedTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (CommonizerTarget)element$iv;
            boolean bl = false;
            map.remove(p0);
        }
    }

    private static final CirTreeRoot deserializedTargets$lambda$1$lambda$0(Deserializer $deserializer) {
        return $deserializer.invoke();
    }

    private static final CirTreeRoot enqueue$lambda$6(CommonizerQueue this$0, SharedCommonizerTarget $outputTarget) {
        return this$0.commonize($outputTarget);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J#\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u00a6\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Commonizer;", "", "invoke", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirRootNode;", "inputs", "Lorg/jetbrains/kotlin/commonizer/TargetDependent;", "Lorg/jetbrains/kotlin/commonizer/tree/CirTreeRoot;", "output", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "kotlin-klib-commonizer"})
    public static interface Commonizer {
        @Nullable
        public CirRootNode invoke(@NotNull TargetDependent<CirTreeRoot> var1, @NotNull SharedCommonizerTarget var2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u000b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00a6\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Deserializer;", "", "invoke", "Lorg/jetbrains/kotlin/commonizer/tree/CirTreeRoot;", "kotlin-klib-commonizer"})
    public static interface Deserializer {
        @Nullable
        public CirTreeRoot invoke();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001d\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\bH\u00a6\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/commonizer/CommonizerQueue$Serializer;", "", "invoke", "", "declarations", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirRootNode;", "outputTarget", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "Lorg/jetbrains/kotlin/commonizer/OutputCommonizerTarget;", "kotlin-klib-commonizer"})
    public static interface Serializer {
        public void invoke(@NotNull CirRootNode var1, @NotNull SharedCommonizerTarget var2);
    }
}

