/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.stats;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.stats.StatsOutput;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/commonizer/stats/FileStatsOutput;", "Lorg/jetbrains/kotlin/commonizer/stats/StatsOutput;", "directory", "Ljava/io/File;", "baseName", "", "<init>", "(Ljava/io/File;Ljava/lang/String;)V", "writer", "Ljava/io/PrintWriter;", "width", "", "writeHeader", "", "header", "Lorg/jetbrains/kotlin/commonizer/stats/StatsOutput$StatsHeader;", "writeRow", "row", "Lorg/jetbrains/kotlin/commonizer/stats/StatsOutput$StatsRow;", "close", "kotlin-klib-commonizer"})
public final class FileStatsOutput
implements StatsOutput {
    @NotNull
    private final PrintWriter writer;
    private int width;

    public FileStatsOutput(@NotNull File directory, @NotNull String baseName) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)baseName, (String)"baseName");
        directory.mkdirs();
        File file2 = FilesKt.resolve((File)directory, (String)(baseName + "_stats.csv"));
        Charset charset = Charsets.UTF_8;
        File file3 = file2;
        int n = 8192;
        Object object = file3;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), charset);
        this.writer = new PrintWriter(object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n));
    }

    @Override
    public void writeHeader(@NotNull StatsOutput.StatsHeader header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        if (!(this.width == 0)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        List<String> headerItems = header.toList();
        if (!(!((Collection)headerItems).isEmpty())) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        this.width = headerItems.size();
        CollectionsKt.joinTo$default((Iterable)headerItems, (Appendable)this.writer, (CharSequence)"|", null, (CharSequence)"\n", (int)0, null, null, (int)116, null);
    }

    @Override
    public void writeRow(@NotNull StatsOutput.StatsRow row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (!(this.width > 0)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        List<String> rowItems = row.toList();
        if (!(rowItems.size() == this.width)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        CollectionsKt.joinTo$default((Iterable)rowItems, (Appendable)this.writer, (CharSequence)"|", null, (CharSequence)"\n", (int)0, null, null, (int)116, null);
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

