/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.mergedtree;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.containers.FactoryMap;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;
import org.jetbrains.kotlin.commonizer.mergedtree.ClassProtosToRead;
import org.jetbrains.kotlin.commonizer.utils.NamesKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J$\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000e0\u0017Rp\u0010\u0004\u001ab\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b \u0007*/\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u0007*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\b0\u000b\u00a2\u0006\u0002\b\n0\u0005\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/commonizer/mergedtree/ClassProtosToRead;", "", "<init>", "()V", "groupedByParentClassId", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/kotlin/commonizer/mergedtree/ClassProtosToRead$ClassEntry;", "Lorg/jetbrains/annotations/NotNull;", "", "Ljava/util/Map;", "addClasses", "", "classProtos", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "strings", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "forEachClassInScope", "parentClassId", "block", "Lkotlin/Function1;", "ClassEntry", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nCirProvidedClassifiersByModules.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CirProvidedClassifiersByModules.kt\norg/jetbrains/kotlin/commonizer/mergedtree/ClassProtosToRead\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,317:1\n1853#2,2:318\n1853#2,2:320\n*S KotlinDebug\n*F\n+ 1 CirProvidedClassifiersByModules.kt\norg/jetbrains/kotlin/commonizer/mergedtree/ClassProtosToRead\n*L\n157#1:318,2\n168#1:320,2\n*E\n"})
final class ClassProtosToRead {
    @NotNull
    private final Map<CirEntityId, List<ClassEntry>> groupedByParentClassId;

    public ClassProtosToRead() {
        Map map2 = FactoryMap.create(arg_0 -> ClassProtosToRead.groupedByParentClassId$lambda$0(groupedByParentClassId.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"create(...)");
        this.groupedByParentClassId = map2;
    }

    public final void addClasses(@NotNull List<ProtoBuf.Class> classProtos, @NotNull NameResolver strings2) {
        Intrinsics.checkNotNullParameter(classProtos, (String)"classProtos");
        Intrinsics.checkNotNullParameter((Object)strings2, (String)"strings");
        Iterable $this$forEach$iv = classProtos;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProtoBuf.Class classProto = (ProtoBuf.Class)element$iv;
            boolean bl = false;
            if (strings2.isLocalClassName(classProto.getFqName())) continue;
            CirEntityId classId = CirEntityId.Companion.create(strings2.getQualifiedClassName(classProto.getFqName()));
            CirEntityId cirEntityId = classId.getParentEntityId();
            if (cirEntityId == null) {
                cirEntityId = NamesKt.getNON_EXISTING_CLASSIFIER_ID();
            }
            CirEntityId parentClassId = cirEntityId;
            Object object = MapsKt.getValue(this.groupedByParentClassId, (Object)parentClassId);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            Collection collection = (Collection)object;
            collection.add(new ClassEntry(classId, classProto, strings2));
        }
    }

    public final void forEachClassInScope(@Nullable CirEntityId parentClassId, @NotNull Function1<? super ClassEntry, Unit> block) {
        block2: {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            CirEntityId cirEntityId = parentClassId;
            if (cirEntityId == null) {
                cirEntityId = NamesKt.getNON_EXISTING_CLASSIFIER_ID();
            }
            List<ClassEntry> list = this.groupedByParentClassId.get(cirEntityId);
            if (list == null) break block2;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassEntry classEntry = (ClassEntry)element$iv;
                boolean bl = false;
                block.invoke((Object)classEntry);
            }
        }
    }

    private static final List groupedByParentClassId$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/commonizer/mergedtree/ClassProtosToRead$ClassEntry;", "", "classId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "strings", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "<init>", "(Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;)V", "getClassId", "()Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "getProto", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "getStrings", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-klib-commonizer"})
    public static final class ClassEntry {
        @NotNull
        private final CirEntityId classId;
        @NotNull
        private final ProtoBuf.Class proto;
        @NotNull
        private final NameResolver strings;

        public ClassEntry(@NotNull CirEntityId classId, @NotNull ProtoBuf.Class proto, @NotNull NameResolver strings2) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
            Intrinsics.checkNotNullParameter((Object)strings2, (String)"strings");
            this.classId = classId;
            this.proto = proto;
            this.strings = strings2;
        }

        @NotNull
        public final CirEntityId getClassId() {
            return this.classId;
        }

        @NotNull
        public final ProtoBuf.Class getProto() {
            return this.proto;
        }

        @NotNull
        public final NameResolver getStrings() {
            return this.strings;
        }

        @NotNull
        public final CirEntityId component1() {
            return this.classId;
        }

        @NotNull
        public final ProtoBuf.Class component2() {
            return this.proto;
        }

        @NotNull
        public final NameResolver component3() {
            return this.strings;
        }

        @NotNull
        public final ClassEntry copy(@NotNull CirEntityId classId, @NotNull ProtoBuf.Class proto, @NotNull NameResolver strings2) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
            Intrinsics.checkNotNullParameter((Object)strings2, (String)"strings");
            return new ClassEntry(classId, proto, strings2);
        }

        public static /* synthetic */ ClassEntry copy$default(ClassEntry classEntry, CirEntityId cirEntityId, ProtoBuf.Class clazz2, NameResolver nameResolver2, int n, Object object) {
            if ((n & 1) != 0) {
                cirEntityId = classEntry.classId;
            }
            if ((n & 2) != 0) {
                clazz2 = classEntry.proto;
            }
            if ((n & 4) != 0) {
                nameResolver2 = classEntry.strings;
            }
            return classEntry.copy(cirEntityId, clazz2, nameResolver2);
        }

        @NotNull
        public String toString() {
            return "ClassEntry(classId=" + this.classId + ", proto=" + this.proto + ", strings=" + this.strings + ')';
        }

        public int hashCode() {
            int result = this.classId.hashCode();
            result = result * 31 + this.proto.hashCode();
            result = result * 31 + this.strings.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassEntry)) {
                return false;
            }
            ClassEntry classEntry = (ClassEntry)other;
            if (!Intrinsics.areEqual((Object)this.classId, (Object)classEntry.classId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.proto, (Object)classEntry.proto)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.strings, (Object)classEntry.strings);
        }
    }
}

