/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;
import org.jetbrains.kotlin.commonizer.cir.CirTypeAttachment;
import org.jetbrains.kotlin.commonizer.core.AssociativeCommonizer;
import org.jetbrains.kotlin.commonizer.core.OptimisticNumbersTypeCommonizerKt;
import org.jetbrains.kotlin.commonizer.core.SubstitutableNumbers;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\f\u0010\u0011\u001a\u00020\u0002*\u00020\u0002H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/OptimisticNumbersTypeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassType;", "<init>", "()V", "commonizableNumberTypes", "", "Lorg/jetbrains/kotlin/commonizer/core/SubstitutableNumbers;", "commonizableNumberIdentifiers", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "isOptimisticallyCommonizableNumber", "", "identifier", "commonize", "first", "second", "withMarker", "OptimisticCommonizationMarker", "kotlin-klib-commonizer"})
@SourceDebugExtension(value={"SMAP\nOptimisticNumbersTypeCommonizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptimisticNumbersTypeCommonizer.kt\norg/jetbrains/kotlin/commonizer/core/OptimisticNumbersTypeCommonizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1#2:98\n1358#3:99\n1444#3,5:100\n*S KotlinDebug\n*F\n+ 1 OptimisticNumbersTypeCommonizer.kt\norg/jetbrains/kotlin/commonizer/core/OptimisticNumbersTypeCommonizer\n*L\n83#1:99\n83#1:100,5\n*E\n"})
public final class OptimisticNumbersTypeCommonizer
implements AssociativeCommonizer<CirClassType> {
    @NotNull
    public static final OptimisticNumbersTypeCommonizer INSTANCE;
    @NotNull
    private static final List<SubstitutableNumbers> commonizableNumberTypes;
    @NotNull
    private static final Set<CirEntityId> commonizableNumberIdentifiers;

    private OptimisticNumbersTypeCommonizer() {
    }

    public final boolean isOptimisticallyCommonizableNumber(@NotNull CirEntityId identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return commonizableNumberIdentifiers.contains(identifier);
    }

    @Override
    @Nullable
    public CirClassType commonize(@NotNull CirClassType first, @NotNull CirClassType second) {
        CirClassType result;
        CirClassType cirClassType;
        block1: {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            for (SubstitutableNumbers it : (Iterable)commonizableNumberTypes) {
                boolean bl = false;
                CirClassType cirClassType2 = it.choose(first, second);
                if (cirClassType2 == null) continue;
                cirClassType = cirClassType2;
                break block1;
            }
            cirClassType = null;
        }
        CirClassType cirClassType3 = result = cirClassType;
        return cirClassType3 != null ? this.withMarker(cirClassType3) : null;
    }

    private final CirClassType withMarker(CirClassType $this$withMarker) {
        return CirClassType.Companion.copyInterned$default(CirClassType.Companion, $this$withMarker, null, null, null, false, CollectionsKt.plus((Collection)$this$withMarker.getAttachments(), (Object)OptimisticCommonizationMarker.INSTANCE), 15, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$flatMapTo$iv$iv;
        INSTANCE = new OptimisticNumbersTypeCommonizer();
        Object[] objectArray = new SubstitutableNumbers[]{OptimisticNumbersTypeCommonizerKt.access$getSignedIntegers$p(), OptimisticNumbersTypeCommonizerKt.access$getUnsignedIntegers$p(), OptimisticNumbersTypeCommonizerKt.access$getFloatingPoints$p(), OptimisticNumbersTypeCommonizerKt.access$getSignedVarIntegers$p(), OptimisticNumbersTypeCommonizerKt.access$getUnsignedVarIntegers$p(), OptimisticNumbersTypeCommonizerKt.access$getFloatingPointVars$p()};
        commonizableNumberTypes = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$flatMap$iv = commonizableNumberTypes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SubstitutableNumbers it = (SubstitutableNumbers)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getNumbers().keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        commonizableNumberIdentifiers = CollectionsKt.toSet((Iterable)((List)var3_3));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/OptimisticNumbersTypeCommonizer$OptimisticCommonizationMarker;", "Lorg/jetbrains/kotlin/commonizer/cir/CirTypeAttachment;", "<init>", "()V", "kotlin-klib-commonizer"})
    public static final class OptimisticCommonizationMarker
    implements CirTypeAttachment {
        @NotNull
        public static final OptimisticCommonizationMarker INSTANCE = new OptimisticCommonizationMarker();

        private OptimisticCommonizationMarker() {
        }
    }
}

