/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.internal.descriptors.ClassifierDescriptor;
import kotlinx.metadata.internal.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlinx.metadata.internal.descriptors.DeclarationDescriptor;
import kotlinx.metadata.internal.metadata.serialization.StringTable;
import kotlinx.metadata.internal.name.ClassId;
import kotlinx.metadata.internal.renderer.DescriptorRenderer;
import kotlinx.metadata.internal.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlinx.metadata.internal.types.error.ErrorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lkotlinx/metadata/internal/serialization/DescriptorAwareStringTable;", "Lkotlinx/metadata/internal/metadata/serialization/StringTable;", "isLocalClassIdReplacementKeptGeneric", "", "()Z", "getFqNameIndex", "", "descriptor", "Lkotlinx/metadata/internal/descriptors/ClassifierDescriptorWithTypeParameters;", "getLocalClassIdReplacement", "Lkotlinx/metadata/internal/name/ClassId;", "getQualifiedClassNameIndex", "classId", "renderDescriptor", "", "serialization"})
public interface DescriptorAwareStringTable
extends StringTable {
    default public int getQualifiedClassNameIndex(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        String string2 = classId.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.asString()");
        return this.getQualifiedClassNameIndex(string2, classId.isLocal());
    }

    default public int getFqNameIndex(@NotNull ClassifierDescriptorWithTypeParameters descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (ErrorUtils.isError((DeclarationDescriptor)((DeclarationDescriptor)descriptor))) {
            throw new IllegalStateException("Cannot get FQ name of error class: " + this.renderDescriptor(descriptor));
        }
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassifierDescriptor)descriptor));
        if (classId == null && (classId = this.getLocalClassIdReplacement(descriptor)) == null) {
            throw new IllegalStateException("Cannot get FQ name of local class: " + this.renderDescriptor(descriptor));
        }
        ClassId classId2 = classId;
        return this.getQualifiedClassNameIndex(classId2);
    }

    @Nullable
    default public ClassId getLocalClassIdReplacement(@NotNull ClassifierDescriptorWithTypeParameters descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return null;
    }

    default public boolean isLocalClassIdReplacementKeptGeneric() {
        return false;
    }

    private String renderDescriptor(ClassifierDescriptorWithTypeParameters descriptor) {
        StringBuilder stringBuilder = new StringBuilder().append(DescriptorRenderer.COMPACT.render((DeclarationDescriptor)descriptor)).append(" defined in ");
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
        return stringBuilder.append(DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor)).toString();
    }
}

