/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.konan;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.CommonizerOutputFileLayout;
import org.jetbrains.kotlin.commonizer.CommonizerParameters;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.ResultsConsumer;
import org.jetbrains.kotlin.commonizer.konan.ModuleSerializerKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/commonizer/konan/ModuleSerializer;", "Lorg/jetbrains/kotlin/commonizer/ResultsConsumer;", "destination", "Ljava/io/File;", "(Ljava/io/File;)V", "consume", "", "parameters", "Lorg/jetbrains/kotlin/commonizer/CommonizerParameters;", "target", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "moduleResult", "Lorg/jetbrains/kotlin/commonizer/ResultsConsumer$ModuleResult;", "kotlin-klib-commonizer"})
public final class ModuleSerializer
implements ResultsConsumer {
    @NotNull
    private final File destination;

    public ModuleSerializer(@NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this.destination = destination;
    }

    @Override
    public void consume(@NotNull CommonizerParameters parameters2, @NotNull CommonizerTarget target, @NotNull ResultsConsumer.ModuleResult moduleResult) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)moduleResult, (String)"moduleResult");
        File librariesDestination = CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(this.destination, target);
        ResultsConsumer.ModuleResult moduleResult2 = moduleResult;
        if (moduleResult2 instanceof ResultsConsumer.ModuleResult.Commonized) {
            File libraryDestination = FilesKt.resolve((File)librariesDestination, (String)ModuleSerializerKt.getFileSystemCompatibleLibraryName(moduleResult));
            ModuleSerializerKt.access$writeLibrary(((ResultsConsumer.ModuleResult.Commonized)moduleResult).getMetadata(), ((ResultsConsumer.ModuleResult.Commonized)moduleResult).getManifest(), libraryDestination);
        } else if (moduleResult2 instanceof ResultsConsumer.ModuleResult.Missing) {
            File missingModuleSourceLocation = ((ResultsConsumer.ModuleResult.Missing)moduleResult).getOriginalLocation();
            File missingModuleDestinationLocation = FilesKt.resolve((File)librariesDestination, (String)ModuleSerializerKt.getFileSystemCompatibleLibraryName(moduleResult));
            if (!missingModuleDestinationLocation.exists()) {
                FilesKt.copyRecursively$default((File)missingModuleSourceLocation, (File)FilesKt.resolve((File)librariesDestination, (String)ModuleSerializerKt.getFileSystemCompatibleLibraryName(moduleResult)), (boolean)false, null, (int)6, null);
            }
        }
    }
}

