/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.cli.CommonizerCLI;
import org.jetbrains.kotlin.commonizer.cli.Option;
import org.jetbrains.kotlin.commonizer.cli.OptionType;
import org.jetbrains.kotlin.commonizer.cli.Task;
import org.jetbrains.kotlin.commonizer.cli.TaskType;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\u001a\u0019\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005\u001a.\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u0010"}, d2={"main", "", "args", "", "", "([Ljava/lang/String;)V", "parseTask", "taskAlias", "tokens", "", "tasks", "", "Lorg/jetbrains/kotlin/commonizer/cli/Task;", "printUsageAndExit", "", "errorMessage", "kotlin-klib-commonizer"})
@JvmName(name="CommonizerCLI")
public final class CommonizerCLI {
    /*
     * WARNING - void declaration
     */
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length == 0) {
            CommonizerCLI.printUsageAndExit$default(null, 1, null);
            throw null;
        }
        Iterator tokens = ArrayIteratorKt.iterator((Object[])args);
        List tasks = new ArrayList();
        String taskAlias = (String)tokens.next();
        while (taskAlias != null) {
            taskAlias = CommonizerCLI.parseTask(taskAlias, tokens, tasks);
        }
        Task.Category[] $this$forEach$iv = Task.Category.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String p0;
            void $this$filterTo$iv$iv;
            Task.Category element$iv;
            Task.Category category = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Iterable $this$filter$iv = tasks;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Task it = (Task)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getCategory() == category)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sortedTasks = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
            if (!(!((Collection)sortedTasks).isEmpty())) continue;
            if (category.getPrologue() != null) {
                String p02;
                boolean bl3 = false;
                System.out.println((Object)p02);
            }
            Iterable $this$forEachIndexed$iv = sortedTasks;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void task;
                int n2;
                Object element$iv$iv;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                element$iv$iv = (Task)item$iv;
                int index = n2;
                boolean bl4 = false;
                String logPrefix = category.getLogEachStep() && sortedTasks.size() > 1 ? "[Step " + (index + 1) + " of " + sortedTasks.size() + "] " : "";
                task.execute(logPrefix);
            }
            if (category.getEpilogue() == null) continue;
            boolean bl5 = false;
            System.out.println((Object)p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final String parseTask(String taskAlias, Iterator<String> tokens, List<Task> tasks) {
        void $this$associateByTo$iv$iv;
        TaskType taskType = TaskType.Companion.getByAlias(taskAlias);
        if (taskType == null) {
            CommonizerCLI.printUsageAndExit("Unknown task " + taskAlias);
            throw null;
        }
        TaskType taskType2 = taskType;
        Iterable $this$associateBy$iv = taskType2.getOptionTypes();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            OptionType optionType = (OptionType)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getAlias(), element$iv$iv);
        }
        Map optionTypes = destination$iv$iv;
        Map options = new LinkedHashMap();
        while (tokens.hasNext()) {
            OptionType optionType;
            String token = tokens.next();
            boolean bl = false;
            if (!StringsKt.startsWith$default((CharSequence)token, (char)'-', (boolean)false, (int)2, null)) {
                CommonizerCLI.parseTask$buildOngoingTask(optionTypes, taskAlias, options, tasks, taskType2);
                return token;
            }
            char[] cArray = new char[]{'-'};
            String optionAlias = StringsKt.trimStart((String)token, (char[])cArray);
            if (options.containsKey(optionAlias)) {
                CommonizerCLI.printUsageAndExit("Duplicated value for option -" + optionAlias + " in task " + taskAlias);
                throw null;
            }
            if ((OptionType)optionTypes.get(optionAlias) == null) {
                CommonizerCLI.printUsageAndExit("Unknown option -" + optionAlias + " in task " + taskAlias);
                throw null;
            }
            if (!tokens.hasNext()) {
                CommonizerCLI.printUsageAndExit("No value for option -" + optionAlias + " in task " + taskAlias);
                throw null;
            }
            String rawValue = tokens.next();
            Option option2 = optionType.parse(rawValue, new Function1(optionAlias, taskAlias){
                final /* synthetic */ String $optionAlias;
                final /* synthetic */ String $taskAlias;
                {
                    this.$optionAlias = $optionAlias;
                    this.$taskAlias = $taskAlias;
                    super(1);
                }

                @NotNull
                public final Void invoke(@NotNull String reason) {
                    Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                    CommonizerCLI.access$printUsageAndExit("Failed to parse option -" + this.$optionAlias + " in task " + this.$taskAlias + ": " + reason);
                    throw null;
                }
            });
            options.put(optionAlias, option2);
        }
        CommonizerCLI.parseTask$buildOngoingTask(optionTypes, taskAlias, options, tasks, taskType2);
        return null;
    }

    private static final Void printUsageAndExit(String errorMessage) {
        if (errorMessage != null) {
            System.out.println((Object)("Error: " + errorMessage));
            System.out.println();
        }
        System.out.println((Object)("Usage: " + ((Object)((Object)printUsageAndExit.1.INSTANCE)).getClass().getPackage().getName() + ".CommonizerCLI <task> <options> [<task> <options>...]"));
        System.out.println();
        System.out.println((Object)"Tasks:");
        for (TaskType taskType : TaskType.values()) {
            System.out.println((Object)CommonizerCLI.printUsageAndExit$formatBoth(1, taskType.getAlias(), taskType.getDescription()));
            System.out.println(CommonizerCLI.printUsageAndExit$formatLeft(1, !((Collection)taskType.getOptionTypes()).isEmpty() ? "Options:" : "No options."));
            for (OptionType<?> optionType : taskType.getOptionTypes()) {
                char[] cArray = new char[]{'\n'};
                List lines = StringsKt.split$default((CharSequence)optionType.getDescription(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
                System.out.println((Object)CommonizerCLI.printUsageAndExit$formatBoth(2, '-' + optionType.getAlias(), (String)CollectionsKt.first((List)lines)));
                Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)lines, (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    System.out.println((Object)CommonizerCLI.printUsageAndExit$formatRight(new StringBuilder(), it));
                }
            }
            System.out.println();
        }
        System.exit(errorMessage != null ? 1 : 0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    static /* synthetic */ Void printUsageAndExit$default(String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return CommonizerCLI.printUsageAndExit(string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void parseTask$buildOngoingTask(Map<String, ? extends OptionType<?>> optionTypes, String $taskAlias, Map<String, Option<?>> options, List<Task> $tasks, TaskType taskType) {
        void $this$filterValues$iv;
        boolean bl;
        Object it;
        Map $this$filterKeys$iv = optionTypes;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterKeys$iv.entrySet()) {
            it = (String)entry.getKey();
            bl = false;
            boolean bl2 = !options.containsKey(it);
            if (!bl2) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            it = (OptionType)entry.getValue();
            bl = false;
            if (!((OptionType)it).getMandatory()) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Set missingMandatoryOptions = ((Map)result$iv).keySet();
        if (!((Collection)missingMandatoryOptions).isEmpty()) {
            CommonizerCLI.printUsageAndExit("Mandatory options not specified in task " + $taskAlias + ": " + CollectionsKt.joinToString$default((Iterable)missingMandatoryOptions, null, null, null, (int)0, null, (Function1)parseTask.buildOngoingTask.1.INSTANCE, (int)31, null) + "\nSpecified options: " + CollectionsKt.joinToString$default((Iterable)options.keySet(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            throw null;
        }
        ((Collection)$tasks).add(taskType.getTaskConstructor().invoke(options.values()));
    }

    private static final StringBuilder printUsageAndExit$formatLeft(int indent, String left) {
        StringBuilder stringBuilder;
        StringBuilder $this$printUsageAndExit_u24formatLeft_u24lambda_u249 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        while (n < indent) {
            int it = n++;
            boolean bl2 = false;
            $this$printUsageAndExit_u24formatLeft_u24lambda_u249.append("    ");
        }
        $this$printUsageAndExit_u24formatLeft_u24lambda_u249.append(left);
        return stringBuilder;
    }

    private static final String printUsageAndExit$formatRight(StringBuilder $this$printUsageAndExit_u24formatRight, String right) {
        int middleSpace = Math.max(38 - $this$printUsageAndExit_u24formatRight.length(), 1);
        int n = 0;
        while (n < middleSpace) {
            int it = n++;
            boolean bl = false;
            $this$printUsageAndExit_u24formatRight.append(" ");
        }
        $this$printUsageAndExit_u24formatRight.append(right);
        String string2 = $this$printUsageAndExit_u24formatRight.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.toString()");
        return string2;
    }

    private static final String printUsageAndExit$formatBoth(int indent, String left, String right) {
        return CommonizerCLI.printUsageAndExit$formatRight(CommonizerCLI.printUsageAndExit$formatLeft(indent, left), right);
    }

    public static final /* synthetic */ Void access$printUsageAndExit(String errorMessage) {
        return CommonizerCLI.printUsageAndExit(errorMessage);
    }
}

