/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.cir.CirClassOrTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirFlexibleType;
import org.jetbrains.kotlin.commonizer.cir.CirRegularTypeProjection;
import org.jetbrains.kotlin.commonizer.cir.CirSimpleType;
import org.jetbrains.kotlin.commonizer.cir.CirStarTypeProjection;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeAliasType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeParameterType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeProjection;
import org.jetbrains.kotlin.commonizer.cir.UtilsKt;
import org.jetbrains.kotlin.commonizer.core.CirTypeRendererForUnsafeNumberAnnotationKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\u000f\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0010\u001a\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0001*\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"NULLABLE", "", "STAR_PROJECTION", "TYPE_PARAMETER_TYPE_PREFIX", "renderArguments", "arguments", "", "Lorg/jetbrains/kotlin/commonizer/cir/CirTypeProjection;", "renderFlexibleType", "type", "Lorg/jetbrains/kotlin/commonizer/cir/CirFlexibleType;", "renderSimpleType", "Lorg/jetbrains/kotlin/commonizer/cir/CirSimpleType;", "renderTypeArgument", "typeArgument", "renderTypeForUnsafeNumberAnnotation", "Lorg/jetbrains/kotlin/commonizer/cir/CirType;", "renderVariance", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "renderNullable", "kotlin-klib-commonizer"})
public final class CirTypeRendererForUnsafeNumberAnnotationKt {
    @NotNull
    private static final String NULLABLE = "?";
    @NotNull
    private static final String STAR_PROJECTION = "*";
    @NotNull
    private static final String TYPE_PARAMETER_TYPE_PREFIX = "#";

    @NotNull
    public static final String renderTypeForUnsafeNumberAnnotation(@NotNull CirType type2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        CirType cirType = type2;
        if (cirType instanceof CirSimpleType) {
            string2 = CirTypeRendererForUnsafeNumberAnnotationKt.renderSimpleType((CirSimpleType)type2);
        } else if (cirType instanceof CirFlexibleType) {
            string2 = CirTypeRendererForUnsafeNumberAnnotationKt.renderFlexibleType((CirFlexibleType)type2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final String renderFlexibleType(CirFlexibleType type2) {
        return CirTypeRendererForUnsafeNumberAnnotationKt.renderTypeForUnsafeNumberAnnotation(type2.getLowerBound()) + ".." + CirTypeRendererForUnsafeNumberAnnotationKt.renderTypeForUnsafeNumberAnnotation(type2.getUpperBound());
    }

    private static final String renderSimpleType(CirSimpleType type2) {
        String string2;
        CirSimpleType cirSimpleType = type2;
        if (cirSimpleType instanceof CirTypeAliasType) {
            string2 = CirTypeRendererForUnsafeNumberAnnotationKt.renderSimpleType(UtilsKt.expandedType((CirClassOrTypeAliasType)type2));
        } else if (cirSimpleType instanceof CirClassType) {
            string2 = ((CirClassType)type2).getClassifierId().toQualifiedNameString() + CirTypeRendererForUnsafeNumberAnnotationKt.renderArguments(((CirClassType)type2).getArguments()) + CirTypeRendererForUnsafeNumberAnnotationKt.renderNullable(type2);
        } else if (cirSimpleType instanceof CirTypeParameterType) {
            string2 = "" + '#' + ((CirTypeParameterType)type2).getIndex() + CirTypeRendererForUnsafeNumberAnnotationKt.renderNullable(type2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final String renderArguments(List<? extends CirTypeProjection> arguments2) {
        String string2;
        String string3;
        Collection $this$ifNotEmpty$iv = arguments2;
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$renderArguments_u24lambda_u240 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            string3 = CollectionsKt.joinToString$default((Iterable)$this$renderArguments_u24lambda_u240, null, (CharSequence)"<", (CharSequence)">", (int)0, null, (Function1)renderArguments.1.1.INSTANCE, (int)25, null);
        } else {
            string3 = string2 = null;
        }
        if (string3 == null) {
            string2 = "";
        }
        return string2;
    }

    private static final String renderTypeArgument(CirTypeProjection typeArgument) {
        String string2;
        CirTypeProjection cirTypeProjection = typeArgument;
        if (cirTypeProjection instanceof CirRegularTypeProjection) {
            string2 = CirTypeRendererForUnsafeNumberAnnotationKt.renderVariance(((CirRegularTypeProjection)typeArgument).getProjectionKind()) + CirTypeRendererForUnsafeNumberAnnotationKt.renderTypeForUnsafeNumberAnnotation(((CirRegularTypeProjection)typeArgument).getType());
        } else if (Intrinsics.areEqual((Object)cirTypeProjection, (Object)CirStarTypeProjection.INSTANCE)) {
            string2 = STAR_PROJECTION;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private static final String renderVariance(Variance variance) {
        String string2;
        String it = string2 = "" + variance + ' ';
        boolean bl = false;
        String string3 = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    private static final String renderNullable(CirSimpleType $this$renderNullable) {
        String string2;
        String string3;
        boolean $this$ifTrue$iv = $this$renderNullable.isMarkedNullable();
        boolean $i$f$ifTrue = false;
        if ($this$ifTrue$iv) {
            boolean bl = false;
            string3 = NULLABLE;
        } else {
            string3 = string2 = null;
        }
        if (string3 == null) {
            string2 = "";
        }
        return string2;
    }

    public static final /* synthetic */ String access$renderTypeArgument(CirTypeProjection typeArgument) {
        return CirTypeRendererForUnsafeNumberAnnotationKt.renderTypeArgument(typeArgument);
    }
}

