/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirName;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeParameter;
import org.jetbrains.kotlin.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeParameterUpperBoundsCommonizer;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\n\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/TypeParameterCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirTypeParameter;", "typeCommonizer", "Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer;", "(Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer;)V", "isReified", "", "name", "Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "upperBounds", "Lorg/jetbrains/kotlin/commonizer/core/TypeParameterUpperBoundsCommonizer;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "commonizationResult", "doCommonizeWith", "next", "initialize", "", "first", "kotlin-klib-commonizer"})
public final class TypeParameterCommonizer
extends AbstractStandardCommonizer<CirTypeParameter, CirTypeParameter> {
    private CirName name;
    private boolean isReified;
    private Variance variance;
    @NotNull
    private final TypeParameterUpperBoundsCommonizer upperBounds;

    public TypeParameterCommonizer(@NotNull TypeCommonizer typeCommonizer) {
        Intrinsics.checkNotNullParameter((Object)typeCommonizer, (String)"typeCommonizer");
        this.upperBounds = new TypeParameterUpperBoundsCommonizer(typeCommonizer);
    }

    @Override
    @Nullable
    protected CirTypeParameter commonizationResult() {
        Variance variance;
        List list = CollectionsKt.emptyList();
        CirName cirName = this.name;
        if (cirName == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
            cirName = null;
        }
        if ((variance = this.variance) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variance");
            variance = null;
        }
        Object object = this.upperBounds.getResult();
        if (object == null) {
            return null;
        }
        return new CirTypeParameter(list, cirName, this.isReified, variance, (List<? extends CirType>)object);
    }

    @Override
    protected void initialize(@NotNull CirTypeParameter first) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        this.name = first.getName();
        this.isReified = first.isReified();
        this.variance = first.getVariance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doCommonizeWith(@NotNull CirTypeParameter next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        CirName cirName = this.name;
        if (cirName == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
            cirName = null;
        }
        if (!Intrinsics.areEqual((Object)cirName, (Object)next.getName())) return false;
        if (this.isReified != next.isReified()) return false;
        Variance variance = this.variance;
        if (variance == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variance");
            variance = null;
        }
        if (variance != next.getVariance()) return false;
        if (!this.upperBounds.commonizeWith(next.getUpperBounds())) return false;
        return true;
    }
}

