/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.internal.descriptors.ClassifierDescriptor;
import kotlinx.metadata.internal.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlinx.metadata.internal.descriptors.DeclarationDescriptor;
import kotlinx.metadata.internal.metadata.serialization.StringTable;
import kotlinx.metadata.internal.name.ClassId;
import kotlinx.metadata.internal.renderer.DescriptorRenderer;
import kotlinx.metadata.internal.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlinx.metadata.internal.types.ErrorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u000f"}, d2={"Lkotlinx/metadata/internal/serialization/DescriptorAwareStringTable;", "Lkotlinx/metadata/internal/metadata/serialization/StringTable;", "isLocalClassIdReplacementKeptGeneric", "", "()Z", "getFqNameIndex", "", "descriptor", "Lkotlinx/metadata/internal/descriptors/ClassifierDescriptorWithTypeParameters;", "getLocalClassIdReplacement", "Lkotlinx/metadata/internal/name/ClassId;", "getQualifiedClassNameIndex", "classId", "renderDescriptor", "", "serialization"})
public interface DescriptorAwareStringTable
extends StringTable {
    public int getQualifiedClassNameIndex(@NotNull ClassId var1);

    public int getFqNameIndex(@NotNull ClassifierDescriptorWithTypeParameters var1);

    @Nullable
    public ClassId getLocalClassIdReplacement(@NotNull ClassifierDescriptorWithTypeParameters var1);

    public boolean isLocalClassIdReplacementKeptGeneric();

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static int getQualifiedClassNameIndex(@NotNull DescriptorAwareStringTable this_, @NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            String string2 = classId.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classId.asString()");
            return this_.getQualifiedClassNameIndex(string2, classId.isLocal());
        }

        public static int getFqNameIndex(@NotNull DescriptorAwareStringTable this_, @NotNull ClassifierDescriptorWithTypeParameters descriptor) {
            ClassId classId;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (ErrorUtils.isError((DeclarationDescriptor)((DeclarationDescriptor)descriptor))) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot get FQ name of error class: ", (Object)DefaultImpls.renderDescriptor(this_, descriptor)));
            }
            ClassId classId2 = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassifierDescriptor)descriptor));
            if (classId2 == null) {
                ClassId classId3 = this_.getLocalClassIdReplacement(descriptor);
                if (classId3 == null) {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot get FQ name of local class: ", (Object)DefaultImpls.renderDescriptor(this_, descriptor)));
                }
                classId = classId3;
            } else {
                classId = classId2;
            }
            ClassId classId4 = classId;
            return this_.getQualifiedClassNameIndex(classId4);
        }

        @Nullable
        public static ClassId getLocalClassIdReplacement(@NotNull DescriptorAwareStringTable this_, @NotNull ClassifierDescriptorWithTypeParameters descriptor) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            return null;
        }

        public static boolean isLocalClassIdReplacementKeptGeneric(@NotNull DescriptorAwareStringTable this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return false;
        }

        private static String renderDescriptor(DescriptorAwareStringTable this_, ClassifierDescriptorWithTypeParameters descriptor) {
            StringBuilder stringBuilder = new StringBuilder().append(DescriptorRenderer.COMPACT.render((DeclarationDescriptor)descriptor)).append(" defined in ");
            DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"descriptor.containingDeclaration");
            return stringBuilder.append(DescriptorRenderer.FQ_NAMES_IN_TYPES.render(declarationDescriptor)).toString();
        }
    }
}

