/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.serialization;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.internal.builtins.KotlinBuiltIns;
import kotlinx.metadata.internal.descriptors.ClassDescriptor;
import kotlinx.metadata.internal.descriptors.ClassifierDescriptor;
import kotlinx.metadata.internal.descriptors.ClassifierDescriptorWithTypeParameters;
import kotlinx.metadata.internal.descriptors.DeclarationDescriptor;
import kotlinx.metadata.internal.descriptors.annotations.AnnotationArgumentVisitor;
import kotlinx.metadata.internal.descriptors.annotations.AnnotationDescriptor;
import kotlinx.metadata.internal.metadata.ProtoBuf;
import kotlinx.metadata.internal.metadata.deserialization.Flags;
import kotlinx.metadata.internal.name.Name;
import kotlinx.metadata.internal.resolve.constants.AnnotationValue;
import kotlinx.metadata.internal.resolve.constants.ArrayValue;
import kotlinx.metadata.internal.resolve.constants.BooleanValue;
import kotlinx.metadata.internal.resolve.constants.ByteValue;
import kotlinx.metadata.internal.resolve.constants.CharValue;
import kotlinx.metadata.internal.resolve.constants.ConstantValue;
import kotlinx.metadata.internal.resolve.constants.DoubleValue;
import kotlinx.metadata.internal.resolve.constants.EnumValue;
import kotlinx.metadata.internal.resolve.constants.ErrorValue;
import kotlinx.metadata.internal.resolve.constants.FloatValue;
import kotlinx.metadata.internal.resolve.constants.IntValue;
import kotlinx.metadata.internal.resolve.constants.KClassValue;
import kotlinx.metadata.internal.resolve.constants.LongValue;
import kotlinx.metadata.internal.resolve.constants.NullValue;
import kotlinx.metadata.internal.resolve.constants.ShortValue;
import kotlinx.metadata.internal.resolve.constants.StringValue;
import kotlinx.metadata.internal.resolve.constants.UByteValue;
import kotlinx.metadata.internal.resolve.constants.UIntValue;
import kotlinx.metadata.internal.resolve.constants.ULongValue;
import kotlinx.metadata.internal.resolve.constants.UShortValue;
import kotlinx.metadata.internal.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlinx.metadata.internal.serialization.DescriptorAwareStringTable;
import kotlinx.metadata.internal.types.ErrorUtils;
import kotlinx.metadata.internal.types.KotlinType;
import kotlinx.metadata.internal.types.TypeProjection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lkotlinx/metadata/internal/serialization/AnnotationSerializer;", "", "stringTable", "Lkotlinx/metadata/internal/serialization/DescriptorAwareStringTable;", "(Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;)V", "ignoreAnnotation", "", "type", "Lkotlinx/metadata/internal/types/KotlinType;", "serializeAnnotation", "Lkotlinx/metadata/internal/metadata/ProtoBuf$Annotation;", "annotation", "Lkotlinx/metadata/internal/descriptors/annotations/AnnotationDescriptor;", "valueProto", "Lkotlinx/metadata/internal/metadata/ProtoBuf$Annotation$Argument$Value$Builder;", "constant", "Lkotlinx/metadata/internal/resolve/constants/ConstantValue;", "serialization"})
public class AnnotationSerializer {
    @NotNull
    private final DescriptorAwareStringTable stringTable;

    public AnnotationSerializer(@NotNull DescriptorAwareStringTable stringTable) {
        Intrinsics.checkNotNullParameter((Object)stringTable, (String)"stringTable");
        this.stringTable = stringTable;
    }

    @Nullable
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull AnnotationDescriptor annotation) {
        ProtoBuf.Annotation.Builder builder;
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        ProtoBuf.Annotation.Builder $this$serializeAnnotation_u24lambda_u2d0 = builder = ProtoBuf.Annotation.newBuilder();
        boolean bl = false;
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getAnnotationClass((AnnotationDescriptor)annotation);
        if (classDescriptor == null) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Annotation type is not a class: ", (Object)annotation.getType()).toString());
        }
        Object annotationClass = classDescriptor;
        if (ErrorUtils.isError((DeclarationDescriptor)((DeclarationDescriptor)annotationClass))) {
            if (this.ignoreAnnotation(annotation.getType())) {
                return null;
            }
            throw new IllegalStateException(("Unresolved annotation type: " + annotation.getType() + " at " + annotation.getSource().getContainingFile()).toString());
        }
        $this$serializeAnnotation_u24lambda_u2d0.setId(this.stringTable.getFqNameIndex((ClassifierDescriptorWithTypeParameters)annotationClass));
        for (Map.Entry entry : annotation.getAllValueArguments().entrySet()) {
            Name name = (Name)entry.getKey();
            ConstantValue value = (ConstantValue)entry.getValue();
            ProtoBuf.Annotation.Argument.Builder argument = ProtoBuf.Annotation.Argument.newBuilder();
            String string2 = name.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
            argument.setNameId(this.stringTable.getStringIndex(string2));
            argument.setValue(this.valueProto(value));
            $this$serializeAnnotation_u24lambda_u2d0.addArgument(argument);
        }
        return builder.build();
    }

    @NotNull
    public final ProtoBuf.Annotation.Argument.Value.Builder valueProto(@NotNull ConstantValue<?> constant) {
        ProtoBuf.Annotation.Argument.Value.Builder builder;
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        ProtoBuf.Annotation.Argument.Value.Builder $this$valueProto_u24lambda_u2d1 = builder = ProtoBuf.Annotation.Argument.Value.newBuilder();
        boolean bl = false;
        constant.accept((AnnotationArgumentVisitor)new AnnotationArgumentVisitor<Unit, Unit>($this$valueProto_u24lambda_u2d1, this){
            final /* synthetic */ ProtoBuf.Annotation.Argument.Value.Builder $this_apply;
            final /* synthetic */ AnnotationSerializer this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void visitAnnotationValue(@NotNull AnnotationValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
                this.$this_apply.setAnnotation(this.this$0.serializeAnnotation((AnnotationDescriptor)value.getValue()));
            }

            public void visitArrayValue(@NotNull ArrayValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
                for (ConstantValue element : (List)value.getValue()) {
                    this.$this_apply.addArrayElement(this.this$0.valueProto(element).build());
                }
            }

            public void visitBooleanValue(@NotNull BooleanValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
                this.$this_apply.setIntValue((Boolean)value.getValue() != false ? 1L : 0L);
            }

            public void visitByteValue(@NotNull ByteValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue(((Number)value.getValue()).byteValue());
            }

            public void visitCharValue(@NotNull CharValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
                this.$this_apply.setIntValue(((Character)value.getValue()).charValue());
            }

            public void visitDoubleValue(@NotNull DoubleValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
                this.$this_apply.setDoubleValue(((Number)value.getValue()).doubleValue());
            }

            public void visitEnumValue(@NotNull EnumValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
                this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(value.getEnumClassId()));
                DescriptorAwareStringTable descriptorAwareStringTable = AnnotationSerializer.access$getStringTable$p(this.this$0);
                String string2 = value.getEnumEntryName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.enumEntryName.asString()");
                this.$this_apply.setEnumValueId(descriptorAwareStringTable.getStringIndex(string2));
            }

            public void visitErrorValue(@NotNull ErrorValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Error value: ", (Object)value));
            }

            public void visitFloatValue(@NotNull FloatValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
                this.$this_apply.setFloatValue(((Number)value.getValue()).floatValue());
            }

            public void visitIntValue(@NotNull IntValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue(((Number)value.getValue()).intValue());
            }

            public void visitKClassValue(@NotNull KClassValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CLASS);
                KClassValue.Value classValue = (KClassValue.Value)value.getValue();
                if (classValue instanceof KClassValue.Value.NormalClass) {
                    this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(((KClassValue.Value.NormalClass)classValue).getClassId()));
                    if (((KClassValue.Value.NormalClass)classValue).getArrayDimensions() > 0) {
                        this.$this_apply.setArrayDimensionCount(((KClassValue.Value.NormalClass)classValue).getArrayDimensions());
                    }
                } else if (classValue instanceof KClassValue.Value.LocalClass) {
                    ClassDescriptor classDescriptor;
                    int arrayDimensions = 0;
                    KotlinType type2 = ((KClassValue.Value.LocalClass)classValue).getType();
                    while (KotlinBuiltIns.isArray((KotlinType)type2)) {
                        int n = arrayDimensions;
                        arrayDimensions = n + 1;
                        KotlinType kotlinType = ((TypeProjection)CollectionsKt.single((List)type2.getArguments())).getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type.arguments.single().type");
                        type2 = kotlinType;
                    }
                    ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                    if (classDescriptor == null) {
                        throw new IllegalStateException(Intrinsics.stringPlus((String)"Type parameters are not allowed in class literal annotation arguments: ", (Object)classValue).toString());
                    }
                    ClassDescriptor descriptor = classDescriptor;
                    this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getFqNameIndex((ClassifierDescriptorWithTypeParameters)descriptor));
                    if (arrayDimensions > 0) {
                        this.$this_apply.setArrayDimensionCount(arrayDimensions);
                    }
                }
            }

            public void visitLongValue(@NotNull LongValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value.getValue()).longValue());
            }

            public void visitNullValue(@NotNull NullValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                throw new UnsupportedOperationException("Null should not appear in annotation arguments");
            }

            public void visitShortValue(@NotNull ShortValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue(((Number)value.getValue()).shortValue());
            }

            public void visitStringValue(@NotNull StringValue value, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
                this.$this_apply.setStringValue(AnnotationSerializer.access$getStringTable$p(this.this$0).getStringIndex((String)value.getValue()));
            }

            public void visitUByteValue(@NotNull UByteValue value, @Nullable Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue(((Number)value.getValue()).byteValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitUShortValue(@NotNull UShortValue value, @Nullable Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue(((Number)value.getValue()).shortValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitUIntValue(@NotNull UIntValue value, @Nullable Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue(((Number)value.getValue()).intValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitULongValue(@NotNull ULongValue value, @Nullable Unit data) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value.getValue()).longValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }
        }, (Object)Unit.INSTANCE);
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = builder;
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"newBuilder().apply {\n   \u2026 }\n        }, Unit)\n    }");
        return builder2;
    }

    protected boolean ignoreAnnotation(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return false;
    }

    public static final /* synthetic */ DescriptorAwareStringTable access$getStringTable$p(AnnotationSerializer $this) {
        return $this.stringTable;
    }
}

