/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirFlexibleType;
import org.jetbrains.kotlin.commonizer.cir.CirSimpleType;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.core.AssociativeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/FlexibleTypeAssociativeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirFlexibleType;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "options", "Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer$Options;)V", "commonize", "first", "second", "kotlin-klib-commonizer"})
final class FlexibleTypeAssociativeCommonizer
implements AssociativeCommonizer<CirFlexibleType> {
    @NotNull
    private final CirKnownClassifiers classifiers;
    @NotNull
    private final TypeCommonizer.Options options;

    public FlexibleTypeAssociativeCommonizer(@NotNull CirKnownClassifiers classifiers2, @NotNull TypeCommonizer.Options options) {
        Intrinsics.checkNotNullParameter((Object)classifiers2, (String)"classifiers");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.classifiers = classifiers2;
        this.options = options;
    }

    @Override
    @Nullable
    public CirFlexibleType commonize(@NotNull CirFlexibleType first, @NotNull CirFlexibleType second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        CirType cirType = new TypeCommonizer(this.classifiers, this.options).commonize(first.getLowerBound(), second.getLowerBound());
        if (cirType == null) {
            return null;
        }
        CirType lowerBound = cirType;
        CirType cirType2 = new TypeCommonizer(this.classifiers, this.options).commonize(first.getUpperBound(), second.getUpperBound());
        if (cirType2 == null) {
            return null;
        }
        CirType upperBound = cirType2;
        return new CirFlexibleType((CirSimpleType)lowerBound, (CirSimpleType)upperBound);
    }
}

