/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.TargetDependent;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/commonizer/MapBasedTargetDependent;", "T", "Lorg/jetbrains/kotlin/commonizer/TargetDependent;", "map", "", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "(Ljava/util/Map;)V", "targets", "", "getTargets", "()Ljava/util/List;", "get", "target", "(Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;)Ljava/lang/Object;", "kotlin-klib-commonizer"})
final class MapBasedTargetDependent<T>
implements TargetDependent<T> {
    @NotNull
    private final Map<CommonizerTarget, T> map;
    @NotNull
    private final List<CommonizerTarget> targets;

    public MapBasedTargetDependent(@NotNull Map<CommonizerTarget, ? extends T> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.map = map2;
        this.targets = CollectionsKt.toList((Iterable)this.map.keySet());
    }

    @Override
    @NotNull
    public List<CommonizerTarget> getTargets() {
        return this.targets;
    }

    @Override
    public T get(@NotNull CommonizerTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return (T)MapsKt.getValue(this.map, (Object)target);
    }

    @Override
    @NotNull
    public <R> TargetDependent<R> map(@NotNull Function2<? super CommonizerTarget, ? super T, ? extends R> mapper) {
        return TargetDependent.DefaultImpls.map(this, mapper);
    }

    @Override
    public T get(int index) {
        return TargetDependent.DefaultImpls.get(this, index);
    }

    @Override
    @Nullable
    public T getOrNull(int index) {
        return TargetDependent.DefaultImpls.getOrNull(this, index);
    }

    @Override
    @Nullable
    public T getOrNull(@NotNull CommonizerTarget target) {
        return TargetDependent.DefaultImpls.getOrNull(this, target);
    }

    @Override
    public int indexOf(@NotNull CommonizerTarget target) {
        return TargetDependent.DefaultImpls.indexOf(this, target);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return TargetDependent.DefaultImpls.iterator(this);
    }

    @Override
    public int getSize() {
        return TargetDependent.DefaultImpls.getSize(this);
    }
}

