/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.metadata.deserialization;

import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.internal.metadata.ProtoBuf;
import kotlinx.metadata.internal.metadata.deserialization.NameResolver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u0013\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0015\u0012\u0004\u0012\u00020\u00120\u00142\u0006\u0010\u0016\u001a\u00020\u000eH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lkotlinx/metadata/internal/metadata/deserialization/NameResolverImpl;", "Lkotlinx/metadata/internal/metadata/deserialization/NameResolver;", "strings", "Lkotlinx/metadata/internal/metadata/ProtoBuf$StringTable;", "qualifiedNames", "Lkotlinx/metadata/internal/metadata/ProtoBuf$QualifiedNameTable;", "(Lorg/jetbrains/kotlin/metadata/ProtoBuf$StringTable;Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable;)V", "getQualifiedNames", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$QualifiedNameTable;", "getStrings", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$StringTable;", "getPackageFqName", "", "index", "", "getQualifiedClassName", "getString", "isLocalClassName", "", "traverseIds", "Lkotlin/Triple;", "", "startingIndex", "metadata"})
public final class NameResolverImpl
implements NameResolver {
    @NotNull
    private final ProtoBuf.StringTable strings;
    @NotNull
    private final ProtoBuf.QualifiedNameTable qualifiedNames;

    public NameResolverImpl(@NotNull ProtoBuf.StringTable strings2, @NotNull ProtoBuf.QualifiedNameTable qualifiedNames) {
        Intrinsics.checkNotNullParameter((Object)strings2, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)qualifiedNames, (String)"qualifiedNames");
        this.strings = strings2;
        this.qualifiedNames = qualifiedNames;
    }

    @NotNull
    public final ProtoBuf.StringTable getStrings() {
        return this.strings;
    }

    @NotNull
    public final ProtoBuf.QualifiedNameTable getQualifiedNames() {
        return this.qualifiedNames;
    }

    @Override
    @NotNull
    public String getString(int index) {
        String string2 = this.strings.getString(index);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"strings.getString(index)");
        return string2;
    }

    @Override
    @NotNull
    public String getQualifiedClassName(int index) {
        Triple<List<String>, List<String>, Boolean> triple = this.traverseIds(index);
        List packageFqNameSegments = (List)triple.component1();
        List relativeClassNameSegments = (List)triple.component2();
        String className = CollectionsKt.joinToString$default((Iterable)relativeClassNameSegments, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        return packageFqNameSegments.isEmpty() ? className : CollectionsKt.joinToString$default((Iterable)packageFqNameSegments, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null) + '/' + className;
    }

    @Override
    public boolean isLocalClassName(int index) {
        return (Boolean)this.traverseIds(index).getThird();
    }

    @NotNull
    public final String getPackageFqName(int index) {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)this.traverseIds(index).getFirst()), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    private final Triple<List<String>, List<String>, Boolean> traverseIds(int startingIndex) {
        int index = startingIndex;
        LinkedList<String> packageNameSegments = new LinkedList<String>();
        LinkedList<String> relativeClassNameSegments = new LinkedList<String>();
        boolean local = false;
        while (index != -1) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Kind kind;
            ProtoBuf.QualifiedNameTable.QualifiedName proto = this.qualifiedNames.getQualifiedName(index);
            String shortName = this.strings.getString(proto.getShortName());
            Intrinsics.checkNotNull((Object)proto.getKind());
            int n = WhenMappings.$EnumSwitchMapping$0[kind.ordinal()];
            switch (n) {
                case 1: {
                    relativeClassNameSegments.addFirst(shortName);
                    break;
                }
                case 2: {
                    packageNameSegments.addFirst(shortName);
                    break;
                }
                case 3: {
                    relativeClassNameSegments.addFirst(shortName);
                    local = true;
                }
            }
            index = proto.getParentQualifiedName();
        }
        return new Triple(packageNameSegments, relativeClassNameSegments, (Object)local);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.values().length];
            nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS.ordinal()] = 1;
            nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.PACKAGE.ordinal()] = 2;
            nArray[ProtoBuf.QualifiedNameTable.QualifiedName.Kind.LOCAL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

