/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.konan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.CommonizerParameters;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.FacadeKt;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.ModulesProvider;
import org.jetbrains.kotlin.commonizer.ResultsConsumer;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.commonizer.TargetDependent;
import org.jetbrains.kotlin.commonizer.TargetDependentKt;
import org.jetbrains.kotlin.commonizer.TargetProvider;
import org.jetbrains.kotlin.commonizer.konan.DefaultModulesProvider;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrariesToCommonize;
import org.jetbrains.kotlin.commonizer.konan.NativeLibrary;
import org.jetbrains.kotlin.commonizer.konan.NativeLibraryKt;
import org.jetbrains.kotlin.commonizer.konan.NativeManifestDataProvider;
import org.jetbrains.kotlin.commonizer.repository.Repository;
import org.jetbrains.kotlin.commonizer.stats.StatsCollector;
import org.jetbrains.kotlin.commonizer.utils.ResettableClockMark;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B?\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002J\u0010\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0013H\u0002J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00132\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0002J\u0006\u0010\u001e\u001a\u00020\u0010R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/commonizer/konan/LibraryCommonizer;", "", "outputTargets", "", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "repository", "Lorg/jetbrains/kotlin/commonizer/repository/Repository;", "dependencies", "resultsConsumer", "Lorg/jetbrains/kotlin/commonizer/ResultsConsumer;", "statsCollector", "Lorg/jetbrains/kotlin/commonizer/stats/StatsCollector;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/util/Set;Lorg/jetbrains/kotlin/commonizer/repository/Repository;Lorg/jetbrains/kotlin/commonizer/repository/Repository;Lorg/jetbrains/kotlin/commonizer/ResultsConsumer;Lorg/jetbrains/kotlin/commonizer/stats/StatsCollector;Lorg/jetbrains/kotlin/util/Logger;)V", "checkPreconditions", "", "commonizeAndSaveResults", "libraries", "Lorg/jetbrains/kotlin/commonizer/TargetDependent;", "Lorg/jetbrains/kotlin/commonizer/konan/NativeLibrariesToCommonize;", "createDependenciesProvider", "Lorg/jetbrains/kotlin/commonizer/ModulesProvider;", "createManifestProvider", "Lorg/jetbrains/kotlin/commonizer/konan/NativeManifestDataProvider;", "createTargetProvider", "Lorg/jetbrains/kotlin/commonizer/TargetProvider;", "target", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "loadLibraries", "run", "kotlin-klib-commonizer"})
public final class LibraryCommonizer {
    @NotNull
    private final Set<SharedCommonizerTarget> outputTargets;
    @NotNull
    private final Repository repository;
    @NotNull
    private final Repository dependencies;
    @NotNull
    private final ResultsConsumer resultsConsumer;
    @Nullable
    private final StatsCollector statsCollector;
    @NotNull
    private final Logger logger;

    public LibraryCommonizer(@NotNull Set<SharedCommonizerTarget> outputTargets, @NotNull Repository repository, @NotNull Repository dependencies, @NotNull ResultsConsumer resultsConsumer2, @Nullable StatsCollector statsCollector, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)resultsConsumer2, (String)"resultsConsumer");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.outputTargets = outputTargets;
        this.repository = repository;
        this.dependencies = dependencies;
        this.resultsConsumer = resultsConsumer2;
        this.statsCollector = statsCollector;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void run() {
        Logger logger = this.logger;
        String message$iv = "Commonized all targets";
        boolean $i$f$progress = false;
        ResettableClockMark clock$iv = new ResettableClockMark();
        clock$iv.reset();
        try {
            boolean bl = false;
            this.checkPreconditions();
            TargetDependent<NativeLibrariesToCommonize> allLibraries = this.loadLibraries();
            this.commonizeAndSaveResults(allLibraries);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            void $this$progress$iv;
            void var6_8 = $this$progress$iv;
            if (var6_8 != null) {
                var6_8.log(message$iv + " \u001b[36min " + clock$iv.elapsedSinceLast() + "\u001b[0m");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final TargetDependent<NativeLibrariesToCommonize> loadLibraries() {
        TargetDependent<NativeLibrariesToCommonize> targetDependent;
        Logger logger = this.logger;
        String message$iv = "Resolved all libraries for commonization";
        boolean $i$f$progress = false;
        ResettableClockMark clock$iv = new ResettableClockMark();
        clock$iv.reset();
        try {
            TargetDependent<NativeLibrariesToCommonize> libraries2;
            boolean bl = false;
            TargetDependent<NativeLibrariesToCommonize> $this$forEachWithTarget$iv = libraries2 = TargetDependentKt.EagerTargetDependent((Iterable<? extends CommonizerTarget>)CommonizerTargetKt.allLeaves((Iterable<? extends CommonizerTarget>)this.outputTargets), (Function1)new Function1<CommonizerTarget, NativeLibrariesToCommonize>(this){
                final /* synthetic */ LibraryCommonizer this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final NativeLibrariesToCommonize invoke(@NotNull CommonizerTarget target) {
                    NativeLibrariesToCommonize nativeLibrariesToCommonize;
                    Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                    Collection $this$ifNotEmpty$iv = CollectionsKt.toList((Iterable)LibraryCommonizer.access$getRepository$p(this.this$0).getLibraries(target));
                    boolean $i$f$ifNotEmpty = false;
                    Collection collection = $this$ifNotEmpty$iv;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        List $this$invoke_u24lambda_u2d0 = (List)$this$ifNotEmpty$iv;
                        boolean bl2 = false;
                        nativeLibrariesToCommonize = new NativeLibrariesToCommonize(target, $this$invoke_u24lambda_u2d0);
                    } else {
                        nativeLibrariesToCommonize = null;
                    }
                    return nativeLibrariesToCommonize;
                }
            });
            boolean $i$f$forEachWithTarget = false;
            Iterable $this$forEach$iv$iv = $this$forEachWithTarget$iv.getTargets();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                void librariesOrNull;
                CommonizerTarget target$iv = (CommonizerTarget)element$iv$iv;
                boolean bl2 = false;
                NativeLibrariesToCommonize nativeLibrariesToCommonize = (NativeLibrariesToCommonize)$this$forEachWithTarget$iv.get(target$iv);
                CommonizerTarget target = target$iv;
                boolean bl3 = false;
                if (librariesOrNull != null) continue;
                this.logger.warning("No libraries found for target " + target + ". This target will be excluded from commonization.");
            }
            targetDependent = libraries2;
        }
        finally {
            void $this$progress$iv;
            void var6_8 = $this$progress$iv;
            if (var6_8 != null) {
                var6_8.log(message$iv + " \u001b[36min " + clock$iv.elapsedSinceLast() + "\u001b[0m");
            }
        }
        return targetDependent;
    }

    private final void commonizeAndSaveResults(TargetDependent<NativeLibrariesToCommonize> libraries2) {
        Set<SharedCommonizerTarget> set = this.outputTargets;
        TargetDependent targetDependent = libraries2.map((Function2)new Function2<CommonizerTarget, NativeLibrariesToCommonize, TargetProvider>(this){
            final /* synthetic */ LibraryCommonizer this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final TargetProvider invoke(@NotNull CommonizerTarget target, @Nullable NativeLibrariesToCommonize targetLibraries) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return LibraryCommonizer.access$createTargetProvider(this.this$0, target, targetLibraries);
            }
        });
        TargetDependent<NativeManifestDataProvider> targetDependent2 = this.createManifestProvider(libraries2);
        TargetDependent<ModulesProvider> targetDependent3 = this.createDependenciesProvider();
        ResultsConsumer resultsConsumer2 = this.resultsConsumer;
        StatsCollector statsCollector = this.statsCollector;
        Logger logger = this.logger;
        FacadeKt.runCommonization(new CommonizerParameters(set, targetDependent2, targetDependent3, targetDependent, resultsConsumer2, null, statsCollector, logger, 32, null));
    }

    private final TargetProvider createTargetProvider(CommonizerTarget target, NativeLibrariesToCommonize libraries2) {
        if (libraries2 == null) {
            return null;
        }
        return new TargetProvider(target, DefaultModulesProvider.Companion.create(libraries2));
    }

    private final TargetDependent<ModulesProvider> createDependenciesProvider() {
        return TargetDependentKt.TargetDependent(SetsKt.plus(this.outputTargets, (Iterable)CommonizerTargetKt.allLeaves((Iterable<? extends CommonizerTarget>)this.outputTargets)), (Function1)new Function1<CommonizerTarget, ModulesProvider>(this){
            final /* synthetic */ LibraryCommonizer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ModulesProvider invoke(@NotNull CommonizerTarget target) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                return DefaultModulesProvider.Companion.create((Iterable<NativeLibrary>)LibraryCommonizer.access$getDependencies$p(this.this$0).getLibraries(target));
            }
        });
    }

    private final TargetDependent<NativeManifestDataProvider> createManifestProvider(TargetDependent<NativeLibrariesToCommonize> libraries2) {
        return TargetDependentKt.TargetDependent((Iterable<? extends CommonizerTarget>)this.outputTargets, (Function1)new Function1<CommonizerTarget, NativeManifestDataProvider>(libraries2){
            final /* synthetic */ TargetDependent<NativeLibrariesToCommonize> $libraries;
            {
                this.$libraries = $libraries;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final NativeManifestDataProvider invoke(@NotNull CommonizerTarget target) {
                NativeManifestDataProvider nativeManifestDataProvider;
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                CommonizerTarget commonizerTarget = target;
                if (commonizerTarget instanceof LeafCommonizerTarget) {
                    NativeLibrariesToCommonize nativeLibrariesToCommonize = this.$libraries.get(target);
                    if (nativeLibrariesToCommonize == null) {
                        String string2 = Intrinsics.stringPlus((String)"Can't provide manifest for missing target ", (Object)target);
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(string2.toString());
                    }
                    nativeManifestDataProvider = nativeLibrariesToCommonize;
                } else if (commonizerTarget instanceof SharedCommonizerTarget) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Iterable iterable = CommonizerTargetKt.allLeaves(target);
                    TargetDependent<NativeLibrariesToCommonize> targetDependent = this.$libraries;
                    CommonizerTarget commonizerTarget2 = target;
                    boolean $i$f$mapNotNull = false;
                    void var6_10 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        NativeLibrariesToCommonize nativeLibrariesToCommonize;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        LeafCommonizerTarget leafTarget = (LeafCommonizerTarget)element$iv$iv;
                        boolean bl2 = false;
                        if (targetDependent.getOrNull(leafTarget) == null) continue;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        NativeLibrariesToCommonize it$iv$iv = nativeLibrariesToCommonize;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    nativeManifestDataProvider = NativeLibraryKt.NativeManifestDataProvider(commonizerTarget2, list);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return nativeManifestDataProvider;
            }
        });
    }

    private final void checkPreconditions() {
        Iterable $this$forEach$iv = this.outputTargets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SharedCommonizerTarget outputTarget = (SharedCommonizerTarget)element$iv;
            boolean bl = false;
            int n = CommonizerTargetKt.allLeaves(outputTarget).size();
            switch (n) {
                case 0: {
                    this.logger.fatal("No targets specified");
                    throw null;
                }
                case 1: {
                    this.logger.fatal(Intrinsics.stringPlus((String)"Too few targets specified: ", (Object)outputTarget));
                    throw null;
                }
            }
        }
    }

    public static final /* synthetic */ TargetProvider access$createTargetProvider(LibraryCommonizer $this, CommonizerTarget target, NativeLibrariesToCommonize libraries2) {
        return $this.createTargetProvider(target, libraries2);
    }

    public static final /* synthetic */ Repository access$getDependencies$p(LibraryCommonizer $this) {
        return $this.dependencies;
    }

    public static final /* synthetic */ Repository access$getRepository$p(LibraryCommonizer $this) {
        return $this.repository;
    }
}

