/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.commonizer.cir.CirEntityId;
import org.jetbrains.kotlin.commonizer.cir.CirTypeProjection;
import org.jetbrains.kotlin.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.commonizer.core.ClassTypeCommonizerKt;
import org.jetbrains.kotlin.commonizer.core.OuterClassTypeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeArgumentListCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;
import org.jetbrains.kotlin.descriptors.Visibility;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/ClassTypeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirClassType;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;)V", "anyVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "arguments", "Lorg/jetbrains/kotlin/commonizer/core/TypeArgumentListCommonizer;", "classId", "Lorg/jetbrains/kotlin/commonizer/cir/CirEntityId;", "isMarkedNullable", "", "outerType", "Lorg/jetbrains/kotlin/commonizer/core/OuterClassTypeCommonizer;", "commonizationResult", "doCommonizeWith", "next", "initialize", "", "first", "kotlin-klib-commonizer"})
public final class ClassTypeCommonizer
extends AbstractStandardCommonizer<CirClassType, CirClassType> {
    @NotNull
    private final CirKnownClassifiers classifiers;
    private CirEntityId classId;
    @NotNull
    private final OuterClassTypeCommonizer outerType;
    private Visibility anyVisibility;
    @NotNull
    private final TypeArgumentListCommonizer arguments;
    private boolean isMarkedNullable;

    public ClassTypeCommonizer(@NotNull CirKnownClassifiers classifiers) {
        Intrinsics.checkNotNullParameter((Object)classifiers, (String)"classifiers");
        this.classifiers = classifiers;
        this.outerType = new OuterClassTypeCommonizer(this.classifiers);
        this.arguments = new TypeArgumentListCommonizer(this.classifiers);
    }

    @Override
    @NotNull
    protected CirClassType commonizationResult() {
        CirEntityId cirEntityId;
        CirEntityId cirEntityId2;
        CirEntityId cirEntityId3 = this.classId;
        if (cirEntityId3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classId");
            cirEntityId2 = null;
        } else {
            cirEntityId2 = cirEntityId3;
        }
        CirClassType cirClassType = (CirClassType)this.outerType.getResult();
        cirEntityId3 = this.anyVisibility;
        if (cirEntityId3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"anyVisibility");
            cirEntityId = null;
        } else {
            cirEntityId = cirEntityId3;
        }
        return CirClassType.Companion.createInterned(cirEntityId2, cirClassType, (Visibility)cirEntityId, (List<? extends CirTypeProjection>)this.arguments.getResult(), this.isMarkedNullable);
    }

    @Override
    protected void initialize(@NotNull CirClassType first) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        this.classId = first.getClassifierId();
        this.anyVisibility = first.getVisibility();
        this.isMarkedNullable = first.isMarkedNullable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doCommonizeWith(@NotNull CirClassType next) {
        CirEntityId cirEntityId;
        CirEntityId cirEntityId2;
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        if (this.isMarkedNullable != next.isMarkedNullable()) return false;
        CirEntityId cirEntityId3 = this.classId;
        if (cirEntityId3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classId");
            cirEntityId2 = null;
        } else {
            cirEntityId2 = cirEntityId3;
        }
        if (!Intrinsics.areEqual((Object)cirEntityId2, (Object)next.getClassifierId())) return false;
        if (!this.outerType.commonizeWith(next.getOuterType())) return false;
        cirEntityId3 = this.classId;
        if (cirEntityId3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"classId");
            cirEntityId = null;
        } else {
            cirEntityId = cirEntityId3;
        }
        if (!ClassTypeCommonizerKt.access$isClassifierAvailableInCommon(this.classifiers, cirEntityId)) return false;
        if (!this.arguments.commonizeWith(next.getArguments())) return false;
        return true;
    }
}

