/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirName;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirValueParameter;
import org.jetbrains.kotlin.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.commonizer.core.AssociativeCommonizerAdapter;
import org.jetbrains.kotlin.commonizer.core.AssociativeCommonizerKt;
import org.jetbrains.kotlin.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;
import org.jetbrains.kotlin.commonizer.utils.MiscKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/ValueParameterCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirValueParameter;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;)V", "isCrossinline", "", "isNoinline", "name", "Lorg/jetbrains/kotlin/commonizer/cir/CirName;", "returnType", "Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizerAdapter;", "Lorg/jetbrains/kotlin/commonizer/cir/CirType;", "varargElementType", "commonizationResult", "doCommonizeWith", "next", "initialize", "", "first", "overwriteName", "kotlin-klib-commonizer"})
public final class ValueParameterCommonizer
extends AbstractStandardCommonizer<CirValueParameter, CirValueParameter> {
    private CirName name;
    @NotNull
    private final AssociativeCommonizerAdapter<CirType> returnType;
    @Nullable
    private CirType varargElementType;
    private boolean isCrossinline;
    private boolean isNoinline;

    public ValueParameterCommonizer(@NotNull CirKnownClassifiers classifiers) {
        Intrinsics.checkNotNullParameter((Object)classifiers, (String)"classifiers");
        this.returnType = AssociativeCommonizerKt.asCommonizer(new TypeCommonizer(classifiers));
        this.isCrossinline = true;
        this.isNoinline = true;
    }

    @Override
    @NotNull
    protected CirValueParameter commonizationResult() {
        CirName cirName;
        List list = CollectionsKt.emptyList();
        CirName cirName2 = this.name;
        if (cirName2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
            cirName = null;
        } else {
            cirName = cirName2;
        }
        return CirValueParameter.Companion.createInterned(list, cirName, (CirType)this.returnType.getResult(), this.varargElementType, false, this.isCrossinline, this.isNoinline);
    }

    @Override
    protected void initialize(@NotNull CirValueParameter first) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        this.name = first.getName();
        this.varargElementType = first.getVarargElementType();
        this.isCrossinline = first.isCrossinline();
        this.isNoinline = first.isNoinline();
    }

    @Override
    protected boolean doCommonizeWith(@NotNull CirValueParameter next) {
        boolean result;
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        boolean bl = result = !next.getDeclaresDefaultValue() && MiscKt.isNull(this.varargElementType) == MiscKt.isNull(next.getVarargElementType()) && this.returnType.commonizeWith(next.getReturnType());
        if (result) {
            this.isCrossinline = this.isCrossinline && next.isCrossinline();
            this.isNoinline = this.isNoinline && next.isNoinline();
        }
        return result;
    }

    public final void overwriteName(@NotNull CirName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }
}

