/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.commonizer.cir.CirFlexibleType;
import org.jetbrains.kotlin.commonizer.cir.CirSimpleType;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.core.AssociativeCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/FlexibleTypeAssociativeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AssociativeCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirFlexibleType;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;)V", "commonize", "first", "second", "kotlin-klib-commonizer"})
final class FlexibleTypeAssociativeCommonizer
implements AssociativeCommonizer<CirFlexibleType> {
    @NotNull
    private final CirKnownClassifiers classifiers;

    public FlexibleTypeAssociativeCommonizer(@NotNull CirKnownClassifiers classifiers) {
        Intrinsics.checkNotNullParameter((Object)classifiers, (String)"classifiers");
        this.classifiers = classifiers;
    }

    @Override
    @Nullable
    public CirFlexibleType commonize(@NotNull CirFlexibleType first, @NotNull CirFlexibleType second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        CirType cirType = new TypeCommonizer(this.classifiers).commonize(first.getLowerBound(), second.getLowerBound());
        if (cirType == null) {
            return null;
        }
        CirType lowerBound = cirType;
        CirType cirType2 = new TypeCommonizer(this.classifiers).commonize(first.getUpperBound(), second.getUpperBound());
        if (cirType2 == null) {
            return null;
        }
        CirType upperBound = cirType2;
        return new CirFlexibleType((CirSimpleType)lowerBound, (CirSimpleType)upperBound);
    }
}

