/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.library.impl;

import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.internal.library.impl.IrFileReadersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\u0004X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u0082\u0001\u0002\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lkotlinx/metadata/internal/library/impl/ReadBuffer;", "", "()V", "int", "", "getInt", "()I", "long", "", "getLong", "()J", "position", "getPosition", "setPosition", "(I)V", "size", "getSize", "get", "", "result", "", "offset", "length", "DirectFileBuffer", "MemoryBuffer", "NIOReader", "WeakFileBuffer", "Lkotlinx/metadata/internal/library/impl/ReadBuffer$NIOReader;", "Lkotlinx/metadata/internal/library/impl/ReadBuffer$WeakFileBuffer;", "kotlin-util-klib"})
public abstract class ReadBuffer {
    private ReadBuffer() {
    }

    public abstract int getSize();

    public abstract void get(@NotNull byte[] var1, int var2, int var3);

    public abstract int getPosition();

    public abstract void setPosition(int var1);

    public abstract int getInt();

    public abstract long getLong();

    public /* synthetic */ ReadBuffer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u001a"}, d2={"Lkotlinx/metadata/internal/library/impl/ReadBuffer$NIOReader;", "Lkotlinx/metadata/internal/library/impl/ReadBuffer;", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "int", "", "getInt", "()I", "long", "", "getLong", "()J", "value", "position", "getPosition", "setPosition", "(I)V", "size", "getSize", "get", "", "result", "", "offset", "length", "kotlin-util-klib"})
    public static abstract class NIOReader
    extends ReadBuffer {
        @NotNull
        private final ByteBuffer buffer;

        public NIOReader(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            super(null);
            this.buffer = buffer;
        }

        @Override
        public int getSize() {
            return this.buffer.limit();
        }

        @Override
        public void get(@NotNull byte[] result, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.buffer.get(result, offset, length);
        }

        @Override
        public int getPosition() {
            return this.buffer.position();
        }

        @Override
        public void setPosition(int value) {
            this.buffer.position(value);
        }

        @Override
        public int getInt() {
            return this.buffer.getInt();
        }

        @Override
        public long getLong() {
            return this.buffer.getLong();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lkotlinx/metadata/internal/library/impl/ReadBuffer$MemoryBuffer;", "Lkotlinx/metadata/internal/library/impl/ReadBuffer$NIOReader;", "bytes", "", "([B)V", "kotlin-util-klib"})
    public static final class MemoryBuffer
    extends NIOReader {
        public MemoryBuffer(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            super(IrFileReadersKt.getBuffer(bytes));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lkotlinx/metadata/internal/library/impl/ReadBuffer$DirectFileBuffer;", "Lkotlinx/metadata/internal/library/impl/ReadBuffer$NIOReader;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "kotlin-util-klib"})
    public static final class DirectFileBuffer
    extends NIOReader {
        public DirectFileBuffer(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            super(IrFileReadersKt.getBuffer(FilesKt.readBytes((File)file2)));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0017H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00068V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lkotlinx/metadata/internal/library/impl/ReadBuffer$WeakFileBuffer;", "Lkotlinx/metadata/internal/library/impl/ReadBuffer;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "int", "", "getInt", "()I", "long", "", "getLong", "()J", "pos", "value", "position", "getPosition", "setPosition", "(I)V", "size", "getSize", "weakBuffer", "Ljava/lang/ref/SoftReference;", "Ljava/nio/ByteBuffer;", "ensureBuffer", "get", "", "result", "", "offset", "length", "kotlin-util-klib"})
    public static final class WeakFileBuffer
    extends ReadBuffer {
        @NotNull
        private final File file;
        private int pos;
        @NotNull
        private SoftReference<ByteBuffer> weakBuffer;

        public WeakFileBuffer(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            super(null);
            this.file = file2;
            this.weakBuffer = new SoftReference<Object>(null);
        }

        @Override
        public int getSize() {
            return (int)this.file.length();
        }

        @Override
        public void get(@NotNull byte[] result, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            ByteBuffer buf = this.ensureBuffer();
            WeakFileBuffer weakFileBuffer = this;
            weakFileBuffer.pos += length;
            buf.get(result, offset, length);
        }

        @Override
        public int getInt() {
            ByteBuffer buf = this.ensureBuffer();
            WeakFileBuffer weakFileBuffer = this;
            weakFileBuffer.pos += 4;
            return buf.getInt();
        }

        @Override
        public long getLong() {
            ByteBuffer buf = this.ensureBuffer();
            WeakFileBuffer weakFileBuffer = this;
            weakFileBuffer.pos += 8;
            return buf.getLong();
        }

        @Override
        public int getPosition() {
            int n = this.pos;
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            boolean bl4 = it == this.ensureBuffer().position();
            boolean bl5 = false;
            boolean bl6 = false;
            if (_Assertions.ENABLED && !bl4) {
                boolean bl7 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            return n;
        }

        @Override
        public void setPosition(int value) {
            ByteBuffer buf = this.ensureBuffer();
            this.pos = value;
            buf.position(value);
        }

        private final ByteBuffer ensureBuffer() {
            ByteBuffer tmpBuffer = this.weakBuffer.get();
            if (tmpBuffer == null) {
                tmpBuffer = IrFileReadersKt.getBuffer(FilesKt.readBytes((File)this.file));
                tmpBuffer.position(this.pos);
                this.weakBuffer = new SoftReference<ByteBuffer>(tmpBuffer);
            }
            return tmpBuffer;
        }
    }
}

