/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.commonizer.core;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.cir.CirRegularTypeProjection;
import org.jetbrains.kotlin.commonizer.cir.CirStarTypeProjection;
import org.jetbrains.kotlin.commonizer.cir.CirType;
import org.jetbrains.kotlin.commonizer.cir.CirTypeProjection;
import org.jetbrains.kotlin.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.commonizer.core.TypeCommonizer;
import org.jetbrains.kotlin.commonizer.mergedtree.CirKnownClassifiers;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/commonizer/core/TypeArgumentCommonizer;", "Lorg/jetbrains/kotlin/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/commonizer/cir/CirTypeProjection;", "classifiers", "Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;", "(Lorg/jetbrains/kotlin/commonizer/mergedtree/CirKnownClassifiers;)V", "isStar", "", "projectionKind", "Lorg/jetbrains/kotlin/types/Variance;", "type", "Lorg/jetbrains/kotlin/commonizer/core/TypeCommonizer;", "commonizationResult", "doCommonizeWith", "next", "initialize", "", "first", "kotlin-klib-commonizer"})
public final class TypeArgumentCommonizer
extends AbstractStandardCommonizer<CirTypeProjection, CirTypeProjection> {
    private boolean isStar;
    private Variance projectionKind;
    @NotNull
    private final TypeCommonizer type;

    public TypeArgumentCommonizer(@NotNull CirKnownClassifiers classifiers) {
        Intrinsics.checkNotNullParameter((Object)classifiers, (String)"classifiers");
        this.type = new TypeCommonizer(classifiers);
    }

    @Override
    @NotNull
    protected CirTypeProjection commonizationResult() {
        CirTypeProjection cirTypeProjection;
        if (this.isStar) {
            cirTypeProjection = CirStarTypeProjection.INSTANCE;
        } else {
            Variance variance = this.projectionKind;
            if (variance == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectionKind");
                throw null;
            }
            cirTypeProjection = new CirRegularTypeProjection(variance, (CirType)this.type.getResult());
        }
        return cirTypeProjection;
    }

    @Override
    protected void initialize(@NotNull CirTypeProjection first) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        CirTypeProjection cirTypeProjection = first;
        if (cirTypeProjection instanceof CirStarTypeProjection) {
            this.isStar = true;
        } else if (cirTypeProjection instanceof CirRegularTypeProjection) {
            this.projectionKind = ((CirRegularTypeProjection)first).getProjectionKind();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean doCommonizeWith(@NotNull CirTypeProjection next) {
        Intrinsics.checkNotNullParameter((Object)next, (String)"next");
        CirTypeProjection cirTypeProjection = next;
        if (!(cirTypeProjection instanceof CirStarTypeProjection)) {
            if (!(cirTypeProjection instanceof CirRegularTypeProjection)) throw new NoWhenBranchMatchedException();
            if (this.isStar) return false;
            Variance variance = this.projectionKind;
            if (variance == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectionKind");
                throw null;
            }
            if (variance != ((CirRegularTypeProjection)next).getProjectionKind()) return false;
            if (!this.type.commonizeWith(((CirRegularTypeProjection)next).getType())) return false;
            return true;
        }
        boolean bl = this.isStar;
        return bl;
    }
}

