/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.utils.Interner;
import org.jetbrains.kotlin.descriptors.commonizer.utils.InternersKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a&\u0010\u0015\u001a\u00020\u0016*\u00060\u0017j\u0002`\u00182\u0006\u0010\u0019\u001a\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bH\u0002\"\u0018\u0010\u0000\u001a\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0019\u0010\u0004\u001a\u00020\u0005*\u00020\u00068\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u001c\u0010\u000e\u001a\u00060\u0002j\u0002`\u0003*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"typeSignatureInterner", "Lorg/jetbrains/kotlin/descriptors/commonizer/utils/Interner;", "", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirTypeSignature;", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getDeclarationDescriptor", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "internedClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "getInternedClassId", "(Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;)Lorg/jetbrains/kotlin/name/ClassId;", "signature", "getSignature", "(Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/lang/String;", "extractExpandedType", "Lorg/jetbrains/kotlin/types/SimpleType;", "abbreviated", "Lorg/jetbrains/kotlin/types/AbbreviatedType;", "buildTypeSignature", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "type", "exploredTypeParameters", "", "kotlin-klib-commonizer"})
public final class TypeKt {
    @NotNull
    private static final Interner<String> typeSignatureInterner = new Interner();

    @NotNull
    public static final ClassifierDescriptor getDeclarationDescriptor(@NotNull KotlinType $this$declarationDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$declarationDescriptor, (String)"<this>");
        boolean $i$f$getDeclarationDescriptor = false;
        ClassifierDescriptor classifierDescriptor = $this$declarationDescriptor.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            String string2 = Intrinsics.stringPlus((String)"No declaration descriptor found for ", (Object)$this$declarationDescriptor.getConstructor());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return classifierDescriptor;
    }

    @NotNull
    public static final SimpleType extractExpandedType(@NotNull AbbreviatedType abbreviated) {
        Intrinsics.checkNotNullParameter((Object)abbreviated, (String)"abbreviated");
        SimpleType expanded = abbreviated.getExpandedType();
        while (expanded instanceof AbbreviatedType) {
            KotlinType $this$declarationDescriptor$iv = (KotlinType)((AbbreviatedType)expanded).getAbbreviation();
            boolean $i$f$getDeclarationDescriptor = false;
            ClassifierDescriptor classifierDescriptor = $this$declarationDescriptor$iv.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                String string2 = Intrinsics.stringPlus((String)"No declaration descriptor found for ", (Object)$this$declarationDescriptor$iv.getConstructor());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            ClassifierDescriptor classifierDescriptor2 = classifierDescriptor;
            $this$declarationDescriptor$iv = (KotlinType)abbreviated.getAbbreviation();
            $i$f$getDeclarationDescriptor = false;
            classifierDescriptor = $this$declarationDescriptor$iv.getConstructor().getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                String string3 = Intrinsics.stringPlus((String)"No declaration descriptor found for ", (Object)$this$declarationDescriptor$iv.getConstructor());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            if (classifierDescriptor2 != classifierDescriptor) break;
            expanded = ((AbbreviatedType)expanded).getExpandedType();
        }
        return expanded;
    }

    @NotNull
    public static final ClassId getInternedClassId(@NotNull ClassifierDescriptorWithTypeParameters $this$internedClassId) {
        ClassId classId;
        Intrinsics.checkNotNullParameter((Object)$this$internedClassId, (String)"<this>");
        Object object = $this$internedClassId.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"containingDeclaration");
        DeclarationDescriptor owner = object;
        if (owner instanceof PackageFragmentDescriptor) {
            FqName fqName = InternersKt.intern(((PackageFragmentDescriptor)owner).getFqName());
            object = $this$internedClassId.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
            classId = InternersKt.internedClassId(fqName, InternersKt.intern((Name)object));
        } else if (owner instanceof ClassDescriptor) {
            ClassId classId2 = TypeKt.getInternedClassId((ClassifierDescriptorWithTypeParameters)owner);
            object = $this$internedClassId.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name");
            classId = InternersKt.internedClassId(classId2, InternersKt.intern((Name)object));
        } else {
            object = "Unexpected containing declaration type for " + $this$internedClassId + ": " + Reflection.getOrCreateKotlinClass(owner.getClass()) + ", " + owner;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        return classId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getSignature(@NotNull KotlinType $this$signature) {
        void $this$_get_signature__u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)$this$signature, (String)"<this>");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder stringBuilder2 = stringBuilder;
        Interner<String> interner = typeSignatureInterner;
        boolean bl5 = false;
        TypeKt.buildTypeSignature((StringBuilder)$this$_get_signature__u24lambda_u2d0, $this$signature, new HashSet());
        Unit unit = Unit.INSTANCE;
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return interner.intern(string2);
    }

    /*
     * WARNING - void declaration
     */
    private static final void buildTypeSignature(StringBuilder $this$buildTypeSignature, KotlinType type2, Set<KotlinType> exploredTypeParameters) {
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull((KotlinType)type2);
        if (typeParameterDescriptor != null) {
            $this$buildTypeSignature.append(typeParameterDescriptor.getName().asString());
            if (exploredTypeParameters.add(TypeUtilsKt.makeNotNullable((KotlinType)type2))) {
                $this$buildTypeSignature.append(":[");
                List list = typeParameterDescriptor.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"typeParameterDescriptor.upperBounds");
                Iterable $this$forEachIndexed$iv = list;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void upperBound;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    KotlinType kotlinType = (KotlinType)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    if (index > 0) {
                        $this$buildTypeSignature.append(",");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)upperBound, (String)"upperBound");
                    TypeKt.buildTypeSignature($this$buildTypeSignature, (KotlinType)upperBound, exploredTypeParameters);
                }
                $this$buildTypeSignature.append("]");
            }
            if (type2.isMarkedNullable()) {
                $this$buildTypeSignature.append("?");
            }
        } else {
            SimpleType index$iv;
            AbbreviatedType $i$f$forEachIndexed;
            AbbreviatedType abbreviatedType = $i$f$forEachIndexed = type2 instanceof AbbreviatedType ? (AbbreviatedType)type2 : null;
            KotlinType abbreviation = $i$f$forEachIndexed == null ? type2 : ((index$iv = $i$f$forEachIndexed.getAbbreviation()) == null ? type2 : (KotlinType)index$iv);
            Object $this$declarationDescriptor$iv = abbreviation;
            boolean $i$f$getDeclarationDescriptor = false;
            ClassifierDescriptor item$iv = $this$declarationDescriptor$iv.getConstructor().getDeclarationDescriptor();
            if (item$iv == null) {
                String string2 = Intrinsics.stringPlus((String)"No declaration descriptor found for ", (Object)$this$declarationDescriptor$iv.getConstructor());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            $i$f$forEachIndexed = DescriptorUtilsKt.getClassId((ClassifierDescriptor)item$iv);
            Intrinsics.checkNotNull((Object)$i$f$forEachIndexed);
            $this$buildTypeSignature.append($i$f$forEachIndexed.asString());
            List arguments = abbreviation.getArguments();
            $this$declarationDescriptor$iv = arguments;
            $i$f$getDeclarationDescriptor = false;
            if (!$this$declarationDescriptor$iv.isEmpty()) {
                $this$buildTypeSignature.append("<");
                Iterable $this$forEachIndexed$iv = arguments;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv) {
                    void argument;
                    int n = index$iv2++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    TypeProjection bl2 = (TypeProjection)item$iv2;
                    int index = n;
                    boolean bl3 = false;
                    if (index > 0) {
                        $this$buildTypeSignature.append(",");
                    }
                    if (argument.isStarProjection()) {
                        $this$buildTypeSignature.append("*");
                        continue;
                    }
                    Variance variance = argument.getProjectionKind();
                    Intrinsics.checkNotNullExpressionValue((Object)variance, (String)"argument.projectionKind");
                    Variance variance2 = variance;
                    if (variance2 != Variance.INVARIANT) {
                        $this$buildTypeSignature.append(variance2).append(" ");
                    }
                    variance = argument.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)variance, (String)"argument.type");
                    TypeKt.buildTypeSignature($this$buildTypeSignature, (KotlinType)variance, exploredTypeParameters);
                }
                $this$buildTypeSignature.append(">");
            }
            if (abbreviation.isMarkedNullable()) {
                $this$buildTypeSignature.append("?");
            }
        }
    }
}

