/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.builtins;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.metadata.internal.builtins.PrimitiveType;
import kotlinx.metadata.internal.builtins.functions.FunctionClassKind;
import kotlinx.metadata.internal.name.ClassId;
import kotlinx.metadata.internal.name.FqName;
import kotlinx.metadata.internal.name.FqNameUnsafe;
import kotlinx.metadata.internal.name.Name;
import kotlinx.metadata.internal.utils.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010$\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010'\u001a\u00020%2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*H\u0007J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020%H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0015X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lkotlinx/metadata/internal/builtins/StandardNames;", "", "()V", "ANNOTATION_PACKAGE_FQ_NAME", "Lkotlinx/metadata/internal/name/FqName;", "BUILT_INS_PACKAGE_FQ_NAME", "BUILT_INS_PACKAGE_FQ_NAMES", "", "BUILT_INS_PACKAGE_NAME", "Lkotlinx/metadata/internal/name/Name;", "CHAR_CODE", "COLLECTIONS_PACKAGE_FQ_NAME", "CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL", "CONTINUATION_INTERFACE_FQ_NAME_RELEASE", "COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL", "COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL", "COROUTINES_PACKAGE_FQ_NAME_RELEASE", "ENUM_VALUES", "ENUM_VALUE_OF", "KOTLIN_REFLECT_FQ_NAME", "K_FUNCTION_PREFIX", "", "K_MUTABLE_PROPERTY_PREFIX", "K_PROPERTY_PREFIX", "K_SUSPEND_FUNCTION_PREFIX", "PREFIXES", "", "RANGES_PACKAGE_FQ_NAME", "RESULT_FQ_NAME", "TEXT_PACKAGE_FQ_NAME", "getFunctionClassId", "Lkotlinx/metadata/internal/name/ClassId;", "parameterCount", "", "getFunctionName", "getKFunctionClassId", "getKFunctionFqName", "Lkotlinx/metadata/internal/name/FqNameUnsafe;", "getKSuspendFunctionClassId", "getKSuspendFunctionName", "getPrimitiveFqName", "primitiveType", "Lkotlinx/metadata/internal/builtins/PrimitiveType;", "getSuspendFunctionClassId", "getSuspendFunctionName", "isPrimitiveArray", "", "arrayFqName", "FqNames", "compiler.common"})
public final class StandardNames {
    @NotNull
    public static final StandardNames INSTANCE = new StandardNames();
    @JvmField
    @NotNull
    public static final Name ENUM_VALUES;
    @JvmField
    @NotNull
    public static final Name ENUM_VALUE_OF;
    @JvmField
    @NotNull
    public static final Name CHAR_CODE;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_PACKAGE_FQ_NAME_RELEASE;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL;
    @JvmField
    @NotNull
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL;
    @JvmField
    @NotNull
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL;
    @JvmField
    @NotNull
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME_RELEASE;
    @JvmField
    @NotNull
    public static final FqName RESULT_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName KOTLIN_REFLECT_FQ_NAME;
    @NotNull
    public static final String K_PROPERTY_PREFIX = "KProperty";
    @NotNull
    public static final String K_MUTABLE_PROPERTY_PREFIX = "KMutableProperty";
    @NotNull
    public static final String K_FUNCTION_PREFIX = "KFunction";
    @NotNull
    public static final String K_SUSPEND_FUNCTION_PREFIX = "KSuspendFunction";
    @JvmField
    @NotNull
    public static final List<String> PREFIXES;
    @JvmField
    @NotNull
    public static final Name BUILT_INS_PACKAGE_NAME;
    @JvmField
    @NotNull
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName RANGES_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final FqName TEXT_PACKAGE_FQ_NAME;
    @JvmField
    @NotNull
    public static final Set<FqName> BUILT_INS_PACKAGE_FQ_NAMES;

    private StandardNames() {
    }

    @JvmStatic
    @NotNull
    public static final String getFunctionName(int parameterCount) {
        return Intrinsics.stringPlus((String)"Function", (Object)parameterCount);
    }

    @JvmStatic
    @NotNull
    public static final ClassId getFunctionClassId(int parameterCount) {
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, Name.identifier(StandardNames.getFunctionName(parameterCount)));
    }

    @JvmStatic
    @NotNull
    public static final FqNameUnsafe getKFunctionFqName(int parameterCount) {
        return FqNames.reflect(Intrinsics.stringPlus((String)FunctionClassKind.KFunction.getClassNamePrefix(), (Object)parameterCount));
    }

    @JvmStatic
    @NotNull
    public static final ClassId getKFunctionClassId(int parameterCount) {
        FqNameUnsafe fqName = StandardNames.getKFunctionFqName(parameterCount);
        return new ClassId(fqName.parent().toSafe(), fqName.shortName());
    }

    @JvmStatic
    @NotNull
    public static final String getSuspendFunctionName(int parameterCount) {
        return Intrinsics.stringPlus((String)FunctionClassKind.SuspendFunction.getClassNamePrefix(), (Object)parameterCount);
    }

    @JvmStatic
    @NotNull
    public static final ClassId getSuspendFunctionClassId(int parameterCount) {
        return new ClassId(COROUTINES_PACKAGE_FQ_NAME_RELEASE, Name.identifier(StandardNames.getSuspendFunctionName(parameterCount)));
    }

    @JvmStatic
    @NotNull
    public static final FqNameUnsafe getKSuspendFunctionName(int parameterCount) {
        return FqNames.reflect(Intrinsics.stringPlus((String)FunctionClassKind.KSuspendFunction.getClassNamePrefix(), (Object)parameterCount));
    }

    @JvmStatic
    @NotNull
    public static final ClassId getKSuspendFunctionClassId(int parameterCount) {
        FqNameUnsafe fqName = StandardNames.getKSuspendFunctionName(parameterCount);
        return new ClassId(fqName.parent().toSafe(), fqName.shortName());
    }

    @JvmStatic
    public static final boolean isPrimitiveArray(@NotNull FqNameUnsafe arrayFqName) {
        Intrinsics.checkNotNullParameter((Object)arrayFqName, (String)"arrayFqName");
        return FqNames.arrayClassFqNameToPrimitiveType.get(arrayFqName) != null;
    }

    @JvmStatic
    @NotNull
    public static final FqName getPrimitiveFqName(@NotNull PrimitiveType primitiveType) {
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveType), (String)"primitiveType");
        FqName fqName = BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.getTypeName());
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType.typeName)");
        return fqName;
    }

    static {
        Object[] objectArray = Name.identifier("values");
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"identifier(\"values\")");
        ENUM_VALUES = objectArray;
        objectArray = Name.identifier("valueOf");
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"identifier(\"valueOf\")");
        ENUM_VALUE_OF = objectArray;
        objectArray = Name.identifier("code");
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"identifier(\"code\")");
        CHAR_CODE = objectArray;
        COROUTINES_PACKAGE_FQ_NAME_RELEASE = new FqName("kotlin.coroutines");
        objectArray = COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier("experimental"));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier(\"experimental\"))");
        COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL = objectArray;
        objectArray = COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("intrinsics"));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier(\"intrinsics\"))");
        COROUTINES_INTRINSICS_PACKAGE_FQ_NAME_EXPERIMENTAL = objectArray;
        objectArray = COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.child(Name.identifier(\"Continuation\"))");
        CONTINUATION_INTERFACE_FQ_NAME_EXPERIMENTAL = objectArray;
        objectArray = COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"COROUTINES_PACKAGE_FQ_NAME_RELEASE.child(Name.identifier(\"Continuation\"))");
        CONTINUATION_INTERFACE_FQ_NAME_RELEASE = objectArray;
        RESULT_FQ_NAME = new FqName("kotlin.Result");
        KOTLIN_REFLECT_FQ_NAME = new FqName("kotlin.reflect");
        objectArray = new String[]{K_PROPERTY_PREFIX, K_MUTABLE_PROPERTY_PREFIX, K_FUNCTION_PREFIX, K_SUSPEND_FUNCTION_PREFIX};
        PREFIXES = kotlin.collections.CollectionsKt.listOf((Object[])objectArray);
        objectArray = Name.identifier("kotlin");
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"identifier(\"kotlin\")");
        BUILT_INS_PACKAGE_NAME = objectArray;
        objectArray = FqName.topLevel(BUILT_INS_PACKAGE_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"topLevel(BUILT_INS_PACKAGE_NAME)");
        BUILT_INS_PACKAGE_FQ_NAME = objectArray;
        objectArray = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("annotation"));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(\"annotation\"))");
        ANNOTATION_PACKAGE_FQ_NAME = objectArray;
        objectArray = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("collections"));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(\"collections\"))");
        COLLECTIONS_PACKAGE_FQ_NAME = objectArray;
        objectArray = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("ranges"));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(\"ranges\"))");
        RANGES_PACKAGE_FQ_NAME = objectArray;
        objectArray = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("text"));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(\"text\"))");
        TEXT_PACKAGE_FQ_NAME = objectArray;
        objectArray = new FqName[7];
        objectArray[0] = BUILT_INS_PACKAGE_FQ_NAME;
        objectArray[1] = COLLECTIONS_PACKAGE_FQ_NAME;
        objectArray[2] = RANGES_PACKAGE_FQ_NAME;
        objectArray[3] = ANNOTATION_PACKAGE_FQ_NAME;
        objectArray[4] = KOTLIN_REFLECT_FQ_NAME;
        FqName fqName = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("internal"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(\"internal\"))");
        objectArray[5] = fqName;
        objectArray[6] = COROUTINES_PACKAGE_FQ_NAME_RELEASE;
        BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010]\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020_H\u0002J\u0010\u0010`\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020_H\u0002J\u0010\u0010a\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020_H\u0002J\u0010\u0010b\u001a\u00020\u00042\u0006\u0010^\u001a\u00020_H\u0002J\u0010\u0010c\u001a\u00020\u00042\u0006\u0010^\u001a\u00020_H\u0002J\u0010\u0010d\u001a\u00020\u00042\u0006\u0010^\u001a\u00020_H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u00148\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u001f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00107\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020D0C8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010H\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010N\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010P\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010R\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010S\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010T\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010U\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010V\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010W\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010X\u001a\u00020,8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Y\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010Z\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010[\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\\\u001a\u00020\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006e"}, d2={"Lkotlinx/metadata/internal/builtins/StandardNames$FqNames;", "", "()V", "_boolean", "Lkotlinx/metadata/internal/name/FqNameUnsafe;", "_byte", "_char", "_double", "_enum", "_float", "_int", "_long", "_short", "annotation", "Lkotlinx/metadata/internal/name/FqName;", "annotationRetention", "annotationTarget", "any", "array", "arrayClassFqNameToPrimitiveType", "", "Lkotlinx/metadata/internal/builtins/PrimitiveType;", "charSequence", "cloneable", "collection", "comparable", "deprecated", "deprecatedSinceKotlin", "deprecationLevel", "extensionFunctionType", "fqNameToPrimitiveType", "", "functionSupertype", "intRange", "iterable", "iterator", "kCallable", "kClass", "kDeclarationContainer", "kMutableProperty0", "kMutableProperty1", "kMutableProperty2", "kMutablePropertyFqName", "kProperty", "Lkotlinx/metadata/internal/name/ClassId;", "kProperty0", "kProperty1", "kProperty2", "kPropertyFqName", "list", "listIterator", "longRange", "map", "mapEntry", "mustBeDocumented", "mutableCollection", "mutableIterable", "mutableIterator", "mutableList", "mutableListIterator", "mutableMap", "mutableMapEntry", "mutableSet", "nothing", "number", "parameterName", "primitiveArrayTypeShortNames", "", "Lkotlinx/metadata/internal/name/Name;", "primitiveTypeShortNames", "publishedApi", "repeatable", "replaceWith", "retention", "set", "string", "suppress", "target", "throwable", "uByte", "uByteArrayFqName", "uByteFqName", "uInt", "uIntArrayFqName", "uIntFqName", "uLong", "uLongArrayFqName", "uLongFqName", "uShort", "uShortArrayFqName", "uShortFqName", "unit", "unsafeVariance", "annotationName", "simpleName", "", "collectionsFqName", "fqName", "fqNameUnsafe", "rangesFqName", "reflect", "compiler.common"})
    public static final class FqNames {
        @NotNull
        public static final FqNames INSTANCE;
        @JvmField
        @NotNull
        public static final FqNameUnsafe any;
        @JvmField
        @NotNull
        public static final FqNameUnsafe nothing;
        @JvmField
        @NotNull
        public static final FqNameUnsafe cloneable;
        @JvmField
        @NotNull
        public static final FqName suppress;
        @JvmField
        @NotNull
        public static final FqNameUnsafe unit;
        @JvmField
        @NotNull
        public static final FqNameUnsafe charSequence;
        @JvmField
        @NotNull
        public static final FqNameUnsafe string;
        @JvmField
        @NotNull
        public static final FqNameUnsafe array;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _boolean;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _char;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _byte;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _short;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _int;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _long;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _float;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _double;
        @JvmField
        @NotNull
        public static final FqNameUnsafe number;
        @JvmField
        @NotNull
        public static final FqNameUnsafe _enum;
        @JvmField
        @NotNull
        public static final FqNameUnsafe functionSupertype;
        @JvmField
        @NotNull
        public static final FqName throwable;
        @JvmField
        @NotNull
        public static final FqName comparable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe intRange;
        @JvmField
        @NotNull
        public static final FqNameUnsafe longRange;
        @JvmField
        @NotNull
        public static final FqName deprecated;
        @JvmField
        @NotNull
        public static final FqName deprecatedSinceKotlin;
        @JvmField
        @NotNull
        public static final FqName deprecationLevel;
        @JvmField
        @NotNull
        public static final FqName replaceWith;
        @JvmField
        @NotNull
        public static final FqName extensionFunctionType;
        @JvmField
        @NotNull
        public static final FqName parameterName;
        @JvmField
        @NotNull
        public static final FqName annotation;
        @JvmField
        @NotNull
        public static final FqName target;
        @JvmField
        @NotNull
        public static final FqName annotationTarget;
        @JvmField
        @NotNull
        public static final FqName annotationRetention;
        @JvmField
        @NotNull
        public static final FqName retention;
        @JvmField
        @NotNull
        public static final FqName repeatable;
        @JvmField
        @NotNull
        public static final FqName mustBeDocumented;
        @JvmField
        @NotNull
        public static final FqName unsafeVariance;
        @JvmField
        @NotNull
        public static final FqName publishedApi;
        @JvmField
        @NotNull
        public static final FqName iterator;
        @JvmField
        @NotNull
        public static final FqName iterable;
        @JvmField
        @NotNull
        public static final FqName collection;
        @JvmField
        @NotNull
        public static final FqName list;
        @JvmField
        @NotNull
        public static final FqName listIterator;
        @JvmField
        @NotNull
        public static final FqName set;
        @JvmField
        @NotNull
        public static final FqName map;
        @JvmField
        @NotNull
        public static final FqName mapEntry;
        @JvmField
        @NotNull
        public static final FqName mutableIterator;
        @JvmField
        @NotNull
        public static final FqName mutableIterable;
        @JvmField
        @NotNull
        public static final FqName mutableCollection;
        @JvmField
        @NotNull
        public static final FqName mutableList;
        @JvmField
        @NotNull
        public static final FqName mutableListIterator;
        @JvmField
        @NotNull
        public static final FqName mutableSet;
        @JvmField
        @NotNull
        public static final FqName mutableMap;
        @JvmField
        @NotNull
        public static final FqName mutableMapEntry;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kClass;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kCallable;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty0;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty1;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutableProperty2;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kPropertyFqName;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kMutablePropertyFqName;
        @JvmField
        @NotNull
        public static final ClassId kProperty;
        @JvmField
        @NotNull
        public static final FqNameUnsafe kDeclarationContainer;
        @JvmField
        @NotNull
        public static final FqName uByteFqName;
        @JvmField
        @NotNull
        public static final FqName uShortFqName;
        @JvmField
        @NotNull
        public static final FqName uIntFqName;
        @JvmField
        @NotNull
        public static final FqName uLongFqName;
        @JvmField
        @NotNull
        public static final ClassId uByte;
        @JvmField
        @NotNull
        public static final ClassId uShort;
        @JvmField
        @NotNull
        public static final ClassId uInt;
        @JvmField
        @NotNull
        public static final ClassId uLong;
        @JvmField
        @NotNull
        public static final FqName uByteArrayFqName;
        @JvmField
        @NotNull
        public static final FqName uShortArrayFqName;
        @JvmField
        @NotNull
        public static final FqName uIntArrayFqName;
        @JvmField
        @NotNull
        public static final FqName uLongArrayFqName;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveTypeShortNames;
        @JvmField
        @NotNull
        public static final Set<Name> primitiveArrayTypeShortNames;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> fqNameToPrimitiveType;
        @JvmField
        @NotNull
        public static final Map<FqNameUnsafe, PrimitiveType> arrayClassFqNameToPrimitiveType;

        private FqNames() {
        }

        private final FqNameUnsafe fqNameUnsafe(String simpleName) {
            FqNameUnsafe fqNameUnsafe = this.fqName(simpleName).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"fqName(simpleName).toUnsafe()");
            return fqNameUnsafe;
        }

        private final FqName fqName(String simpleName) {
            FqName fqName = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName));
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName))");
            return fqName;
        }

        private final FqName collectionsFqName(String simpleName) {
            FqName fqName = COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName));
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier(simpleName))");
            return fqName;
        }

        private final FqNameUnsafe rangesFqName(String simpleName) {
            FqNameUnsafe fqNameUnsafe = RANGES_PACKAGE_FQ_NAME.child(Name.identifier(simpleName)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"RANGES_PACKAGE_FQ_NAME.child(Name.identifier(simpleName)).toUnsafe()");
            return fqNameUnsafe;
        }

        @JvmStatic
        @NotNull
        public static final FqNameUnsafe reflect(@NotNull String simpleName) {
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            FqNameUnsafe fqNameUnsafe = KOTLIN_REFLECT_FQ_NAME.child(Name.identifier(simpleName)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"KOTLIN_REFLECT_FQ_NAME.child(Name.identifier(simpleName)).toUnsafe()");
            return fqNameUnsafe;
        }

        private final FqName annotationName(String simpleName) {
            FqName fqName = ANNOTATION_PACKAGE_FQ_NAME.child(Name.identifier(simpleName));
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"ANNOTATION_PACKAGE_FQ_NAME.child(Name.identifier(simpleName))");
            return fqName;
        }

        static {
            Object object;
            Name name2;
            PrimitiveType it;
            Collection collection;
            PrimitiveType item$iv;
            int n;
            INSTANCE = new FqNames();
            any = INSTANCE.fqNameUnsafe("Any");
            nothing = INSTANCE.fqNameUnsafe("Nothing");
            cloneable = INSTANCE.fqNameUnsafe("Cloneable");
            suppress = INSTANCE.fqName("Suppress");
            unit = INSTANCE.fqNameUnsafe("Unit");
            charSequence = INSTANCE.fqNameUnsafe("CharSequence");
            string = INSTANCE.fqNameUnsafe("String");
            array = INSTANCE.fqNameUnsafe("Array");
            _boolean = INSTANCE.fqNameUnsafe("Boolean");
            _char = INSTANCE.fqNameUnsafe("Char");
            _byte = INSTANCE.fqNameUnsafe("Byte");
            _short = INSTANCE.fqNameUnsafe("Short");
            _int = INSTANCE.fqNameUnsafe("Int");
            _long = INSTANCE.fqNameUnsafe("Long");
            _float = INSTANCE.fqNameUnsafe("Float");
            _double = INSTANCE.fqNameUnsafe("Double");
            number = INSTANCE.fqNameUnsafe("Number");
            _enum = INSTANCE.fqNameUnsafe("Enum");
            functionSupertype = INSTANCE.fqNameUnsafe("Function");
            throwable = INSTANCE.fqName("Throwable");
            comparable = INSTANCE.fqName("Comparable");
            intRange = INSTANCE.rangesFqName("IntRange");
            longRange = INSTANCE.rangesFqName("LongRange");
            deprecated = INSTANCE.fqName("Deprecated");
            deprecatedSinceKotlin = INSTANCE.fqName("DeprecatedSinceKotlin");
            deprecationLevel = INSTANCE.fqName("DeprecationLevel");
            replaceWith = INSTANCE.fqName("ReplaceWith");
            extensionFunctionType = INSTANCE.fqName("ExtensionFunctionType");
            parameterName = INSTANCE.fqName("ParameterName");
            annotation = INSTANCE.fqName("Annotation");
            target = INSTANCE.annotationName("Target");
            annotationTarget = INSTANCE.annotationName("AnnotationTarget");
            annotationRetention = INSTANCE.annotationName("AnnotationRetention");
            retention = INSTANCE.annotationName("Retention");
            repeatable = INSTANCE.annotationName("Repeatable");
            mustBeDocumented = INSTANCE.annotationName("MustBeDocumented");
            unsafeVariance = INSTANCE.fqName("UnsafeVariance");
            publishedApi = INSTANCE.fqName("PublishedApi");
            iterator = INSTANCE.collectionsFqName("Iterator");
            iterable = INSTANCE.collectionsFqName("Iterable");
            FqNames.collection = INSTANCE.collectionsFqName("Collection");
            list = INSTANCE.collectionsFqName("List");
            listIterator = INSTANCE.collectionsFqName("ListIterator");
            set = INSTANCE.collectionsFqName("Set");
            map = INSTANCE.collectionsFqName("Map");
            Object object2 = map.child(Name.identifier("Entry"));
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"map.child(Name.identifier(\"Entry\"))");
            mapEntry = object2;
            mutableIterator = INSTANCE.collectionsFqName("MutableIterator");
            mutableIterable = INSTANCE.collectionsFqName("MutableIterable");
            mutableCollection = INSTANCE.collectionsFqName("MutableCollection");
            mutableList = INSTANCE.collectionsFqName("MutableList");
            mutableListIterator = INSTANCE.collectionsFqName("MutableListIterator");
            mutableSet = INSTANCE.collectionsFqName("MutableSet");
            mutableMap = INSTANCE.collectionsFqName("MutableMap");
            object2 = mutableMap.child(Name.identifier("MutableEntry"));
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"mutableMap.child(Name.identifier(\"MutableEntry\"))");
            mutableMapEntry = object2;
            kClass = FqNames.reflect("KClass");
            kCallable = FqNames.reflect("KCallable");
            kProperty0 = FqNames.reflect("KProperty0");
            kProperty1 = FqNames.reflect("KProperty1");
            kProperty2 = FqNames.reflect("KProperty2");
            kMutableProperty0 = FqNames.reflect("KMutableProperty0");
            kMutableProperty1 = FqNames.reflect("KMutableProperty1");
            kMutableProperty2 = FqNames.reflect("KMutableProperty2");
            kPropertyFqName = FqNames.reflect(StandardNames.K_PROPERTY_PREFIX);
            kMutablePropertyFqName = FqNames.reflect(StandardNames.K_MUTABLE_PROPERTY_PREFIX);
            object2 = ClassId.topLevel(kPropertyFqName.toSafe());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(kPropertyFqName.toSafe())");
            kProperty = object2;
            kDeclarationContainer = FqNames.reflect("KDeclarationContainer");
            uByteFqName = INSTANCE.fqName("UByte");
            uShortFqName = INSTANCE.fqName("UShort");
            uIntFqName = INSTANCE.fqName("UInt");
            uLongFqName = INSTANCE.fqName("ULong");
            object2 = ClassId.topLevel(uByteFqName);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(uByteFqName)");
            uByte = object2;
            object2 = ClassId.topLevel(uShortFqName);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(uShortFqName)");
            uShort = object2;
            object2 = ClassId.topLevel(uIntFqName);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(uIntFqName)");
            uInt = object2;
            object2 = ClassId.topLevel(uLongFqName);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"topLevel(uLongFqName)");
            uLong = object2;
            uByteArrayFqName = INSTANCE.fqName("UByteArray");
            uShortArrayFqName = INSTANCE.fqName("UShortArray");
            uIntArrayFqName = INSTANCE.fqName("UIntArray");
            uLongArrayFqName = INSTANCE.fqName("ULongArray");
            object2 = CollectionsKt.newHashSetWithExpectedSize((int)PrimitiveType.values().length);
            boolean bl = false;
            boolean bl2 = false;
            Object $this$primitiveTypeShortNames_u24lambda_u2d1 = object2;
            boolean bl3 = false;
            PrimitiveType[] $this$mapTo$iv = PrimitiveType.values();
            boolean $i$f$mapTo = false;
            PrimitiveType[] primitiveTypeArray = $this$mapTo$iv;
            int n2 = primitiveTypeArray.length;
            for (n = 0; n < n2; ++n) {
                PrimitiveType primitiveType = item$iv = primitiveTypeArray[n];
                collection = (Collection)$this$primitiveTypeShortNames_u24lambda_u2d1;
                boolean bl4 = false;
                name2 = it.getTypeName();
                collection.add(name2);
            }
            Collection cfr_ignored_0 = (Collection)$this$primitiveTypeShortNames_u24lambda_u2d1;
            primitiveTypeShortNames = (Set)object2;
            object2 = CollectionsKt.newHashSetWithExpectedSize((int)PrimitiveType.values().length);
            bl = false;
            bl2 = false;
            Object $this$primitiveArrayTypeShortNames_u24lambda_u2d3 = object2;
            boolean bl5 = false;
            $this$mapTo$iv = PrimitiveType.values();
            $i$f$mapTo = false;
            primitiveTypeArray = $this$mapTo$iv;
            n2 = primitiveTypeArray.length;
            for (n = 0; n < n2; ++n) {
                it = item$iv = primitiveTypeArray[n];
                collection = (Collection)$this$primitiveArrayTypeShortNames_u24lambda_u2d3;
                boolean bl6 = false;
                name2 = it.getArrayTypeName();
                collection.add(name2);
            }
            Collection cfr_ignored_1 = (Collection)$this$primitiveArrayTypeShortNames_u24lambda_u2d3;
            primitiveArrayTypeShortNames = (Set)object2;
            object2 = CollectionsKt.newHashMapWithExpectedSize((int)PrimitiveType.values().length);
            bl = false;
            bl2 = false;
            Object $this$fqNameToPrimitiveType_u24lambda_u2d4 = object2;
            boolean bl7 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                Map map = (Map)$this$fqNameToPrimitiveType_u24lambda_u2d4;
                object = primitiveType.getTypeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"primitiveType.typeName.asString()");
                object = INSTANCE.fqNameUnsafe((String)object);
                boolean bl8 = false;
                map.put(object, primitiveType);
            }
            fqNameToPrimitiveType = (Map)object2;
            object2 = CollectionsKt.newHashMapWithExpectedSize((int)PrimitiveType.values().length);
            bl = false;
            bl2 = false;
            Object $this$arrayClassFqNameToPrimitiveType_u24lambda_u2d5 = object2;
            boolean bl9 = false;
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                Map map = (Map)$this$arrayClassFqNameToPrimitiveType_u24lambda_u2d5;
                object = primitiveType.getArrayTypeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"primitiveType.arrayTypeName.asString()");
                object = INSTANCE.fqNameUnsafe((String)object);
                boolean bl10 = false;
                map.put(object, primitiveType);
            }
            arrayClassFqNameToPrimitiveType = (Map)object2;
        }
    }
}

