/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirClass;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirClassOrTypeAliasType;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirClassType;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirClassifier;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirTypeAlias;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirTypeAliasType;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirTypeProjection;
import org.jetbrains.kotlin.descriptors.commonizer.cir.factory.CirTypeFactory;
import org.jetbrains.kotlin.descriptors.commonizer.core.AbstractStandardCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.CommonizedTypeAliasAnswer;
import org.jetbrains.kotlin.descriptors.commonizer.core.CommonizerKt;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeAliasUtilsKt;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeArgumentListCommonizer;
import org.jetbrains.kotlin.descriptors.commonizer.core.TypeCommonizerKt;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirKnownClassifiers;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeAliasTypeCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/AbstractStandardCommonizer;", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirTypeAliasType;", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirClassOrTypeAliasType;", "classifiers", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirKnownClassifiers;", "(Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirKnownClassifiers;)V", "arguments", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeArgumentListCommonizer;", "commonizedTypeBuilder", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeAliasTypeCommonizer$CommonizedTypeAliasTypeBuilder;", "isMarkedNullable", "", "typeAliasId", "Lorg/jetbrains/kotlin/name/ClassId;", "commonizationResult", "doCommonizeWith", "next", "initialize", "", "first", "CommonizedTypeAliasTypeBuilder", "kotlin-klib-commonizer"})
final class TypeAliasTypeCommonizer
extends AbstractStandardCommonizer<CirTypeAliasType, CirClassOrTypeAliasType> {
    @NotNull
    private final CirKnownClassifiers classifiers;
    private ClassId typeAliasId;
    @NotNull
    private final TypeArgumentListCommonizer arguments;
    private boolean isMarkedNullable;
    @Nullable
    private CommonizedTypeAliasTypeBuilder commonizedTypeBuilder;

    public TypeAliasTypeCommonizer(@NotNull CirKnownClassifiers classifiers2) {
        Intrinsics.checkNotNullParameter((Object)classifiers2, (String)"classifiers");
        this.classifiers = classifiers2;
        this.arguments = new TypeArgumentListCommonizer(this.classifiers);
    }

    @Override
    @NotNull
    protected CirClassOrTypeAliasType commonizationResult() {
        CommonizedTypeAliasTypeBuilder commonizedTypeAliasTypeBuilder = this.commonizedTypeBuilder;
        if (commonizedTypeAliasTypeBuilder == null) {
            CommonizerKt.failInEmptyState(this);
            throw null;
        }
        CommonizedTypeAliasTypeBuilder commonizedTypeAliasTypeBuilder2 = commonizedTypeAliasTypeBuilder;
        commonizedTypeAliasTypeBuilder = this.typeAliasId;
        if (commonizedTypeAliasTypeBuilder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"typeAliasId");
            throw null;
        }
        return commonizedTypeAliasTypeBuilder2.build((ClassId)commonizedTypeAliasTypeBuilder, (List<? extends CirTypeProjection>)this.arguments.getResult(), this.isMarkedNullable);
    }

    @Override
    protected void initialize(@NotNull CirTypeAliasType first) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        this.typeAliasId = first.getClassifierId();
        this.isMarkedNullable = first.isMarkedNullable();
    }

    @Override
    protected boolean doCommonizeWith(@NotNull CirTypeAliasType next) {
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)next, (String)"next");
                if (this.isMarkedNullable != next.isMarkedNullable()) break block14;
                ClassId classId = this.typeAliasId;
                if (classId == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"typeAliasId");
                    throw null;
                }
                if (Intrinsics.areEqual((Object)classId, (Object)next.getClassifierId())) break block15;
            }
            return false;
        }
        if (this.commonizedTypeBuilder == null) {
            CommonizedTypeAliasTypeBuilder commonizedTypeAliasTypeBuilder;
            ClassId classId = this.typeAliasId;
            if (classId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"typeAliasId");
                throw null;
            }
            CommonizedTypeAliasAnswer answer = TypeCommonizerKt.access$commonizeTypeAlias(classId, this.classifiers);
            if (!answer.getCommonized()) {
                return false;
            }
            CirClassifier commonClassifier = answer.getCommonClassifier();
            if (commonClassifier instanceof CirClass) {
                commonizedTypeAliasTypeBuilder = CommonizedTypeAliasTypeBuilder.Companion.forClass((CirClass)commonClassifier);
            } else if (commonClassifier instanceof CirTypeAlias) {
                commonizedTypeAliasTypeBuilder = CommonizedTypeAliasTypeBuilder.Companion.forTypeAlias((CirTypeAlias)commonClassifier);
            } else if (commonClassifier == null) {
                CirClassOrTypeAliasType cirClassOrTypeAliasType = TypeAliasUtilsKt.computeSuitableUnderlyingType(this.classifiers, next.getUnderlyingType());
                if (cirClassOrTypeAliasType == null) {
                    return false;
                }
                CirClassOrTypeAliasType underlyingType = cirClassOrTypeAliasType;
                commonizedTypeAliasTypeBuilder = CommonizedTypeAliasTypeBuilder.Companion.forKnownUnderlyingType(underlyingType);
            } else {
                String string2 = "Unexpected common classifier type: " + commonClassifier.getClass() + ", " + commonClassifier;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            this.commonizedTypeBuilder = commonizedTypeAliasTypeBuilder;
        }
        return this.arguments.commonizeWith(next.getArguments());
    }

    @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\bb\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bJ&\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeAliasTypeCommonizer$CommonizedTypeAliasTypeBuilder;", "", "build", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirClassOrTypeAliasType;", "typeAliasId", "Lorg/jetbrains/kotlin/name/ClassId;", "arguments", "", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirTypeProjection;", "isMarkedNullable", "", "Companion", "kotlin-klib-commonizer"})
    private static interface CommonizedTypeAliasTypeBuilder {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public CirClassOrTypeAliasType build(@NotNull ClassId var1, @NotNull List<? extends CirTypeProjection> var2, boolean var3);

        @Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeAliasTypeCommonizer$CommonizedTypeAliasTypeBuilder$Companion;", "", "()V", "forClass", "Lorg/jetbrains/kotlin/descriptors/commonizer/core/TypeAliasTypeCommonizer$CommonizedTypeAliasTypeBuilder;", "commonClass", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirClass;", "forKnownUnderlyingType", "underlyingType", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirClassOrTypeAliasType;", "forTypeAlias", "modifiedTypeAlias", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirTypeAlias;", "kotlin-klib-commonizer"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final CommonizedTypeAliasTypeBuilder forClass(@NotNull CirClass commonClass) {
                Intrinsics.checkNotNullParameter((Object)commonClass, (String)"commonClass");
                return new CommonizedTypeAliasTypeBuilder(commonClass){
                    final /* synthetic */ CirClass $commonClass;
                    {
                        this.$commonClass = $commonClass;
                    }

                    @NotNull
                    public CirClassType build(@NotNull ClassId typeAliasId, @NotNull List<? extends CirTypeProjection> arguments, boolean isMarkedNullable) {
                        Intrinsics.checkNotNullParameter((Object)typeAliasId, (String)"typeAliasId");
                        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
                        return CirTypeFactory.INSTANCE.createClassType(typeAliasId, null, this.$commonClass.getVisibility(), arguments, isMarkedNullable);
                    }
                };
            }

            @NotNull
            public final CommonizedTypeAliasTypeBuilder forTypeAlias(@NotNull CirTypeAlias modifiedTypeAlias) {
                Intrinsics.checkNotNullParameter((Object)modifiedTypeAlias, (String)"modifiedTypeAlias");
                return this.forKnownUnderlyingType(modifiedTypeAlias.getUnderlyingType());
            }

            @NotNull
            public final CommonizedTypeAliasTypeBuilder forKnownUnderlyingType(@NotNull CirClassOrTypeAliasType underlyingType) {
                Intrinsics.checkNotNullParameter((Object)underlyingType, (String)"underlyingType");
                return new CommonizedTypeAliasTypeBuilder(underlyingType){
                    final /* synthetic */ CirClassOrTypeAliasType $underlyingType;
                    {
                        this.$underlyingType = $underlyingType;
                    }

                    @NotNull
                    public CirTypeAliasType build(@NotNull ClassId typeAliasId, @NotNull List<? extends CirTypeProjection> arguments, boolean isMarkedNullable) {
                        Intrinsics.checkNotNullParameter((Object)typeAliasId, (String)"typeAliasId");
                        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
                        CirClassOrTypeAliasType underlyingTypeWithProperNullability = isMarkedNullable && !this.$underlyingType.isMarkedNullable() ? CirTypeFactory.INSTANCE.makeNullable(this.$underlyingType) : this.$underlyingType;
                        return CirTypeFactory.INSTANCE.createTypeAliasType(typeAliasId, underlyingTypeWithProperNullability, arguments, isMarkedNullable);
                    }
                };
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }
}

