/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.metadata.internal.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.metadata.internal.builtins.KotlinBuiltIns;
import kotlinx.metadata.internal.descriptors.ClassConstructorDescriptor;
import kotlinx.metadata.internal.descriptors.ClassDescriptor;
import kotlinx.metadata.internal.descriptors.ClassifierDescriptor;
import kotlinx.metadata.internal.descriptors.DeclarationDescriptor;
import kotlinx.metadata.internal.descriptors.FindClassInModuleKt;
import kotlinx.metadata.internal.descriptors.ModuleDescriptor;
import kotlinx.metadata.internal.descriptors.NotFoundClasses;
import kotlinx.metadata.internal.descriptors.SourceElement;
import kotlinx.metadata.internal.descriptors.ValueParameterDescriptor;
import kotlinx.metadata.internal.descriptors.annotations.AnnotationDescriptor;
import kotlinx.metadata.internal.descriptors.annotations.AnnotationDescriptorImpl;
import kotlinx.metadata.internal.metadata.ProtoBuf;
import kotlinx.metadata.internal.metadata.deserialization.Flags;
import kotlinx.metadata.internal.metadata.deserialization.NameResolver;
import kotlinx.metadata.internal.name.ClassId;
import kotlinx.metadata.internal.name.Name;
import kotlinx.metadata.internal.resolve.DescriptorUtils;
import kotlinx.metadata.internal.resolve.constants.AnnotationValue;
import kotlinx.metadata.internal.resolve.constants.ArrayValue;
import kotlinx.metadata.internal.resolve.constants.BooleanValue;
import kotlinx.metadata.internal.resolve.constants.ByteValue;
import kotlinx.metadata.internal.resolve.constants.CharValue;
import kotlinx.metadata.internal.resolve.constants.ConstantValue;
import kotlinx.metadata.internal.resolve.constants.ConstantValueFactory;
import kotlinx.metadata.internal.resolve.constants.DoubleValue;
import kotlinx.metadata.internal.resolve.constants.EnumValue;
import kotlinx.metadata.internal.resolve.constants.ErrorValue;
import kotlinx.metadata.internal.resolve.constants.FloatValue;
import kotlinx.metadata.internal.resolve.constants.IntValue;
import kotlinx.metadata.internal.resolve.constants.KClassValue;
import kotlinx.metadata.internal.resolve.constants.LongValue;
import kotlinx.metadata.internal.resolve.constants.ShortValue;
import kotlinx.metadata.internal.resolve.constants.StringValue;
import kotlinx.metadata.internal.resolve.constants.UByteValue;
import kotlinx.metadata.internal.resolve.constants.UIntValue;
import kotlinx.metadata.internal.resolve.constants.ULongValue;
import kotlinx.metadata.internal.resolve.constants.UShortValue;
import kotlinx.metadata.internal.serialization.deserialization.NameResolverUtilKt;
import kotlinx.metadata.internal.types.ErrorUtils;
import kotlinx.metadata.internal.types.KotlinType;
import kotlinx.metadata.internal.types.SimpleType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J>\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\"\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JN\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010(\"\u0004\b\u0001\u0010'*\u0002H(2\u0006\u0010)\u001a\u00020\u00122\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u0002H'0+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u0002H'0+H\u0082\b\u00a2\u0006\u0002\u0010-R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lkotlinx/metadata/internal/serialization/deserialization/AnnotationDeserializer;", "", "module", "Lkotlinx/metadata/internal/descriptors/ModuleDescriptor;", "notFoundClasses", "Lkotlinx/metadata/internal/descriptors/NotFoundClasses;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/descriptors/NotFoundClasses;)V", "builtIns", "Lkotlinx/metadata/internal/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "deserializeAnnotation", "Lkotlinx/metadata/internal/descriptors/annotations/AnnotationDescriptor;", "proto", "Lkotlinx/metadata/internal/metadata/ProtoBuf$Annotation;", "nameResolver", "Lkotlinx/metadata/internal/metadata/deserialization/NameResolver;", "doesValueConformToExpectedType", "", "result", "Lkotlinx/metadata/internal/resolve/constants/ConstantValue;", "expectedType", "Lkotlinx/metadata/internal/types/KotlinType;", "value", "Lkotlinx/metadata/internal/metadata/ProtoBuf$Annotation$Argument$Value;", "resolveArgument", "Lkotlin/Pair;", "Lkotlinx/metadata/internal/name/Name;", "Lkotlinx/metadata/internal/metadata/ProtoBuf$Annotation$Argument;", "parameterByName", "", "Lkotlinx/metadata/internal/descriptors/ValueParameterDescriptor;", "resolveClass", "Lkotlinx/metadata/internal/descriptors/ClassDescriptor;", "classId", "Lkotlinx/metadata/internal/name/ClassId;", "resolveValue", "resolveValueAndCheckExpectedType", "letIf", "R", "T", "predicate", "f", "Lkotlin/Function1;", "g", "(Ljava/lang/Object;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "deserialization"})
public final class AnnotationDeserializer {
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final NotFoundClasses notFoundClasses;

    public AnnotationDeserializer(@NotNull ModuleDescriptor module, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)notFoundClasses, (String)"notFoundClasses");
        this.module = module;
        this.notFoundClasses = notFoundClasses;
    }

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver2) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        ClassDescriptor annotationClass = this.resolveClass(NameResolverUtilKt.getClassId(nameResolver2, proto.getId()));
        Map arguments = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError((DeclarationDescriptor)((DeclarationDescriptor)annotationClass)) && DescriptorUtils.isAnnotationClass((DeclarationDescriptor)((DeclarationDescriptor)annotationClass))) {
            Collection collection = annotationClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"annotationClass.constructors");
            ClassConstructorDescriptor constructor = (ClassConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)collection);
            if (constructor != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$associateByTo$iv$iv;
                List list = constructor.getValueParameters();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"constructor.valueParameters");
                List<ProtoBuf.Annotation.Argument> $this$associateBy$iv = list;
                boolean $i$f$associateBy = false;
                int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                List<ProtoBuf.Annotation.Argument> list2 = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Name name2 = it.getName();
                    map.put(name2, element$iv$iv);
                }
                Map parameterByName = destination$iv$iv;
                $this$associateBy$iv = proto.getArgumentList();
                Intrinsics.checkNotNullExpressionValue($this$associateBy$iv, (String)"proto.argumentList");
                Iterable $this$mapNotNull$iv = $this$associateBy$iv;
                boolean $i$f$mapNotNull = false;
                Iterable capacity$iv22 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Pair<Name, ConstantValue<?>> pair;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ProtoBuf.Annotation.Argument it = (ProtoBuf.Annotation.Argument)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (this.resolveArgument(it, parameterByName, nameResolver2) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Pair<Name, ConstantValue<?>> it$iv$iv = pair;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                arguments = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
            }
        }
        return (AnnotationDescriptor)new AnnotationDescriptorImpl((KotlinType)annotationClass.getDefaultType(), arguments, SourceElement.NO_SOURCE);
    }

    private final Pair<Name, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver2) {
        Object object = parameterByName.get(NameResolverUtilKt.getName(nameResolver2, proto.getNameId()));
        if (object == null) {
            return null;
        }
        ValueParameterDescriptor parameter = object;
        Name name2 = NameResolverUtilKt.getName(nameResolver2, proto.getNameId());
        object = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameter.type");
        ValueParameterDescriptor valueParameterDescriptor = object;
        object = proto.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"proto.value");
        return new Pair((Object)name2, this.resolveValueAndCheckExpectedType((KotlinType)valueParameterDescriptor, (ProtoBuf.Annotation.Argument.Value)object, nameResolver2));
    }

    private final ConstantValue<?> resolveValueAndCheckExpectedType(KotlinType expectedType, ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver2) {
        ConstantValue constantValue = this.resolveValue(expectedType, value, nameResolver2);
        boolean bl = false;
        boolean bl2 = false;
        ConstantValue it = constantValue;
        boolean bl3 = false;
        ConstantValue constantValue2 = this.doesValueConformToExpectedType(it, expectedType, value) ? constantValue : null;
        return constantValue2 == null ? (ConstantValue)ErrorValue.Companion.create("Unexpected argument value: actual type " + value.getType() + " != expected type " + expectedType) : constantValue2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver2) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)nameResolver2, (String)"nameResolver");
        Object object = Flags.IS_UNSIGNED.get(value.getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"IS_UNSIGNED.get(value.flags)");
        boolean isUnsigned = (Boolean)object;
        object = value.getType();
        int n = object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
        switch (n) {
            case 1: {
                UByteValue uByteValue;
                AnnotationDeserializer annotationDeserializer = this;
                byte $this$letIf$iv = (byte)value.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    byte p0 = $this$letIf$iv;
                    boolean bl = false;
                    uByteValue = new UByteValue(p0);
                } else {
                    byte p0 = $this$letIf$iv;
                    boolean bl = false;
                    uByteValue = new ByteValue(p0);
                }
                constantValue = (ConstantValue)uByteValue;
                break;
            }
            case 2: {
                constantValue = (ConstantValue)new CharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                UShortValue uShortValue;
                AnnotationDeserializer this_$iv = this;
                short $this$letIf$iv = (short)value.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    short p0 = $this$letIf$iv;
                    boolean bl = false;
                    uShortValue = new UShortValue(p0);
                } else {
                    short p0 = $this$letIf$iv;
                    boolean bl = false;
                    uShortValue = new ShortValue(p0);
                }
                constantValue = (ConstantValue)uShortValue;
                break;
            }
            case 4: {
                UIntValue uIntValue;
                AnnotationDeserializer this_$iv = this;
                int $this$letIf$iv = (int)value.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    int p0 = $this$letIf$iv;
                    boolean bl = false;
                    uIntValue = new UIntValue(p0);
                } else {
                    int p0 = $this$letIf$iv;
                    boolean bl = false;
                    uIntValue = new IntValue(p0);
                }
                constantValue = (ConstantValue)uIntValue;
                break;
            }
            case 5: {
                ULongValue uLongValue;
                AnnotationDeserializer this_$iv = this;
                long $this$letIf$iv = value.getIntValue();
                boolean $i$f$letIf = false;
                if (isUnsigned) {
                    long p0 = $this$letIf$iv;
                    boolean bl = false;
                    uLongValue = new ULongValue(p0);
                } else {
                    long p0 = $this$letIf$iv;
                    boolean bl = false;
                    uLongValue = new LongValue(p0);
                }
                constantValue = (ConstantValue)uLongValue;
                break;
            }
            case 6: {
                constantValue = (ConstantValue)new FloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                constantValue = (ConstantValue)new DoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                constantValue = (ConstantValue)new BooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                constantValue = (ConstantValue)new StringValue(nameResolver2.getString(value.getStringValue()));
                break;
            }
            case 10: {
                constantValue = (ConstantValue)new KClassValue(NameResolverUtilKt.getClassId(nameResolver2, value.getClassId()), value.getArrayDimensionCount());
                break;
            }
            case 11: {
                constantValue = (ConstantValue)new EnumValue(NameResolverUtilKt.getClassId(nameResolver2, value.getClassId()), NameResolverUtilKt.getName(nameResolver2, value.getEnumValueId()));
                break;
            }
            case 12: {
                ProtoBuf.Annotation this_$iv = value.getAnnotation();
                Intrinsics.checkNotNullExpressionValue((Object)this_$iv, (String)"value.annotation");
                constantValue = (ConstantValue)new AnnotationValue(this.deserializeAnnotation(this_$iv, nameResolver2));
                break;
            }
            case 13: {
                Collection<ConstantValue<?>> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable<ProtoBuf.Annotation.Argument.Value> this_$iv = value.getArrayElementList();
                Intrinsics.checkNotNullExpressionValue(this_$iv, (String)"value.arrayElementList");
                this_$iv = this_$iv;
                ConstantValueFactory constantValueFactory = ConstantValueFactory.INSTANCE;
                boolean $i$f$map = false;
                void $i$f$letIf = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ProtoBuf.Annotation.Argument.Value value2 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    SimpleType simpleType2 = this.getBuiltIns().getAnyType();
                    Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"builtIns.anyType");
                    KotlinType kotlinType = (KotlinType)simpleType2;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    ConstantValue<?> constantValue2 = this.resolveValue(kotlinType, (ProtoBuf.Annotation.Argument.Value)it, nameResolver2);
                    collection.add(constantValue2);
                }
                collection = (List)destination$iv$iv;
                constantValue = (ConstantValue)constantValueFactory.createArrayValue((List)collection, expectedType);
                break;
            }
            default: {
                String string2 = "Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ')';
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return constantValue;
    }

    private final boolean doesValueConformToExpectedType(ConstantValue<?> result, KotlinType expectedType, ProtoBuf.Annotation.Argument.Value value) {
        boolean bl;
        ProtoBuf.Annotation.Argument.Value.Type type2 = value.getType();
        int n = type2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type2.ordinal()];
        block0 : switch (n) {
            case 10: {
                ClassDescriptor expectedClass;
                ClassifierDescriptor classifierDescriptor = expectedType.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor = expectedClass = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (expectedClass == null || KotlinBuiltIns.isKClass((ClassDescriptor)expectedClass)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 13: {
                boolean expectedClass = result instanceof ArrayValue && ((List)((ArrayValue)result).getValue()).size() == value.getArrayElementList().size();
                boolean bl2 = false;
                boolean bl3 = false;
                if (!expectedClass) {
                    boolean bl4 = false;
                    String string2 = Intrinsics.stringPlus((String)"Deserialized ArrayValue should have the same number of elements as the original array value: ", result);
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                KotlinType kotlinType = this.getBuiltIns().getArrayElementType(expectedType);
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"builtIns.getArrayElementType(expectedType)");
                KotlinType expectedElementType = kotlinType;
                Iterable $this$all$iv = (Iterable)CollectionsKt.getIndices((Collection)((Collection)((ArrayValue)result).getValue()));
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                    break;
                }
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int i = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl5 = false;
                    ConstantValue constantValue = (ConstantValue)((List)((ArrayValue)result).getValue()).get(i);
                    ProtoBuf.Annotation.Argument.Value value2 = value.getArrayElement(i);
                    Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value.getArrayElement(i)");
                    if (this.doesValueConformToExpectedType(constantValue, expectedElementType, value2)) continue;
                    bl = false;
                    break block0;
                }
                bl = true;
                break;
            }
            default: {
                bl = Intrinsics.areEqual((Object)result.getType(this.module), (Object)expectedType);
            }
        }
        return bl;
    }

    private final <T, R> R letIf(T $this$letIf, boolean predicate, Function1<? super T, ? extends R> f, Function1<? super T, ? extends R> g) {
        boolean $i$f$letIf = false;
        return (R)(predicate ? f.invoke($this$letIf) : g.invoke($this$letIf));
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        return FindClassInModuleKt.findNonGenericClassAcrossDependencies((ModuleDescriptor)this.module, (ClassId)classId, (NotFoundClasses)this.notFoundClasses);
    }

    @Metadata(mv={1, 5, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.Annotation.Argument.Value.Type.values().length];
            nArray[ProtoBuf.Annotation.Argument.Value.Type.BYTE.ordinal()] = 1;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.CHAR.ordinal()] = 2;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.SHORT.ordinal()] = 3;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.INT.ordinal()] = 4;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.LONG.ordinal()] = 5;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.FLOAT.ordinal()] = 6;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.DOUBLE.ordinal()] = 7;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN.ordinal()] = 8;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.STRING.ordinal()] = 9;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.CLASS.ordinal()] = 10;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.ENUM.ordinal()] = 11;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION.ordinal()] = 12;
            nArray[ProtoBuf.Annotation.Argument.Value.Type.ARRAY.ordinal()] = 13;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

