/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.konan;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataMetadataVersionKt;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataMonolithicSerializer;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.builtins.konan.KonanBuiltIns;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.FacadeKt;
import org.jetbrains.kotlin.descriptors.commonizer.InputTarget;
import org.jetbrains.kotlin.descriptors.commonizer.ModuleResult;
import org.jetbrains.kotlin.descriptors.commonizer.OutputTarget;
import org.jetbrains.kotlin.descriptors.commonizer.Parameters;
import org.jetbrains.kotlin.descriptors.commonizer.Result;
import org.jetbrains.kotlin.descriptors.commonizer.Target;
import org.jetbrains.kotlin.descriptors.commonizer.TargetProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.CommonNativeManifestDataProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeDistributionCommonizer$WhenMappings;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeDistributionLibraries;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeDistributionModulesProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeManifestDataProvider;
import org.jetbrains.kotlin.descriptors.commonizer.konan.NativeSensitiveManifestData;
import org.jetbrains.kotlin.descriptors.commonizer.stats.AggregatedStatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.FileStatsOutput;
import org.jetbrains.kotlin.descriptors.commonizer.stats.RawStatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.stats.StatsCollector;
import org.jetbrains.kotlin.descriptors.commonizer.utils.ResettableClockMark;
import org.jetbrains.kotlin.descriptors.konan.UtilsKt;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.library.NativeLibraryConstantsKt;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.library.BaseWriter;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.impl.BaseWriterImpl;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.impl.KotlinLibraryWriterImpl;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.konan.impl.KlibResolvedModuleDescriptorsFactoryImpl;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 B2\u00020\u0001:\u0002BCBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0\u001fH\u0002J\b\u0010!\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0002J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0002J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u001bH\u0002J\u0006\u0010.\u001a\u00020\u001bJ$\u0010/\u001a\u00020\u001b2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020 0\u001f2\u0006\u00101\u001a\u00020\u001dH\u0002JD\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020,2\f\u00105\u001a\b\u0012\u0004\u0012\u000207062\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0002J \u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010\u0007\u001a\u00020\u0003H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u0003*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u00020\u0003*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer;", "", "repository", "Ljava/io/File;", "targets", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "destination", "copyStdlib", "", "copyEndorsedLibs", "statsType", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$StatsType;", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/io/File;Ljava/util/List;Ljava/io/File;ZZLorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$StatsType;Lorg/jetbrains/kotlin/util/Logger;)V", "clockMark", "Lorg/jetbrains/kotlin/descriptors/commonizer/utils/ResettableClockMark;", "librariesDestination", "Lorg/jetbrains/kotlin/descriptors/commonizer/Target;", "getLibrariesDestination", "(Lorg/jetbrains/kotlin/descriptors/commonizer/Target;)Ljava/io/File;", "platformLibrariesSource", "Lorg/jetbrains/kotlin/descriptors/commonizer/InputTarget;", "getPlatformLibrariesSource", "(Lorg/jetbrains/kotlin/descriptors/commonizer/InputTarget;)Ljava/io/File;", "checkPreconditions", "", "commonize", "Lorg/jetbrains/kotlin/descriptors/commonizer/Result;", "librariesByTargets", "", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionLibraries;", "copyCommonStandardLibraries", "copyTargetAsIs", "leafTarget", "librariesCount", "", "loadLibraries", "loadLibrary", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "location", "logProgress", "message", "", "logTotal", "run", "saveModules", "originalLibrariesByTargets", "result", "serializeTarget", "target", "targetName", "newModules", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "absentModuleLocations", "manifestProvider", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeManifestDataProvider;", "serializer", "Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataMonolithicSerializer;", "writeLibrary", "metadata", "Lorg/jetbrains/kotlin/library/SerializedMetadata;", "manifestData", "Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeSensitiveManifestData;", "Companion", "StatsType", "kotlin-klib-commonizer"})
public final class NativeDistributionCommonizer {
    private final ResettableClockMark clockMark;
    private final java.io.File repository;
    private final List<KonanTarget> targets;
    private final java.io.File destination;
    private final boolean copyStdlib;
    private final boolean copyEndorsedLibs;
    private final StatsType statsType;
    private final Logger logger;
    @NotNull
    private static final Companion Companion = new Companion(null);

    public final void run() {
        this.checkPreconditions();
        this.clockMark.reset();
        Map<InputTarget, NativeDistributionLibraries> librariesByTargets = this.loadLibraries();
        Result result = this.commonize(librariesByTargets);
        this.saveModules(librariesByTargets, result);
        this.logTotal();
    }

    private final void checkPreconditions() {
        if (!this.repository.isDirectory()) {
            Void void_ = this.logger.fatal("Repository does not exist: " + this.repository);
            throw null;
        }
        switch (this.targets.size()) {
            case 0: {
                Void void_ = this.logger.fatal("No targets specified");
                throw null;
            }
            case 1: {
                Void void_ = this.logger.fatal("Too few targets specified: " + this.targets);
                throw null;
            }
        }
        if (!this.destination.exists()) {
            this.destination.mkdirs();
        } else {
            boolean bl;
            block10: {
                if (!this.destination.isDirectory()) {
                    Void void_ = this.logger.fatal("Output already exists: " + this.destination);
                    throw null;
                }
                Sequence $this$any$iv = (Sequence)FilesKt.walkTopDown((java.io.File)this.destination);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    java.io.File it = (java.io.File)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)this.destination) ^ true)) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            if (bl) {
                Void void_ = this.logger.fatal("Output is not empty: " + this.destination);
                throw null;
            }
        }
    }

    private final void logProgress(String message) {
        this.logger.log("* " + message + " in " + this.clockMark.elapsedSinceLast());
    }

    private final void logTotal() {
        this.logger.log("TOTAL: " + this.clockMark.elapsedSinceStart());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Map<InputTarget, NativeDistributionLibraries> loadLibraries() {
        stdlibPath = FilesKt.resolve((java.io.File)this.repository, (java.io.File)NativeLibraryConstantsKt.konanCommonLibraryPath((String)"stdlib"));
        stdlib = this.loadLibrary(stdlibPath);
        $this$associate$iv = this.targets;
        $i$f$associate = false;
        capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        var7_6 = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
        $i$f$associateTo = false;
        for (T element$iv$iv : $this$associateTo$iv$iv) {
            var12_11 = destination$iv$iv;
            target = (KonanTarget)element$iv$iv;
            $i$a$-associate-NativeDistributionCommonizer$loadLibraries$result$1 = false;
            leafTarget = new InputTarget(target.getName(), target);
            var16_15 = this.getPlatformLibrariesSource(leafTarget);
            var17_16 = false;
            var18_17 = false;
            it = var16_15;
            $i$a$-takeIf-NativeDistributionCommonizer$loadLibraries$result$1$platformLibs$1 = false;
            v0 /* !! */  = it.isDirectory() != false ? var16_15 : null;
            if (v0 /* !! */  == null || (v0 /* !! */  = v0 /* !! */ .listFiles()) == null) ** GOTO lbl-1000
            var16_15 = v0 /* !! */ ;
            var17_16 = false;
            var18_17 = false;
            it = var16_15;
            $i$a$-takeIf-NativeDistributionCommonizer$loadLibraries$result$1$platformLibs$2 = false;
            var21_21 = it;
            var22_22 = 0;
            var23_23 = var21_21;
            var24_25 = false;
            v0 /* !! */  = var23_23.length == 0 == false != false ? var16_15 : null;
            if (v0 /* !! */  != null) {
                var16_15 = v0 /* !! */ ;
                $i$f$map = false;
                var18_18 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                $i$f$mapTo = false;
                var21_21 = $this$mapTo$iv$iv;
                var22_22 = var21_21.length;
                for (var23_24 = 0; var23_24 < var22_22; ++var23_24) {
                    var25_27 = item$iv$iv = var21_21[var23_24];
                    var26_28 = destination$iv$iv;
                    $i$a$-map-NativeDistributionCommonizer$loadLibraries$result$1$platformLibs$3 = false;
                    v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    var28_30 = this.loadLibrary((java.io.File)v1);
                    var26_28.add(var28_30);
                }
                v2 = (List)destination$iv$iv;
            } else lbl-1000:
            // 2 sources

            {
                v2 = null;
            }
            var16_15 = v2;
            var17_16 = false;
            v3 /* !! */  = var16_15;
            if (var16_15 == null) {
                v3 /* !! */  = platformLibs = CollectionsKt.emptyList();
            }
            if (platformLibs.isEmpty()) {
                this.logger.warning("No platform libraries found for target " + target + ". This target will be excluded from commonization.");
            }
            var13_12 = TuplesKt.to((Object)leafTarget, (Object)new NativeDistributionLibraries(stdlib, (List<? extends KotlinLibrary>)platformLibs));
            var14_13 = false;
            var12_11.put(var13_12.getFirst(), var13_12.getSecond());
        }
        result = destination$iv$iv;
        this.logProgress("Read lazy (uninitialized) libraries");
        return result;
    }

    private final KotlinLibrary loadLibrary(java.io.File location) {
        KlibMetadataVersion metadataVersion;
        if (!location.isDirectory()) {
            Void void_ = this.logger.fatal("Library not found: " + location);
            throw null;
        }
        String string = location.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"location.path");
        KotlinLibrary library = SingleFileResolveKt.resolveSingleFileKlib((File)new File(string), (Logger)this.logger, (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE));
        if (library.getVersions().getMetadataVersion() == null) {
            Void void_ = this.logger.fatal("Library does not have metadata version specified in manifest: " + location);
            throw null;
        }
        KlibMetadataVersion klibMetadataVersion = metadataVersion = KlibMetadataMetadataVersionKt.getMetadataVersion((KotlinLibrary)library);
        if (klibMetadataVersion == null || !klibMetadataVersion.isCompatible()) {
            StringBuilder stringBuilder = new StringBuilder().append("\n                Library has incompatible metadata version ");
            Object object = metadataVersion;
            if (object == null) {
                object = "\"unknown\"";
            }
            Void void_ = this.logger.fatal(StringsKt.trimIndent((String)stringBuilder.append(object).append(": ").append(location).append("\n                Please make sure that all libraries passed to commonizer compatible metadata version ").append(KlibMetadataVersion.INSTANCE).append("\n                ").toString()));
            throw null;
        }
        return library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Result commonize(Map<InputTarget, NativeDistributionLibraries> librariesByTargets) {
        StatsCollector statsCollector;
        switch (NativeDistributionCommonizer$WhenMappings.$EnumSwitchMapping$0[this.statsType.ordinal()]) {
            case 1: {
                statsCollector = new RawStatsCollector(this.targets, new FileStatsOutput(this.destination, "raw"));
                break;
            }
            case 2: {
                statsCollector = new AggregatedStatsCollector(this.targets, new FileStatsOutput(this.destination, "aggregated"));
                break;
            }
            case 3: {
                statsCollector = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        StatsCollector statsCollector2 = statsCollector;
        Closeable closeable = statsCollector2;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            StatsCollector it = (StatsCollector)closeable;
            boolean bl3 = false;
            Parameters parameters2 = new Parameters(statsCollector2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){

                public final void invoke(@NotNull String p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    NativeDistributionCommonizer.access$logProgress((NativeDistributionCommonizer)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NativeDistributionCommonizer.class);
                }

                public final String getName() {
                    return "logProgress";
                }

                public final String getSignature() {
                    return "logProgress(Ljava/lang/String;)V";
                }
            }));
            boolean bl4 = false;
            boolean bl5 = false;
            Parameters $this$apply = parameters2;
            boolean bl6 = false;
            Map<InputTarget, NativeDistributionLibraries> $this$forEach$iv = librariesByTargets;
            boolean $i$f$forEach = false;
            Map<InputTarget, NativeDistributionLibraries> map2 = $this$forEach$iv;
            boolean bl7 = false;
            Iterator<Map.Entry<InputTarget, NativeDistributionLibraries>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                void target;
                Map.Entry<InputTarget, NativeDistributionLibraries> element$iv;
                Map.Entry<InputTarget, NativeDistributionLibraries> $dstr$target$libraries = element$iv = iterator.next();
                boolean bl8 = false;
                Map.Entry<InputTarget, NativeDistributionLibraries> entry = $dstr$target$libraries;
                boolean bl9 = false;
                InputTarget inputTarget = entry.getKey();
                entry = $dstr$target$libraries;
                bl9 = false;
                NativeDistributionLibraries libraries = entry.getValue();
                if (libraries.getPlatformLibs().isEmpty()) continue;
                NativeDistributionModulesProvider provider = new NativeDistributionModulesProvider((StorageManager)new LockBasedStorageManager("Target " + target), libraries);
                $this$apply.addTarget(new TargetProvider((InputTarget)target, KonanBuiltIns.class, provider, provider));
            }
            Parameters parameters3 = parameters2;
            Result result = FacadeKt.runCommonization(parameters3);
            return result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveModules(Map<InputTarget, NativeDistributionLibraries> originalLibrariesByTargets, Result result) {
        block14: {
            void $this$mapTo$iv$iv;
            Iterable element$iv3;
            Result result2;
            block13: {
                this.copyCommonStandardLibraries();
                result2 = result;
                if (!(result2 instanceof Result.NothingToCommonize)) break block13;
                Map<InputTarget, NativeDistributionLibraries> $this$forEach$iv = originalLibrariesByTargets;
                boolean $i$f$forEach = false;
                Map<InputTarget, NativeDistributionLibraries> map2 = $this$forEach$iv;
                boolean bl = false;
                Iterator<Map.Entry<InputTarget, NativeDistributionLibraries>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void target;
                    Map.Entry<InputTarget, NativeDistributionLibraries> element$iv2;
                    Map.Entry<InputTarget, NativeDistributionLibraries> $dstr$target$libraries = element$iv2 = iterator.next();
                    boolean bl2 = false;
                    Map.Entry<InputTarget, NativeDistributionLibraries> entry = $dstr$target$libraries;
                    boolean bl3 = false;
                    InputTarget inputTarget = entry.getKey();
                    entry = $dstr$target$libraries;
                    bl3 = false;
                    NativeDistributionLibraries libraries = entry.getValue();
                    this.copyTargetAsIs((InputTarget)target, libraries.getPlatformLibs().size());
                }
                break block14;
            }
            if (!(result2 instanceof Result.Commonized)) break block14;
            boolean $i$f$forEach = false;
            boolean bl = false;
            Project project = null;
            boolean bl4 = false;
            KlibMetadataMonolithicSerializer serializer = new KlibMetadataMonolithicSerializer((LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT, (BinaryVersion)KlibMetadataVersion.INSTANCE, project, bl4, bl, $i$f$forEach, 48, null);
            Set targetsToCopy = SetsKt.minus(originalLibrariesByTargets.keySet(), (Iterable)((Result.Commonized)result).getLeafTargets());
            Collection collection = targetsToCopy;
            boolean bl5 = false;
            if (!collection.isEmpty()) {
                Iterable $this$forEach$iv = targetsToCopy;
                boolean $i$f$forEach2 = false;
                for (Iterable element$iv3 : $this$forEach$iv) {
                    InputTarget target = (InputTarget)((Object)element$iv3);
                    boolean bl6 = false;
                    NativeDistributionLibraries libraries = (NativeDistributionLibraries)MapsKt.getValue(originalLibrariesByTargets, (Object)target);
                    this.copyTargetAsIs(target, libraries.getPlatformLibs().size());
                }
            }
            Iterable $this$map$iv = ((Result.Commonized)result).getLeafTargets();
            boolean $i$f$map = false;
            element$iv3 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InputTarget target = (InputTarget)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl7 = false;
                String string = it.getName();
                collection2.add(string);
            }
            List leafTargetNames = (List)destination$iv$iv;
            Set targetsToSerialize = SetsKt.plus(((Result.Commonized)result).getLeafTargets(), (Object)((Result.Commonized)result).getSharedTarget());
            Iterable $this$forEach$iv = targetsToSerialize;
            boolean $i$f$forEach3 = false;
            for (Object element$iv4 : $this$forEach$iv) {
                Target $this$mapNotNullTo$iv$iv;
                boolean bl8;
                void $this$mapNotNullTo$iv$iv2;
                Target target = (Target)element$iv4;
                boolean bl9 = false;
                Collection moduleResults = (Collection)MapsKt.getValue(((Result.Commonized)result).getModulesByTargets(), (Object)target);
                Iterable $this$mapNotNull$iv = moduleResults;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Iterable<ModuleDescriptor> destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach4 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ModuleDescriptor moduleDescriptor;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl10 = false;
                    ModuleResult it = (ModuleResult)element$iv$iv;
                    boolean bl11 = false;
                    ModuleResult moduleResult = it;
                    if (!(moduleResult instanceof ModuleResult.Commonized)) {
                        moduleResult = null;
                    }
                    ModuleResult.Commonized commonized = (ModuleResult.Commonized)moduleResult;
                    if ((commonized != null ? commonized.getModule() : null) == null) continue;
                    moduleDescriptor = moduleDescriptor;
                    boolean bl12 = false;
                    bl8 = false;
                    ModuleDescriptor it$iv$iv = moduleDescriptor;
                    boolean bl13 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Collection newModules = (List)destination$iv$iv2;
                Iterable $this$mapNotNull$iv2 = moduleResults;
                boolean $i$f$mapNotNull2 = false;
                destination$iv$iv2 = $this$mapNotNull$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach5 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
                while (iterator2.hasNext()) {
                    java.io.File file;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl14 = false;
                    ModuleResult it = (ModuleResult)element$iv$iv;
                    boolean bl15 = false;
                    ModuleResult moduleResult = it;
                    if (!(moduleResult instanceof ModuleResult.Absent)) {
                        moduleResult = null;
                    }
                    ModuleResult.Absent absent = (ModuleResult.Absent)moduleResult;
                    if ((absent != null ? absent.getOriginalLocation() : null) == null) continue;
                    file = file;
                    bl8 = false;
                    boolean bl16 = false;
                    java.io.File it$iv$iv = file;
                    boolean bl17 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                List absentModuleLocations = (List)destination$iv$iv3;
                NativeManifestDataProvider manifestProvider = null;
                String starredTarget = null;
                $this$mapNotNullTo$iv$iv = target;
                if ($this$mapNotNullTo$iv$iv instanceof InputTarget) {
                    manifestProvider = (NativeManifestDataProvider)MapsKt.getValue(originalLibrariesByTargets, (Object)target);
                    starredTarget = ((InputTarget)target).getName();
                } else if ($this$mapNotNullTo$iv$iv instanceof OutputTarget) {
                    manifestProvider = new CommonNativeManifestDataProvider(originalLibrariesByTargets.values());
                    starredTarget = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String targetName2 = CollectionsKt.joinToString$default((Iterable)leafTargetNames, null, null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(starredTarget){
                    final /* synthetic */ String $starredTarget;

                    @NotNull
                    public final CharSequence invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it, (Object)this.$starredTarget) ? (CharSequence)(it + "(*)") : (CharSequence)it;
                    }
                    {
                        this.$starredTarget = string;
                        super(1);
                    }
                }), (int)31, null);
                this.serializeTarget(target, targetName2, newModules, absentModuleLocations, manifestProvider, serializer);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void copyCommonStandardLibraries() {
        if (this.copyStdlib || this.copyEndorsedLibs) {
            Object[] objectArray;
            java.io.File[] fileArray = FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)this.repository, (String)"klib"), (String)"common").listFiles();
            if (fileArray != null) {
                java.io.File dir;
                Collection destination$iv$iv;
                boolean $i$f$filter;
                Iterable $this$filter$iv;
                Object object;
                void $this$filterTo$iv$iv;
                Object $this$filter$iv2 = fileArray;
                boolean $i$f$filter2 = false;
                java.io.File[] fileArray2 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                void var6_13 = $this$filterTo$iv$iv;
                int n = ((void)var6_13).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = var6_13[i];
                    boolean bl = false;
                    void v1 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                    if (!v1.isDirectory()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv2;
                $i$f$filter2 = false;
                boolean bl = false;
                Object it = $this$filter$iv2;
                boolean bl2 = false;
                if (this.copyStdlib) {
                    if (this.copyEndorsedLibs) {
                        object = it;
                    } else {
                        void $this$filterTo$iv$iv2;
                        $this$filter$iv = (Iterable)it;
                        $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo2 = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                            dir = (java.io.File)element$iv$iv;
                            boolean bl3 = false;
                            java.io.File file = dir;
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dir");
                            if (!FilesKt.endsWith((java.io.File)file, (String)"stdlib")) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        object = (List)destination$iv$iv;
                    }
                } else {
                    $this$filter$iv = (Iterable)it;
                    $i$f$filter = false;
                    Iterable $this$filterTo$iv$iv2 = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo3 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        dir = (java.io.File)element$iv$iv;
                        boolean bl4 = false;
                        java.io.File file = dir;
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dir");
                        if (!(!FilesKt.endsWith((java.io.File)file, (String)"stdlib"))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    object = (List)destination$iv$iv;
                }
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    java.io.File libraryOrigin = (java.io.File)element$iv;
                    boolean bl5 = false;
                    java.io.File file = FilesKt.resolve((java.io.File)this.destination, (String)"common");
                    java.io.File file2 = libraryOrigin;
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"libraryOrigin");
                    String string = file2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"libraryOrigin.name");
                    java.io.File libraryDestination = FilesKt.resolve((java.io.File)file, (String)string);
                    FilesKt.copyRecursively$default((java.io.File)libraryOrigin, (java.io.File)libraryDestination, (boolean)false, null, (int)6, null);
                }
            }
            String string = "standard library";
            boolean bl = false;
            boolean bl6 = false;
            String libraryOrigin = string;
            int n = 0;
            Object[] objectArray2 = objectArray = new String[2];
            boolean bl7 = false;
            boolean bl8 = this.copyStdlib;
            objectArray[n] = bl8 ? string : null;
            string = "endorsed libraries";
            bl = false;
            bl6 = false;
            String it = string;
            n = 1;
            objectArray = objectArray2;
            boolean bl9 = false;
            bl8 = this.copyEndorsedLibs;
            objectArray[n] = bl8 ? string : null;
            String what = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2), (CharSequence)" and ", null, null, (int)0, null, null, (int)62, null);
            this.logProgress("Copied " + what);
        }
    }

    private final void copyTargetAsIs(InputTarget leafTarget, int librariesCount) {
        java.io.File librariesDestination = this.getLibrariesDestination(leafTarget);
        librariesDestination.mkdirs();
        java.io.File librariesSource = this.getPlatformLibrariesSource(leafTarget);
        if (librariesSource.isDirectory()) {
            FilesKt.copyRecursively$default((java.io.File)librariesSource, (java.io.File)librariesDestination, (boolean)false, null, (int)6, null);
        }
        this.logProgress("Copied " + librariesCount + " libraries for [" + leafTarget.getName() + ']');
    }

    private final void serializeTarget(Target target, String targetName2, Collection<? extends ModuleDescriptor> newModules, List<? extends java.io.File> absentModuleLocations, NativeManifestDataProvider manifestProvider, KlibMetadataMonolithicSerializer serializer) {
        Object libraryName;
        java.io.File librariesDestination = this.getLibrariesDestination(target);
        librariesDestination.mkdirs();
        for (ModuleDescriptor moduleDescriptor : newModules) {
            Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor.getName(), (String)"newModule.name");
            if (!Companion.shouldBeSerialized((Name)libraryName)) continue;
            SerializedMetadata metadata = serializer.serializeModule(moduleDescriptor);
            String string = libraryName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"libraryName.asString()");
            String plainName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"<"), (CharSequence)">");
            NativeSensitiveManifestData manifestData = manifestProvider.getManifest(plainName);
            java.io.File libraryDestination = FilesKt.resolve((java.io.File)librariesDestination, (String)plainName);
            this.writeLibrary(metadata, manifestData, libraryDestination);
        }
        for (java.io.File file : absentModuleLocations) {
            Object object = libraryName = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"libraryName");
            FilesKt.copyRecursively$default((java.io.File)file, (java.io.File)FilesKt.resolve((java.io.File)librariesDestination, (String)object), (boolean)false, null, (int)6, null);
        }
        this.logProgress("Written libraries for [" + targetName2 + ']');
    }

    private final void writeLibrary(SerializedMetadata metadata, NativeSensitiveManifestData manifestData, java.io.File destination) {
        String string = destination.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destination.path");
        KotlinLibraryWriterImpl library = new KotlinLibraryWriterImpl(new File(string), manifestData.getUniqueName(), manifestData.getVersions(), BuiltInsPlatform.NATIVE, CollectionsKt.emptyList(), true, manifestData.getShortName(), null, null, null, null, 1920, null);
        library.addMetadata(metadata);
        BaseWriter baseWriter = library.getBase();
        if (baseWriter == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.library.impl.BaseWriterImpl");
        }
        manifestData.applyTo((BaseWriterImpl)baseWriter);
        library.commit();
    }

    private final java.io.File getPlatformLibrariesSource(InputTarget $this$platformLibrariesSource) {
        return FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)this.repository, (String)"klib"), (String)"platform"), (String)$this$platformLibrariesSource.getName());
    }

    private final java.io.File getLibrariesDestination(Target $this$librariesDestination) {
        java.io.File file;
        Target target = $this$librariesDestination;
        if (target instanceof InputTarget) {
            file = FilesKt.resolve((java.io.File)FilesKt.resolve((java.io.File)this.destination, (String)"platform"), (String)((InputTarget)$this$librariesDestination).getName());
        } else if (target instanceof OutputTarget) {
            file = FilesKt.resolve((java.io.File)this.destination, (String)"common");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return file;
    }

    public NativeDistributionCommonizer(@NotNull java.io.File repository, @NotNull List<? extends KonanTarget> targets, @NotNull java.io.File destination, boolean copyStdlib, boolean copyEndorsedLibs, @NotNull StatsType statsType, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)((Object)statsType), (String)"statsType");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.repository = repository;
        this.targets = targets;
        this.destination = destination;
        this.copyStdlib = copyStdlib;
        this.copyEndorsedLibs = copyEndorsedLibs;
        this.statsType = statsType;
        this.logger = logger;
        this.clockMark = new ResettableClockMark();
    }

    public static final /* synthetic */ void access$logProgress(NativeDistributionCommonizer $this, String message) {
        $this.logProgress(message);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$StatsType;", "", "(Ljava/lang/String;I)V", "RAW", "AGGREGATED", "NONE", "kotlin-klib-commonizer"})
    public static final class StatsType
    extends Enum<StatsType> {
        public static final /* enum */ StatsType RAW;
        public static final /* enum */ StatsType AGGREGATED;
        public static final /* enum */ StatsType NONE;
        private static final /* synthetic */ StatsType[] $VALUES;

        static {
            StatsType[] statsTypeArray = new StatsType[3];
            StatsType[] statsTypeArray2 = statsTypeArray;
            statsTypeArray[0] = RAW = new StatsType();
            statsTypeArray[1] = AGGREGATED = new StatsType();
            statsTypeArray[2] = NONE = new StatsType();
            $VALUES = statsTypeArray;
        }

        public static StatsType[] values() {
            return (StatsType[])$VALUES.clone();
        }

        public static StatsType valueOf(String string) {
            return Enum.valueOf(StatsType.class, string);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/konan/NativeDistributionCommonizer$Companion;", "", "()V", "shouldBeSerialized", "", "libraryName", "Lorg/jetbrains/kotlin/name/Name;", "kotlin-klib-commonizer"})
    private static final class Companion {
        public final boolean shouldBeSerialized(@NotNull Name libraryName) {
            Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
            return Intrinsics.areEqual((Object)libraryName, (Object)UtilsKt.getNATIVE_STDLIB_MODULE_NAME()) ^ true && Intrinsics.areEqual((Object)libraryName, (Object)KlibResolvedModuleDescriptorsFactoryImpl.Companion.getFORWARD_DECLARATIONS_MODULE_NAME()) ^ true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

