/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.cir.factory;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirClassifierId;
import org.jetbrains.kotlin.descriptors.commonizer.cir.factory.CirClassifierIdFactoryKt;
import org.jetbrains.kotlin.descriptors.commonizer.utils.Interner;
import org.jetbrains.kotlin.descriptors.commonizer.utils.TypeKt;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/cir/factory/CirClassifierIdFactory;", "", "()V", "interner", "Lorg/jetbrains/kotlin/descriptors/commonizer/utils/Interner;", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirClassifierId;", "create", "source", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "createForClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "createForTypeAlias", "createForTypeParameter", "index", "", "kotlin-klib-commonizer"})
public final class CirClassifierIdFactory {
    private static final Interner<CirClassifierId> interner;
    @NotNull
    public static final CirClassifierIdFactory INSTANCE;

    @NotNull
    public final CirClassifierId create(@NotNull ClassifierDescriptor source) {
        CirClassifierId cirClassifierId;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ClassifierDescriptor classifierDescriptor = source;
        if (classifierDescriptor instanceof ClassDescriptor) {
            cirClassifierId = this.createForClass(TypeKt.getInternedClassId((ClassifierDescriptorWithTypeParameters)source));
        } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
            cirClassifierId = this.createForTypeAlias(TypeKt.getInternedClassId((ClassifierDescriptorWithTypeParameters)source));
        } else if (classifierDescriptor instanceof TypeParameterDescriptor) {
            cirClassifierId = this.createForTypeParameter(CirClassifierIdFactoryKt.access$getTypeParameterIndex$p((TypeParameterDescriptor)source));
        } else {
            String string = "Unexpected classifier descriptor type: " + source.getClass() + ", " + this;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return cirClassifierId;
    }

    @NotNull
    public final CirClassifierId createForClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return interner.intern(new CirClassifierId.Class(classId));
    }

    @NotNull
    public final CirClassifierId createForTypeAlias(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return interner.intern(new CirClassifierId.TypeAlias(classId));
    }

    @NotNull
    public final CirClassifierId createForTypeParameter(int index) {
        return interner.intern(new CirClassifierId.TypeParameter(index));
    }

    private CirClassifierIdFactory() {
    }

    static {
        CirClassifierIdFactory cirClassifierIdFactory;
        INSTANCE = cirClassifierIdFactory = new CirClassifierIdFactory();
        interner = new Interner();
    }
}

