/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.core;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirClassifierId;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirFlexibleType;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirSimpleType;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirType;
import org.jetbrains.kotlin.descriptors.commonizer.cir.CirTypeProjection;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirClassifiersCache;
import org.jetbrains.kotlin.descriptors.commonizer.mergedtree.CirNode;
import org.jetbrains.kotlin.descriptors.commonizer.utils.FqNameKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\bH\u0000\u001a\u0017\u0010\t\u001a\u00020\u0001*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\nH\u0082\b\u00a8\u0006\u000b"}, d2={"areSimpleTypesEqual", "", "cache", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirClassifiersCache;", "a", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirSimpleType;", "b", "areTypesEqual", "Lorg/jetbrains/kotlin/descriptors/commonizer/cir/CirType;", "canBeCommonized", "Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/CirNode;", "kotlin-klib-commonizer"})
public final class TypeCommonizerKt {
    public static final boolean areTypesEqual(@NotNull CirClassifiersCache cache, @NotNull CirType a, @NotNull CirType b) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a instanceof CirSimpleType ? b instanceof CirSimpleType && TypeCommonizerKt.areSimpleTypesEqual(cache, (CirSimpleType)a, (CirSimpleType)b) : (a instanceof CirFlexibleType ? b instanceof CirFlexibleType && TypeCommonizerKt.areSimpleTypesEqual(cache, ((CirFlexibleType)a).getLowerBound(), ((CirFlexibleType)b).getLowerBound()) && TypeCommonizerKt.areSimpleTypesEqual(cache, ((CirFlexibleType)a).getUpperBound(), ((CirFlexibleType)b).getUpperBound()) : false);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean areSimpleTypesEqual(CirClassifiersCache cache, CirSimpleType a, CirSimpleType b) {
        boolean descriptorsCanBeCommonized;
        CirClassifierId aId = a.getClassifierId();
        CirClassifierId bId = b.getClassifierId();
        if (a != b) {
            if (a.getArguments().size() != b.getArguments().size() || a.isMarkedNullable() != b.isMarkedNullable()) {
                return false;
            }
            if (aId instanceof CirClassifierId.ClassOrTypeAlias && (!(bId instanceof CirClassifierId.ClassOrTypeAlias) || Intrinsics.areEqual((Object)((CirClassifierId.ClassOrTypeAlias)((Object)aId)).getClassId(), (Object)((CirClassifierId.ClassOrTypeAlias)((Object)bId)).getClassId()) ^ true)) {
                return false;
            }
            if (aId instanceof CirClassifierId.TypeParameter && (!(bId instanceof CirClassifierId.TypeParameter) || ((CirClassifierId.TypeParameter)aId).getIndex() != ((CirClassifierId.TypeParameter)bId).getIndex())) {
                return false;
            }
        }
        Function0<Boolean> $fun$isClassOrTypeAliasUnderStandardKotlinPackages$1 = new Function0<Boolean>(aId){
            final /* synthetic */ CirClassifierId $aId;

            public final boolean invoke() {
                CirClassifierId.ClassOrTypeAlias classOrTypeAlias;
                CirClassifierId cirClassifierId = this.$aId;
                if (!(cirClassifierId instanceof CirClassifierId.ClassOrTypeAlias)) {
                    cirClassifierId = null;
                }
                return (classOrTypeAlias = (CirClassifierId.ClassOrTypeAlias)((Object)cirClassifierId)) != null && (classOrTypeAlias = classOrTypeAlias.getClassId()) != null && (classOrTypeAlias = classOrTypeAlias.getPackageFqName()) != null && FqNameKt.isUnderStandardKotlinPackages((FqName)classOrTypeAlias);
            }
            {
                this.$aId = cirClassifierId;
                super(0);
            }
        };
        Function0<Boolean> $fun$descriptorsCanBeCommonizedThemselves$2 = new Function0<Boolean>(aId, bId, cache){
            final /* synthetic */ CirClassifierId $aId;
            final /* synthetic */ CirClassifierId $bId;
            final /* synthetic */ CirClassifiersCache $cache;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke() {
                CirClassifierId cirClassifierId = this.$aId;
                if (cirClassifierId instanceof CirClassifierId.Class) {
                    if (!(this.$bId instanceof CirClassifierId.Class)) return false;
                    CirNode $this$canBeCommonized$iv = this.$cache.getClasses().get(((CirClassifierId.Class)this.$aId).getClassId());
                    boolean $i$f$canBeCommonized = false;
                    if ($this$canBeCommonized$iv == null) {
                        return true;
                    }
                    if ($this$canBeCommonized$iv.getCommonDeclaration().invoke() == null) return false;
                    return true;
                }
                if (cirClassifierId instanceof CirClassifierId.TypeAlias) {
                    if (!(this.$bId instanceof CirClassifierId.TypeAlias)) return false;
                    CirNode $this$canBeCommonized$iv = this.$cache.getTypeAliases().get(((CirClassifierId.TypeAlias)this.$aId).getClassId());
                    boolean $i$f$canBeCommonized = false;
                    if ($this$canBeCommonized$iv == null) {
                        return true;
                    }
                    if ($this$canBeCommonized$iv.getCommonDeclaration().invoke() == null) return false;
                    return true;
                }
                if (!(cirClassifierId instanceof CirClassifierId.TypeParameter)) throw new NoWhenBranchMatchedException();
                return true;
            }
            {
                this.$aId = cirClassifierId;
                this.$bId = cirClassifierId2;
                this.$cache = cirClassifiersCache;
                super(0);
            }
        };
        boolean bl = descriptorsCanBeCommonized = $fun$isClassOrTypeAliasUnderStandardKotlinPackages$1.invoke() || $fun$descriptorsCanBeCommonizedThemselves$2.invoke();
        if (!descriptorsCanBeCommonized) {
            return false;
        }
        int n = 0;
        int n2 = ((Collection)a.getArguments()).size();
        while (n < n2) {
            void i;
            CirTypeProjection aArg = a.getArguments().get((int)i);
            CirTypeProjection bArg = b.getArguments().get((int)i);
            if (aArg.isStarProjection() != bArg.isStarProjection()) {
                return false;
            }
            if (!aArg.isStarProjection()) {
                if (aArg.getProjectionKind() != bArg.getProjectionKind()) {
                    return false;
                }
                if (!TypeCommonizerKt.areTypesEqual(cache, aArg.getType(), bArg.getType())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static final boolean canBeCommonized(CirNode<?, ?> $this$canBeCommonized) {
        int $i$f$canBeCommonized = 0;
        return $this$canBeCommonized == null ? true : $this$canBeCommonized.getCommonDeclaration().invoke() != null;
    }

    public static final /* synthetic */ boolean access$canBeCommonized(CirNode $this$access_u24canBeCommonized) {
        return TypeCommonizerKt.canBeCommonized($this$access_u24canBeCommonized);
    }
}

