/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.builder;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.Target;
import org.jetbrains.kotlin.descriptors.commonizer.builder.DeclarationsBuilderCache;
import org.jetbrains.kotlin.descriptors.commonizer.utils.FqNameKt;
import org.jetbrains.kotlin.descriptors.commonizer.utils.ModuleDescriptorKt;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001a\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0012\u0010'\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0018R%\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/builder/TargetDeclarationsBuilderComponents;", "", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "target", "Lorg/jetbrains/kotlin/descriptors/commonizer/Target;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "lazyModulesLookupTable", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "isCommon", "", "index", "", "cache", "Lorg/jetbrains/kotlin/descriptors/commonizer/builder/DeclarationsBuilderCache;", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lorg/jetbrains/kotlin/descriptors/commonizer/Target;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/storage/NotNullLazyValue;ZILorg/jetbrains/kotlin/descriptors/commonizer/builder/DeclarationsBuilderCache;)V", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "extendedLookupForBuiltInsClassifiers", "getExtendedLookupForBuiltInsClassifiers$kotlin_klib_commonizer", "()Z", "setExtendedLookupForBuiltInsClassifiers$kotlin_klib_commonizer", "(Z)V", "getIndex", "()I", "getLazyModulesLookupTable", "()Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "getStorageManager", "()Lorg/jetbrains/kotlin/storage/StorageManager;", "getTarget", "()Lorg/jetbrains/kotlin/descriptors/commonizer/Target;", "findClassOrTypeAlias", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findOriginalClassOrTypeAlias", "kotlin-klib-commonizer"})
public final class TargetDeclarationsBuilderComponents {
    private boolean extendedLookupForBuiltInsClassifiers;
    private final StorageManager storageManager;
    private final Target target;
    private final KotlinBuiltIns builtIns;
    private final NotNullLazyValue<Map<String, ModuleDescriptor>> lazyModulesLookupTable;
    private final boolean isCommon;
    private final int index;
    private final DeclarationsBuilderCache cache;

    public final boolean getExtendedLookupForBuiltInsClassifiers$kotlin_klib_commonizer() {
        return this.extendedLookupForBuiltInsClassifiers;
    }

    public final void setExtendedLookupForBuiltInsClassifiers$kotlin_klib_commonizer(boolean bl) {
        this.extendedLookupForBuiltInsClassifiers = bl;
    }

    @NotNull
    public final ClassifierDescriptorWithTypeParameters findClassOrTypeAlias(@NotNull ClassId classId) {
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FqName fqName = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"classId.packageFqName");
        if (FqNameKt.isUnderStandardKotlinPackages(fqName)) {
            ModuleDescriptorImpl moduleDescriptorImpl = this.builtIns.getBuiltInsModule();
            Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptorImpl, (String)"builtIns.builtInsModule");
            ModuleDescriptorImpl builtInsModule = moduleDescriptorImpl;
            ClassifierDescriptorWithTypeParameters classifier = ModuleDescriptorKt.resolveClassOrTypeAlias((ModuleDescriptor)builtInsModule, classId);
            if (classifier != null) {
                return classifier;
            }
            if (this.extendedLookupForBuiltInsClassifiers) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters2 = this.findOriginalClassOrTypeAlias(classId);
                if (classifierDescriptorWithTypeParameters2 == null) {
                    String string = "Classifier " + classId.asString() + " not found neither in built-ins module " + builtInsModule + " nor in original modules for " + this.target;
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return classifierDescriptorWithTypeParameters2;
            }
            String string = "Classifier " + classId.asString() + " not found in built-ins module " + builtInsModule + " for " + this.target;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
        if (FqNameKt.isUnderKotlinNativeSyntheticPackages(fqName2)) {
            classifierDescriptorWithTypeParameters = ModuleDescriptorKt.resolveClassOrTypeAlias((ModuleDescriptor)this.cache.getOrPutForwardDeclarationsModule(this.index, (Function0<ModuleDescriptorImpl>)((Function0)new Function0<ModuleDescriptorImpl>(this){
                final /* synthetic */ TargetDeclarationsBuilderComponents this$0;

                @NotNull
                public final ModuleDescriptorImpl invoke() {
                    return ModuleDescriptorKt.createKotlinNativeForwardDeclarationsModule(this.this$0.getStorageManager(), this.this$0.getBuiltIns());
                }
                {
                    this.this$0 = targetDeclarationsBuilderComponents;
                    super(0);
                }
            })), classId);
            if (classifierDescriptorWithTypeParameters == null) {
                String string = "Classifier " + classId.asString() + " not found for " + this.target;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        } else {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters3 = this.cache.getCachedClassifier(classId, this.index);
            if (classifierDescriptorWithTypeParameters3 == null) {
                classifierDescriptorWithTypeParameters3 = classifierDescriptorWithTypeParameters = this.findOriginalClassOrTypeAlias(classId);
            }
            if (classifierDescriptorWithTypeParameters3 == null) {
                String string = "Classifier " + classId.asString() + " not found for " + this.target;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
        return classifierDescriptorWithTypeParameters;
    }

    private final ClassifierDescriptorWithTypeParameters findOriginalClassOrTypeAlias(ClassId classId) {
        FqName fqName = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"classId.packageFqName");
        if (fqName.isRoot()) {
            return null;
        }
        Map map2 = (Map)this.lazyModulesLookupTable.invoke();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
        ModuleDescriptor moduleDescriptor = ModuleDescriptorKt.guessModuleByPackageFqName(map2, fqName2);
        Object classifier = moduleDescriptor != null ? ModuleDescriptorKt.resolveClassOrTypeAlias(moduleDescriptor, classId) : null;
        ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = classifier;
        if (classifierDescriptorWithTypeParameters == null) {
            classifierDescriptorWithTypeParameters = (ClassifierDescriptorWithTypeParameters)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Map)this.lazyModulesLookupTable.invoke()).values()), (Function1)((Function1)new Function1<ModuleDescriptor, ClassifierDescriptorWithTypeParameters>(classId){
                final /* synthetic */ ClassId $classId;

                @Nullable
                public final ClassifierDescriptorWithTypeParameters invoke(@Nullable ModuleDescriptor it) {
                    ModuleDescriptor moduleDescriptor = it;
                    return moduleDescriptor != null ? ModuleDescriptorKt.resolveClassOrTypeAlias(moduleDescriptor, this.$classId) : null;
                }
                {
                    this.$classId = classId;
                    super(1);
                }
            })));
        }
        return classifierDescriptorWithTypeParameters;
    }

    @NotNull
    public final StorageManager getStorageManager() {
        return this.storageManager;
    }

    @NotNull
    public final Target getTarget() {
        return this.target;
    }

    @NotNull
    public final KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final NotNullLazyValue<Map<String, ModuleDescriptor>> getLazyModulesLookupTable() {
        return this.lazyModulesLookupTable;
    }

    public final boolean isCommon() {
        return this.isCommon;
    }

    public final int getIndex() {
        return this.index;
    }

    public TargetDeclarationsBuilderComponents(@NotNull StorageManager storageManager, @NotNull Target target, @NotNull KotlinBuiltIns builtIns, @NotNull NotNullLazyValue<? extends Map<String, ModuleDescriptor>> lazyModulesLookupTable, boolean isCommon, int index, @NotNull DeclarationsBuilderCache cache) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter(lazyModulesLookupTable, (String)"lazyModulesLookupTable");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this.storageManager = storageManager;
        this.target = target;
        this.builtIns = builtIns;
        this.lazyModulesLookupTable = lazyModulesLookupTable;
        this.isCommon = isCommon;
        this.index = index;
        this.cache = cache;
    }
}

