/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.descriptors.commonizer.mergedtree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.commonizer.utils.InternersKt;
import org.jetbrains.kotlin.descriptors.commonizer.utils.TypeKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B1\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\u001b\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\bH\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\nH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u001a\b\u0002\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\nH\u00d6\u0001R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/descriptors/commonizer/mergedtree/FunctionApproximationKey;", "", "function", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;)V", "name", "Lorg/jetbrains/kotlin/name/Name;", "valueParameters", "", "Lkotlin/Pair;", "", "extensionReceiverParameter", "(Lorg/jetbrains/kotlin/name/Name;Ljava/util/List;Ljava/lang/String;)V", "getExtensionReceiverParameter", "()Ljava/lang/String;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getValueParameters", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin-klib-commonizer"})
public final class FunctionApproximationKey {
    @NotNull
    private final Name name;
    @NotNull
    private final List<Pair<Name, String>> valueParameters;
    @Nullable
    private final String extensionReceiverParameter;

    @NotNull
    public final Name getName() {
        return this.name;
    }

    @NotNull
    public final List<Pair<Name, String>> getValueParameters() {
        return this.valueParameters;
    }

    @Nullable
    public final String getExtensionReceiverParameter() {
        return this.extensionReceiverParameter;
    }

    public FunctionApproximationKey(@NotNull Name name, @NotNull List<Pair<Name, String>> valueParameters, @Nullable String extensionReceiverParameter) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(valueParameters, (String)"valueParameters");
        this.name = name;
        this.valueParameters = valueParameters;
        this.extensionReceiverParameter = extensionReceiverParameter;
    }

    /*
     * WARNING - void declaration
     */
    public FunctionApproximationKey(@NotNull SimpleFunctionDescriptor function) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Name name = function.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"function.name");
        Name name2 = InternersKt.intern(name);
        List list = function.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"function.valueParameters");
        Iterable iterable = list;
        Name name3 = name2;
        FunctionApproximationKey functionApproximationKey = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            Name name4 = v3.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"it.name");
            Name name5 = InternersKt.intern(name4);
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
            Pair pair = TuplesKt.to((Object)name5, (Object)TypeKt.getFqNameWithTypeParameters(kotlinType));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        ReceiverParameterDescriptor receiverParameterDescriptor = function.getExtensionReceiverParameter();
        functionApproximationKey(name3, (List<Pair<Name, String>>)collection, receiverParameterDescriptor != null && (receiverParameterDescriptor = receiverParameterDescriptor.getType()) != null ? TypeKt.getFqNameWithTypeParameters((KotlinType)receiverParameterDescriptor) : null);
    }

    @NotNull
    public final Name component1() {
        return this.name;
    }

    @NotNull
    public final List<Pair<Name, String>> component2() {
        return this.valueParameters;
    }

    @Nullable
    public final String component3() {
        return this.extensionReceiverParameter;
    }

    @NotNull
    public final FunctionApproximationKey copy(@NotNull Name name, @NotNull List<Pair<Name, String>> valueParameters, @Nullable String extensionReceiverParameter) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(valueParameters, (String)"valueParameters");
        return new FunctionApproximationKey(name, valueParameters, extensionReceiverParameter);
    }

    public static /* synthetic */ FunctionApproximationKey copy$default(FunctionApproximationKey functionApproximationKey, Name name, List list, String string, int n, Object object) {
        if ((n & 1) != 0) {
            name = functionApproximationKey.name;
        }
        if ((n & 2) != 0) {
            list = functionApproximationKey.valueParameters;
        }
        if ((n & 4) != 0) {
            string = functionApproximationKey.extensionReceiverParameter;
        }
        return functionApproximationKey.copy(name, list, string);
    }

    @NotNull
    public String toString() {
        return "FunctionApproximationKey(name=" + this.name + ", valueParameters=" + this.valueParameters + ", extensionReceiverParameter=" + this.extensionReceiverParameter + ")";
    }

    public int hashCode() {
        Name name = this.name;
        List<Pair<Name, String>> list = this.valueParameters;
        String string = this.extensionReceiverParameter;
        return ((name != null ? name.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FunctionApproximationKey)) break block3;
                FunctionApproximationKey functionApproximationKey = (FunctionApproximationKey)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)functionApproximationKey.name) || !Intrinsics.areEqual(this.valueParameters, functionApproximationKey.valueParameters) || !Intrinsics.areEqual((Object)this.extensionReceiverParameter, (Object)functionApproximationKey.extensionReceiverParameter)) break block3;
            }
            return true;
        }
        return false;
    }
}

