/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build.report.metrics;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildAttributes;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.BuildTimes;
import org.jetbrains.kotlin.build.report.metrics.DynamicBuildTimeKey;
import org.jetbrains.kotlin.build.report.metrics.GcMetric;
import org.jetbrains.kotlin.build.report.metrics.GcMetrics;
import org.jetbrains.kotlin.build.report.metrics.ValueType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00052\u00020\u0006B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u001d\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010#J%\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010%\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010&J\u001d\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00028\u00012\u0006\u0010\u001f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020\u00192\u0006\u0010(\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010+J\u0018\u0010,\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0016J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000101H\u0016J\u001c\u00102\u001a\u00020\u00192\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000101H\u0016R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\nj\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\nj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterImpl;", "B", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;", "P", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Ljava/io/Serializable;", "<init>", "()V", "myBuildTimeStartNs", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "myGcPerformance", "", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetric;", "myBuildTimes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildTimes;", "myBuildMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetrics;", "myBuildAttributes", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttributes;", "myGcMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetrics;", "startMeasure", "", "time", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;)V", "endMeasure", "startGcMetric", "name", "value", "endGcMetric", "addTimeMetricNs", "durationNs", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;J)V", "addDynamicTimeMetricNs", "parent", "(Ljava/lang/String;Lorg/jetbrains/kotlin/build/report/metrics/BuildTime;J)V", "addMetric", "metric", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;J)V", "addTimeMetric", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildPerformanceMetric;)V", "addGcMetric", "addAttribute", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "getMetrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addMetrics", "metrics", "kotlin-build-statistics"})
public class BuildMetricsReporterImpl<B extends BuildTime, P extends BuildPerformanceMetric>
implements BuildMetricsReporter<B, P>,
Serializable {
    @NotNull
    private final HashMap<B, Long> myBuildTimeStartNs = new HashMap();
    @NotNull
    private final HashMap<String, GcMetric> myGcPerformance = new HashMap();
    @NotNull
    private final BuildTimes<B> myBuildTimes = new BuildTimes();
    @NotNull
    private final BuildPerformanceMetrics<P> myBuildMetrics = new BuildPerformanceMetrics();
    @NotNull
    private final BuildAttributes myBuildAttributes = new BuildAttributes(null, 1, null);
    @NotNull
    private final GcMetrics myGcMetrics = new GcMetrics();

    @Override
    public void startMeasure(@NotNull B time) {
        Intrinsics.checkNotNullParameter(time, (String)"time");
        if (((Map)this.myBuildTimeStartNs).containsKey(time)) {
            throw new IllegalStateException((time + " was restarted before it finished").toString());
        }
        ((Map)this.myBuildTimeStartNs).put(time, System.nanoTime());
    }

    @Override
    public void endMeasure(@NotNull B time) {
        Intrinsics.checkNotNullParameter(time, (String)"time");
        Long l = this.myBuildTimeStartNs.remove(time);
        if (l == null) {
            throw new IllegalStateException((time + " finished before it started").toString());
        }
        long startNs = l;
        long durationNs = System.nanoTime() - startNs;
        this.myBuildTimes.addTimeNs(time, durationNs);
    }

    @Override
    public void startGcMetric(@NotNull String name, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (((Map)this.myGcPerformance).containsKey(name)) {
            throw new IllegalStateException((name + " was restarted before it finished").toString());
        }
        ((Map)this.myGcPerformance).put(name, value2);
    }

    @Override
    public void endGcMetric(@NotNull String name, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        GcMetric gcMetric = this.myGcPerformance.remove(name);
        if (gcMetric == null) {
            throw new IllegalStateException((name + " finished before it started").toString());
        }
        GcMetric startValue = gcMetric;
        GcMetric diff = value2.minus(startValue);
        this.myGcMetrics.add(name, diff);
    }

    @Override
    public void addTimeMetricNs(@NotNull B time, long durationNs) {
        Intrinsics.checkNotNullParameter(time, (String)"time");
        this.myBuildTimes.addTimeNs(time, durationNs);
    }

    @Override
    public void addDynamicTimeMetricNs(@NotNull String time, @NotNull B parent, long durationNs) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        this.myBuildTimes.addDynamicTimeNs(new DynamicBuildTimeKey(time, (BuildTime)parent), durationNs);
    }

    @Override
    public void addMetric(@NotNull P metric, long value2) {
        Intrinsics.checkNotNullParameter(metric, (String)"metric");
        this.myBuildMetrics.addLong(metric, value2);
    }

    @Override
    public void addTimeMetric(@NotNull P metric) {
        Intrinsics.checkNotNullParameter(metric, (String)"metric");
        switch (WhenMappings.$EnumSwitchMapping$0[metric.getType().ordinal()]) {
            case 1: {
                this.myBuildMetrics.addLong(metric, System.nanoTime());
                break;
            }
            case 2: 
            case 3: {
                this.myBuildMetrics.addLong(metric, System.currentTimeMillis());
                break;
            }
            default: {
                throw new IllegalStateException(("Unable to add time metric for '" + (Object)((Object)metric.getType()) + "' type").toString());
            }
        }
    }

    @Override
    public void addGcMetric(@NotNull String metric, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.myGcMetrics.add(metric, value2);
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        BuildAttributes.add$default(this.myBuildAttributes, attribute, 0, 2, null);
    }

    @Override
    @NotNull
    public BuildMetrics<B, P> getMetrics() {
        return new BuildMetrics<B, P>(this.myBuildTimes, this.myBuildMetrics, this.myBuildAttributes, this.myGcMetrics);
    }

    @Override
    public void addMetrics(@NotNull BuildMetrics<B, P> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.myBuildAttributes.addAll(metrics.getBuildAttributes());
        this.myBuildTimes.addAll(metrics.getBuildTimes());
        this.myBuildMetrics.addAll(metrics.getBuildPerformanceMetrics());
        this.myGcMetrics.addAll(metrics.getGcMetrics());
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.NANOSECONDS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.MILLISECONDS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.TIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

