/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import jet.Function1;
import jet.runtime.Intrinsics;
import jet.runtime.typeinfo.JetClass;
import jet.runtime.typeinfo.JetConstructor;
import jet.runtime.typeinfo.JetMethod;
import jet.runtime.typeinfo.JetValueParameter;
import kotlin.KotlinPackage;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.jetbrains.kotlin.gradle.plugin.KSpec;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper$apply$kotlinPluginDependencies$1;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapper$apply$kotlinPluginDependencies$2;
import org.jetbrains.kotlin.gradle.plugin.ParentLastURLClassLoader;

@JetClass(signature="Ljava/lang/Object;Lorg/gradle/api/Plugin<Lorg/gradle/api/Project;>;", flags=16, abiVersion=6)
public class KotlinPluginWrapper
implements Plugin<Project> {
    private final Logger log;

    @JetMethod(flags=17, propertyType="Lorg/gradle/api/logging/Logger;")
    public final Logger getLog() {
        return this.log;
    }

    @JetMethod(returnType="V")
    public void apply(@JetValueParameter(name="project", type="Lorg/gradle/api/Project;") Project project) {
        DependencyHandler dependencyHandler = project.getBuildscript().getDependencies();
        ConfigurationContainer configurationsContainer = project.getBuildscript().getConfigurations();
        this.log.debug("Loading version information");
        Properties props = new Properties();
        String propFileName = "project.properties";
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        InputStream inputStream = classLoader.getResourceAsStream(propFileName);
        boolean bl = true;
        if (inputStream != null) {
            bl = false;
        }
        if (bl) {
            throw (Throwable)new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        Object projectVersion = props.get("project.version");
        this.log.debug("Found project version [" + projectVersion + "]");
        this.log.debug("Creating configuration and dependency");
        String kotlinPluginCoreCoordinates = "org.jetbrains.kotlin:kotlin-gradle-plugin-core:" + projectVersion;
        Dependency dependency = dependencyHandler.create((Object)kotlinPluginCoreCoordinates);
        Configuration configuration = configurationsContainer.detachedConfiguration(new Dependency[]{dependency});
        if (configuration == null) {
            Intrinsics.throwNpe();
        }
        Configuration configuration2 = configuration;
        this.log.debug("Resolving [" + kotlinPluginCoreCoordinates + "]");
        Set set = configuration2.getResolvedConfiguration().getFiles((Spec)new KSpec((Function1)KotlinPluginWrapper$apply$kotlinPluginDependencies$1.instance$));
        if (set == null) {
            Intrinsics.throwNpe();
        }
        List kotlinPluginDependencies2 = KotlinPackage.map((Collection)set, (Function1)((Function1)KotlinPluginWrapper$apply$kotlinPluginDependencies$2.instance$));
        this.log.debug("Resolved files: [" + String.valueOf(kotlinPluginDependencies2) + "]");
        this.log.debug("Load plugin in parent-last URL classloader");
        ParentLastURLClassLoader kotlinPluginClassloader = new ParentLastURLClassLoader(kotlinPluginDependencies2, this.getClass().getClassLoader());
        this.log.debug("Class loader created");
        Class<?> cls = Class.forName("org.jetbrains.kotlin.gradle.plugin.KotlinPlugin", true, kotlinPluginClassloader);
        this.log.debug("Plugin class loaded");
        Object pluginInstance = cls.newInstance();
        this.log.debug("Plugin class instantiated");
        Method applyMethod = cls.getMethod("apply", Project.class);
        this.log.debug("'apply' method found, invoking...");
        applyMethod.invoke(pluginInstance, project);
        this.log.debug("'apply' method invoked successfully");
    }

    @JetConstructor
    public KotlinPluginWrapper() {
        Logger logger = Logging.getLogger(this.getClass());
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        this.log = logger;
    }
}

