/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.gradle.plugin

import org.gradle.api.Plugin
import org.gradle.api.Project

/**
 * @suppress TODO: KT-58858 add documentation
 * Base Kotlin plugin that is responsible for creating basic build services, configurations,
 * and other setup that is common for all Kotlin projects.
 */
interface KotlinBasePlugin : Plugin<Project> {
    /** Gets the current version of the Kotlin Gradle plugin. */
    val pluginVersion: String
}