/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.aggregation.AggregateGroupedDsl;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnReferenceApiKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumnKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.exceptions.DuplicateColumnNamesException;
import org.jetbrains.kotlinx.dataframe.exceptions.UnequalColumnSizesException;
import org.jetbrains.kotlinx.dataframe.impl.ColumnNameGenerator;
import org.jetbrains.kotlinx.dataframe.impl.DataRowImpl;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.AggregatableInternal;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.GroupByReceiverImpl;
import org.jetbrains.kotlinx.dataframe.impl.columns.TransformableColumnSet;
import org.jetbrains.kotlinx.dataframe.io.StringKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0014\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\tH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u00070\u0005H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0005H\u0016J\b\u0010 \u001a\u00020\tH\u0016J\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\u0006\u0010#\u001a\u00020\tH\u0096\u0002JF\u0010$\u001a@\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030&\u00a2\u0006\f\b'\u0012\b\b\u0016\u0012\u0004\b\b((\u0012\b\u0012\u0006\u0012\u0002\b\u00030)0%j\n\u0012\u0002\b\u0003\u0012\u0002\b\u0003`+\u00a2\u0006\u0002\b*H\u0016J^\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\"\"\u0004\b\u0001\u0010-2H\u0010.\u001aD\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000/\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000/\u00a2\u0006\f\b'\u0012\b\b\u0016\u0012\u0004\b\b((\u0012\u0004\u0012\u0002H-0%j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H-`0\u00a2\u0006\u0002\b*H\u0016J\u001c\u00101\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0016\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010#\u001a\u00020\tH\u0016Jf\u00101\u001a\n\u0012\u0004\u0012\u0002H-\u0018\u00010\u0006\"\u0004\b\u0001\u0010-2N\u00102\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000&\u00a2\u0006\f\b'\u0012\b\b\u0016\u0012\u0004\b\b((\u0012\n\u0012\b\u0012\u0004\u0012\u0002H-030%j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H-`4\u00a2\u0006\u0002\b*H\u0016J$\u00101\u001a\n\u0012\u0004\u0012\u0002H-\u0018\u00010\u0006\"\u0004\b\u0001\u0010-2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H-05H\u0016J$\u00101\u001a\n\u0012\u0004\u0012\u0002H-\u0018\u00010\u0006\"\u0004\b\u0001\u0010-2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H-06H\u0016J\u001c\u00101\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\u0006j\u0004\u0018\u0001`\u00072\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0010H\u0016J\u0010\u00109\u001a\u00020\u00182\u0006\u00107\u001a\u000208H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u0006j\u0002`\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/DataFrameImpl;", "T", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/AggregatableInternal;", "cols", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "nrow", "", "<init>", "(Ljava/util/List;I)V", "getNrow", "()I", "columnsMap", "", "", "columns", "getColumns", "()Ljava/util/List;", "rowsCount", "getColumnIndex", "name", "equals", "", "other", "", "hashCode", "toString", "columnNames", "columnTypes", "Lkotlin/reflect/KType;", "columnsCount", "get", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "index", "remainingColumnsSelector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lkotlin/ParameterName;", "it", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "aggregate", "R", "body", "Lorg/jetbrains/kotlinx/dataframe/aggregation/AggregateGroupedDsl;", "Lorg/jetbrains/kotlinx/dataframe/aggregation/AggregateGroupedBody;", "getColumnOrNull", "column", "Lorg/jetbrains/kotlinx/dataframe/columns/SingleColumn;", "Lorg/jetbrains/kotlinx/dataframe/ColumnSelector;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "Lkotlin/reflect/KProperty;", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "containsColumn", "core"})
@SourceDebugExtension(value={"SMAP\nDataFrameImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrameImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/DataFrameImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1755#2,3:172\n1557#2:175\n1628#2,3:176\n1872#2,2:179\n1557#2:181\n1628#2,3:182\n1874#2:185\n1557#2:186\n1628#2,3:187\n1567#2:190\n1598#2,4:191\n1557#2:195\n1628#2,3:196\n1557#2:199\n1628#2,3:200\n1797#2,3:204\n1#3:203\n*S KotlinDebug\n*F\n+ 1 DataFrameImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/DataFrameImpl\n*L\n44#1:172,3\n45#1:175\n45#1:176,3\n50#1:179,2\n56#1:181\n56#1:182,3\n50#1:185\n64#1:186\n64#1:187,3\n65#1:190\n65#1:191,4\n96#1:195\n96#1:196,3\n98#1:199\n98#1:200,3\n142#1:204,3\n*E\n"})
public class DataFrameImpl<T>
implements DataFrame<T>,
AggregatableInternal<T> {
    private final int nrow;
    @NotNull
    private final Map<String, Integer> columnsMap;
    @NotNull
    private final List<DataColumn<?>> columns;

    /*
     * WARNING - void declaration
     */
    public DataFrameImpl(@NotNull List<? extends DataColumn<?>> cols, int nrow) {
        boolean bl;
        Iterable $this$any$iv;
        block17: {
            Intrinsics.checkNotNullParameter(cols, (String)"cols");
            this.nrow = nrow;
            this.columnsMap = new LinkedHashMap();
            $this$any$iv = cols;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DataColumn it = (DataColumn)element$iv;
                    boolean bl2 = false;
                    if (!(BaseColumnKt.getSize(it) != this.nrow)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            Collection<Pair> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$any$iv = cols;
            int n = this.nrow;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataColumn dataColumn = (DataColumn)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(TuplesKt.to((Object)ColumnReferenceApiKt.getName((ColumnReference)it), (Object)BaseColumnKt.getSize((BaseColumn)it)));
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            int n2 = n;
            throw new UnequalColumnSizesException(n2, list);
        }
        boolean hasUnnamedColumns = false;
        Iterable $this$forEachIndexed$iv = cols;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Iterator col;
            int item$iv$iv;
            if ((item$iv$iv = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataColumn it = (DataColumn)item$iv;
            int i = item$iv$iv;
            boolean bl4 = false;
            String name = ColumnReferenceApiKt.getName((ColumnReference)((Object)col));
            if (((CharSequence)name).length() == 0) {
                hasUnnamedColumns = true;
                continue;
            }
            if (this.columnsMap.containsKey(name)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv2 = cols;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it2;
                    DataColumn dataColumn = (DataColumn)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl5 = false;
                    collection.add(ColumnReferenceApiKt.getName((ColumnReference)it2));
                }
                List list = (List)destination$iv$iv;
                throw new DuplicateColumnNamesException(list);
            }
            Integer $i$f$map = i;
            this.columnsMap.put(name, $i$f$map);
        }
        if (hasUnnamedColumns) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = cols;
            boolean $i$f$map = false;
            Iterable $i$f$mapTo = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataColumn bl4 = (DataColumn)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                collection.add(ColumnReferenceApiKt.getName((ColumnReference)it));
            }
            List list = (List)destination$iv$iv;
            ColumnNameGenerator nameGenerator = new ColumnNameGenerator(list);
            $this$map$iv = cols;
            DataFrameImpl dataFrameImpl = this;
            boolean $i$f$mapIndexed = false;
            $this$mapTo$iv$iv = $this$mapIndexed$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                DataColumn dataColumn;
                void col;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DataColumn $this$map$iv2 = (DataColumn)item$iv$iv;
                int n3 = n;
                Collection collection = destination$iv$iv;
                boolean bl7 = false;
                String name = ColumnReferenceApiKt.getName((ColumnReference)col);
                if (((CharSequence)name).length() == 0) {
                    void i;
                    String uniqueName = nameGenerator.addUnique("untitled");
                    DataColumn renamed = col.rename(uniqueName);
                    Integer n4 = (int)i;
                    this.columnsMap.put(uniqueName, n4);
                    dataColumn = renamed;
                } else {
                    dataColumn = col;
                }
                collection.add(dataColumn);
            }
            dataFrameImpl.columns = (List)destination$iv$iv;
        } else {
            this.columns = cols;
        }
    }

    public final int getNrow() {
        return this.nrow;
    }

    @NotNull
    protected final List<DataColumn<?>> getColumns() {
        return this.columns;
    }

    @Override
    public int rowsCount() {
        return this.nrow;
    }

    @Override
    public int getColumnIndex(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.columnsMap.get(name);
        return n != null ? n : -1;
    }

    public boolean equals(@Nullable Object other) {
        DataFrame dataFrame = other instanceof DataFrame ? (DataFrame)other : null;
        if (dataFrame == null) {
            return false;
        }
        DataFrame df2 = dataFrame;
        return Intrinsics.areEqual(this.columns, df2.columns());
    }

    public int hashCode() {
        return ((Object)this.columns).hashCode();
    }

    @NotNull
    public String toString() {
        return StringKt.renderToString$default(this, 0, 0, false, false, false, false, false, 127, null);
    }

    @Override
    @NotNull
    public List<DataColumn<?>> columns() {
        return this.columns;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> columnNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.columns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<KType> columnTypes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.columns;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.type());
        }
        return (List)destination$iv$iv;
    }

    @Override
    public int columnsCount() {
        return this.columns.size();
    }

    @Override
    @NotNull
    public DataRow<T> get(int index) {
        if (index < 0 || index >= this.nrow) {
            throw new IndexOutOfBoundsException("index: " + index + ", rowsCount: " + this.nrow);
        }
        return new DataRowImpl(index, this);
    }

    @Override
    @NotNull
    public Function2<ColumnsSelectionDsl<?>, ColumnsSelectionDsl<?>, ColumnsResolver<?>> remainingColumnsSelector() {
        return DataFrameImpl::remainingColumnsSelector$lambda$8;
    }

    @Override
    @NotNull
    public <R> DataRow<T> aggregate(@NotNull Function2<? super AggregateGroupedDsl<? extends T>, ? super AggregateGroupedDsl<? extends T>, ? extends R> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        GroupByReceiverImpl receiver2 = new GroupByReceiverImpl(this, false);
        body.invoke(receiver2, receiver2);
        DataRow<?> dataRow = receiver2.compute$core();
        if (dataRow == null) {
            dataRow = DataFrame.Companion.empty(1).get(0);
        }
        DataRow<?> row = dataRow;
        return CastKt.cast(row);
    }

    @Override
    @Nullable
    public DataColumn<?> getColumnOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int it = this.getColumnIndex(name);
        boolean bl = false;
        return it != -1 ? DataFrameGetKt.getColumn((ColumnsContainer)this, it) : null;
    }

    @Override
    @Nullable
    public DataColumn<?> getColumnOrNull(int index) {
        return index >= 0 && index < this.columns.size() ? this.columns.get(index) : null;
    }

    @Override
    @Nullable
    public <R> DataColumn<R> getColumnOrNull(@NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends SingleColumn<? extends R>> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return (DataColumn)CollectionsKt.singleOrNull(UtilsKt.getColumnsImpl(this, UnresolvedColumnsPolicy.Skip, column2));
    }

    @Override
    @Nullable
    public <R> DataColumn<R> getColumnOrNull(@NotNull ColumnReference<? extends R> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        ColumnWithPath columnWithPath = org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.resolveSingle((SingleColumn)column2, this, UnresolvedColumnsPolicy.Skip);
        return columnWithPath != null ? columnWithPath.getData() : null;
    }

    @Override
    @Nullable
    public <R> DataColumn<R> getColumnOrNull(@NotNull KProperty<? extends R> column2) {
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return this.getColumnOrNull((ColumnReference)TypeConversionsKt.toColumnAccessor(column2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DataColumn<?> getColumnOrNull(@NotNull ColumnPath path) {
        DataColumn<Object> dataColumn;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        switch (path.size()) {
            case 0: {
                dataColumn = TypeConversionsKt.asDataColumn(TypeConversionsKt.asColumnGroup$default(this, null, 1, null));
                break;
            }
            case 1: {
                dataColumn = this.getColumnOrNull(path.get(0));
                break;
            }
            default: {
                void $this$fold$iv;
                Iterable iterable = path.dropLast(1);
                DataFrame initial$iv = this;
                boolean $i$f$fold = false;
                DataFrame accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void name;
                    String string = (String)element$iv;
                    DataFrame df2 = accumulator$iv;
                    boolean bl = false;
                    DataFrame dataFrame = df2;
                    DataColumn<?> dataColumn2 = dataFrame != null ? dataFrame.getColumnOrNull((String)name) : null;
                    accumulator$iv = dataColumn2 instanceof DataFrame ? (DataFrame)((Object)dataColumn2) : null;
                }
                DataFrame dataFrame = accumulator$iv;
                dataColumn = dataFrame != null ? dataFrame.getColumnOrNull((String)CollectionsKt.last((List)path)) : null;
            }
        }
        return dataColumn;
    }

    @Override
    public boolean containsColumn(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.columnsMap.containsKey(name);
    }

    @Override
    public boolean containsColumn(@NotNull ColumnPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getColumnOrNull(path) != null;
    }

    private static final TransformableColumnSet remainingColumnsSelector$lambda$8(ColumnsSelectionDsl columnsSelectionDsl, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)columnsSelectionDsl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return columnsSelectionDsl.all(columnsSelectionDsl);
    }
}

