/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.dataTypes.IFRAME;
import org.jetbrains.kotlinx.dataframe.dataTypes.IMG;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.io.DataFrameHtmlData;
import org.jetbrains.kotlinx.dataframe.io.DisplayConfiguration;
import org.jetbrains.kotlinx.dataframe.io.HtmlKt;
import org.jetbrains.kotlinx.dataframe.io.StringKt;
import org.jetbrains.kotlinx.dataframe.jupyter.CellRenderer;
import org.jetbrains.kotlinx.dataframe.jupyter.RenderedContent;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001&B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0018\u0010\u0015\u001a\u00020\u0011*\u00020\u00032\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002J\u0014\u0010\u0017\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\f\u0010\u0019\u001a\u00020\u0011*\u00020\u0003H\u0002J\u0018\u0010\u0015\u001a\u00020\u0011*\u00020\u00112\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002J\u001d\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ \u0010\u001f\u001a\u00020\u00032\b\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J$\u0010%\u001a\u0004\u0018\u00010\u00112\b\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/DataFrameFormatter;", "", "formattedClass", "", "nullClass", "structuralClass", "numberClass", "dataFrameClass", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFormattedClass", "()Ljava/lang/String;", "getNullClass", "getStructuralClass", "getNumberClass", "getDataFrameClass", "wrap", "Lorg/jetbrains/kotlinx/dataframe/jupyter/RenderedContent;", "prefix", "content", "postfix", "addCss", "css", "ellipsis", "fullText", "structural", "truncate", "str", "limit", "", "truncate$core", "format", "value", "renderer", "Lorg/jetbrains/kotlinx/dataframe/jupyter/CellRenderer;", "configuration", "Lorg/jetbrains/kotlinx/dataframe/io/DisplayConfiguration;", "render", "Builder", "core"})
public final class DataFrameFormatter {
    @NotNull
    private final String formattedClass;
    @NotNull
    private final String nullClass;
    @NotNull
    private final String structuralClass;
    @NotNull
    private final String numberClass;
    @NotNull
    private final String dataFrameClass;

    public DataFrameFormatter(@NotNull String formattedClass, @NotNull String nullClass, @NotNull String structuralClass, @NotNull String numberClass, @NotNull String dataFrameClass) {
        Intrinsics.checkNotNullParameter((Object)formattedClass, (String)"formattedClass");
        Intrinsics.checkNotNullParameter((Object)nullClass, (String)"nullClass");
        Intrinsics.checkNotNullParameter((Object)structuralClass, (String)"structuralClass");
        Intrinsics.checkNotNullParameter((Object)numberClass, (String)"numberClass");
        Intrinsics.checkNotNullParameter((Object)dataFrameClass, (String)"dataFrameClass");
        this.formattedClass = formattedClass;
        this.nullClass = nullClass;
        this.structuralClass = structuralClass;
        this.numberClass = numberClass;
        this.dataFrameClass = dataFrameClass;
    }

    @NotNull
    public final String getFormattedClass() {
        return this.formattedClass;
    }

    @NotNull
    public final String getNullClass() {
        return this.nullClass;
    }

    @NotNull
    public final String getStructuralClass() {
        return this.structuralClass;
    }

    @NotNull
    public final String getNumberClass() {
        return this.numberClass;
    }

    @NotNull
    public final String getDataFrameClass() {
        return this.dataFrameClass;
    }

    private final RenderedContent wrap(String prefix, RenderedContent content, String postfix) {
        return RenderedContent.copy$default(content, prefix + content.getTruncatedContent() + postfix, 0, null, false, 14, null);
    }

    private final RenderedContent addCss(String $this$addCss, String css) {
        return this.addCss(RenderedContent.Companion.text($this$addCss), css);
    }

    static /* synthetic */ RenderedContent addCss$default(DataFrameFormatter dataFrameFormatter, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return dataFrameFormatter.addCss(string, string2);
    }

    private final RenderedContent ellipsis(String $this$ellipsis, String fullText) {
        return RenderedContent.copy$default(this.addCss($this$ellipsis, this.structuralClass), null, 0, fullText, false, 11, null);
    }

    private final RenderedContent structural(String $this$structural) {
        return this.addCss($this$structural, this.structuralClass);
    }

    private final RenderedContent addCss(RenderedContent $this$addCss, String css) {
        return css != null ? RenderedContent.copy$default($this$addCss, "<span class=\"" + css + "\">" + $this$addCss.getTruncatedContent() + "</span>", 0, null, true, 6, null) : $this$addCss;
    }

    static /* synthetic */ RenderedContent addCss$default(DataFrameFormatter dataFrameFormatter, RenderedContent renderedContent, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return dataFrameFormatter.addCss(renderedContent, string);
    }

    @NotNull
    public final RenderedContent truncate$core(@NotNull String str, int limit) {
        RenderedContent renderedContent;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        boolean bl = 1 <= limit ? limit < str.length() : false;
        if (bl) {
            RenderedContent ellipsis = this.ellipsis("...", str);
            if (limit < 4) {
                renderedContent = ellipsis;
            } else {
                int len = RangesKt.coerceAtLeast((int)(limit - 3), (int)1);
                String string = str.substring(0, len);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                renderedContent = RenderedContent.Companion.textWithLength(HtmlKt.escapeHTML(string), len).plus(ellipsis);
            }
        } else {
            renderedContent = RenderedContent.Companion.textWithLength(HtmlKt.escapeHTML(str), str.length());
        }
        return renderedContent;
    }

    @NotNull
    public final String format(@Nullable Object value, @NotNull CellRenderer renderer, @NotNull DisplayConfiguration configuration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        RenderedContent result = this.render(value, renderer, configuration);
        if (result == null) {
            string = "";
        } else {
            if (result.isFormatted() || result.isTruncated()) {
                String string2 = result.getFullContent();
                if (string2 == null || (string2 = HtmlKt.escapeHTML(string2)) == null) {
                    string2 = "";
                }
                String tooltip = string2;
                return "<span class=\"" + this.formattedClass + "\" title=\"" + tooltip + "\">" + result.getTruncatedContent() + "</span>";
            }
            string = result.getTruncatedContent();
        }
        return string;
    }

    private final RenderedContent render(Object value, CellRenderer renderer, DisplayConfiguration configuration) {
        RenderedContent result;
        RenderedContent renderedContent;
        int limit = configuration.getCellContentLimit();
        Object object = value;
        if (object == null) {
            renderedContent = this.addCss("null", this.nullClass);
        } else if (object instanceof DataRow) {
            List<Pair<String, Object>> values = StringKt.getVisibleValues((DataRow)value);
            if (values.isEmpty()) {
                renderedContent = this.addCss("{ }", this.nullClass);
            } else {
                RenderedContent renderedContent2;
                switch (limit) {
                    case 3: {
                        renderedContent2 = this.structural("...");
                        break;
                    }
                    case 4: {
                        renderedContent2 = this.structural("{..}");
                        break;
                    }
                    case 5: {
                        renderedContent2 = this.structural("{...}");
                        break;
                    }
                    case 6: {
                        renderedContent2 = this.structural("{ ...}");
                        break;
                    }
                    case 7: {
                        renderedContent2 = this.structural("{ ... }");
                        break;
                    }
                    default: {
                        renderedContent2 = DataFrameFormatter.render$renderList(this, limit, renderer, configuration, values, "{ ", " }");
                    }
                }
                RenderedContent it = renderedContent2;
                boolean bl = false;
                renderedContent = RenderedContent.copy$default(it, null, 0, CollectionsKt.joinToString$default((Iterable)values, (CharSequence)"\n", null, null, (int)0, null, DataFrameFormatter::render$lambda$1$lambda$0, (int)30, null), false, 11, null);
            }
        } else if (object instanceof DataFrame) {
            renderedContent = this.addCss(renderer.content("DataFrame [" + DataFrameKt.getSize((DataFrame)value) + ']', configuration), this.dataFrameClass);
        } else if (object instanceof List) {
            if (((List)value).isEmpty()) {
                renderedContent = this.addCss("[ ]", this.nullClass);
            } else {
                RenderedContent it = DataFrameFormatter.render$renderList(this, limit, renderer, configuration, (List)value, "[", "]");
                boolean bl = false;
                renderedContent = RenderedContent.copy$default(it, null, 0, CollectionsKt.joinToString$default((Iterable)((Iterable)value), (CharSequence)"\n", null, null, (int)0, null, DataFrameFormatter::render$lambda$3$lambda$2, (int)30, null), false, 11, null);
            }
        } else if (object instanceof Pair) {
            String key = ((Pair)value).getFirst() + ": ";
            RenderedContent renderedContent3 = this.render(((Pair)value).getSecond(), renderer, DisplayConfiguration.copy-rqXL5tM$default(configuration, null, null, 3, null, null, false, false, false, false, false, 1019, null));
            if (renderedContent3 == null) {
                renderedContent3 = this.addCss("...", this.structuralClass);
            }
            RenderedContent shortValue = renderedContent3;
            int sizeOfValue = shortValue.getTextLength();
            int keyLimit = limit - sizeOfValue;
            if (key.length() > keyLimit) {
                renderedContent = limit > 3 ? this.addCss(RenderingKt.truncate(key + "...", limit), this.structuralClass) : null;
            } else {
                RenderedContent renderedContent4 = this.render(((Pair)value).getSecond(), renderer, DisplayConfiguration.copy-rqXL5tM$default(configuration, null, null, limit - key.length(), null, null, false, false, false, false, false, 1019, null));
                if (renderedContent4 == null) {
                    renderedContent4 = this.addCss("...", this.structuralClass);
                }
                RenderedContent renderedValue = renderedContent4;
                renderedContent = this.addCss(key, this.structuralClass).plus(renderedValue);
            }
        } else {
            renderedContent = object instanceof Number ? this.addCss(renderer.content(value, configuration), this.numberClass) : (object instanceof URL ? this.wrap("<a href='" + value + "' target='_blank'>", renderer.content(((URL)value).toString(), configuration), "</a>") : (object instanceof DataFrameHtmlData ? RenderedContent.Companion.text(((DataFrameHtmlData)value).getBody()) : (object instanceof IMG ? RenderedContent.Companion.media(((IMG)value).toString()) : (object instanceof IFRAME ? RenderedContent.Companion.media(((IFRAME)value).toString()) : (result = object instanceof RenderedContent ? (RenderedContent)value : renderer.content(value, configuration))))));
        }
        if (result != null && result.getTextLength() > configuration.getCellContentLimit()) {
            return null;
        }
        return result;
    }

    private static final void render$renderList$addEllipsis(int limit, Builder sb, String $postfix, DataFrameFormatter this$0) {
        if (limit == sb.getLen() + 2 + $postfix.length()) {
            sb.plusAssign(this$0.addCss("..", this$0.structuralClass));
        } else {
            sb.plusAssign(this$0.addCss("...", this$0.structuralClass));
        }
        sb.setTruncated(true);
    }

    private static final RenderedContent render$renderList(DataFrameFormatter this$0, int limit, CellRenderer $renderer, DisplayConfiguration $configuration, List<?> values, String prefix, String postfix) {
        Builder sb = new Builder();
        sb.plusAssign(this$0.addCss(prefix, this$0.structuralClass));
        int n = ((Collection)values).size();
        for (int index = 0; index < n; ++index) {
            int n2;
            if (index > 0) {
                sb.plusAssign(this$0.addCss(", ", this$0.structuralClass));
            }
            if (index < values.size() - 1 && limit <= sb.getLen() + 3 + postfix.length()) {
                DataFrameFormatter.render$renderList$addEllipsis(limit, sb, postfix, this$0);
                break;
            }
            int n3 = index;
            if (n3 == values.size() - 1) {
                n2 = limit - sb.getLen() - postfix.length();
            } else if (n3 == values.size() - 2) {
                RenderedContent renderedContent = this$0.render(CollectionsKt.last(values), $renderer, DisplayConfiguration.copy-rqXL5tM$default($configuration, null, null, 4, null, null, false, false, false, false, false, 1019, null));
                int sizeOfLast = renderedContent != null ? renderedContent.getTextLength() : 3;
                n2 = limit - sb.getLen() - 2 - sizeOfLast - postfix.length();
            } else {
                n2 = limit - sb.getLen() - 5 - postfix.length();
            }
            int valueLimit = n2;
            RenderedContent rendered = this$0.render(values.get(index), $renderer, DisplayConfiguration.copy-rqXL5tM$default($configuration, null, null, valueLimit, null, null, false, false, false, false, false, 1019, null));
            if (rendered == null || rendered.getTextLength() == 3 && rendered.isTruncated()) {
                DataFrameFormatter.render$renderList$addEllipsis(limit, sb, postfix, this$0);
                break;
            }
            sb.plusAssign(rendered);
        }
        sb.plusAssign(this$0.addCss(postfix, this$0.structuralClass));
        return sb.result();
    }

    private static final CharSequence render$lambda$1$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getFirst() + ": " + it.getSecond();
    }

    private static final CharSequence render$lambda$3$lambda$2(Object it) {
        return String.valueOf(it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0086\u0002J\u0006\u0010\u0016\u001a\u00020\u0015R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dataframe/io/DataFrameFormatter$Builder;", "", "<init>", "()V", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "isFormatted", "", "value", "", "len", "getLen", "()I", "isTruncated", "()Z", "setTruncated", "(Z)V", "plusAssign", "", "content", "Lorg/jetbrains/kotlinx/dataframe/jupyter/RenderedContent;", "result", "core"})
    private static final class Builder {
        @NotNull
        private final StringBuilder sb = new StringBuilder();
        private boolean isFormatted;
        private int len;
        private boolean isTruncated;

        public final int getLen() {
            return this.len;
        }

        public final boolean isTruncated() {
            return this.isTruncated;
        }

        public final void setTruncated(boolean bl) {
            this.isTruncated = bl;
        }

        public final void plusAssign(@Nullable RenderedContent content) {
            if (content == null) {
                return;
            }
            this.sb.append(content.getTruncatedContent());
            this.len += content.getTextLength();
            if (content.isTruncated()) {
                this.isTruncated = true;
            }
            if (content.isFormatted()) {
                this.isFormatted = true;
            }
        }

        @NotNull
        public final RenderedContent result() {
            String string = this.sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new RenderedContent(string, this.len, this.isTruncated ? "" : null, this.isFormatted);
        }
    }
}

