/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.plugin;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlinx.dataframe.plugin.Key;
import org.jetbrains.kotlinx.dataframe.plugin.impl.Interpreter;
import org.jetbrains.kotlinx.dataframe.plugin.impl.api.PairConstructor;
import org.jetbrains.kotlinx.dataframe.plugin.impl.api.PairToConstructor;
import org.jetbrains.kotlinx.dataframe.plugin.impl.api.TrimIndent;
import org.jetbrains.kotlinx.dataframe.plugin.impl.api.TrimMargin;
import org.jetbrains.kotlinx.dataframe.plugin.utils.Names;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlinx/dataframe/plugin/Stdlib;", "", "<init>", "()V", "map", "", "Lorg/jetbrains/kotlinx/dataframe/plugin/Key;", "Lorg/jetbrains/kotlinx/dataframe/plugin/impl/Interpreter;", "interpreter", "call", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "register", "", "id", "Lorg/jetbrains/kotlin/name/CallableId;", "returnType", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlin-dataframe-compiler-plugin.k2"})
final class Stdlib {
    @NotNull
    public static final Stdlib INSTANCE = new Stdlib();
    @NotNull
    private static final Map<Key, Interpreter<?>> map = new LinkedHashMap();

    private Stdlib() {
    }

    @Nullable
    public final Interpreter<?> interpreter(@NotNull FirFunctionCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        FirFunctionSymbol firFunctionSymbol = FirReferenceUtilsKt.toResolvedFunctionSymbol$default((FirReference)((FirReference)call.getCalleeReference()), (boolean)false, (int)1, null);
        if (firFunctionSymbol == null || (firFunctionSymbol = firFunctionSymbol.getCallableId()) == null) {
            return null;
        }
        FirFunctionSymbol id = firFunctionSymbol;
        ConeKotlinType coneKotlinType = call.getConeTypeOrNull();
        if (coneKotlinType == null || (coneKotlinType = ConeTypeUtilsKt.getClassId((ConeKotlinType)coneKotlinType)) == null) {
            return null;
        }
        ConeKotlinType returnType = coneKotlinType;
        return map.get(new Key((CallableId)id, (ClassId)returnType));
    }

    public final void register(@NotNull CallableId id, @NotNull ClassId returnType, @NotNull Interpreter<?> interpreter) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(interpreter, (String)"interpreter");
        map.put(new Key(id, returnType), interpreter);
    }

    static {
        INSTANCE.register(Names.INSTANCE.getTO(), Names.INSTANCE.getPAIR(), new PairToConstructor());
        INSTANCE.register(Names.INSTANCE.getPAIR_CONSTRUCTOR(), Names.INSTANCE.getPAIR(), new PairConstructor());
        INSTANCE.register(Names.INSTANCE.getTRIM_MARGIN(), StandardClassIds.INSTANCE.getString(), new TrimMargin());
        INSTANCE.register(Names.INSTANCE.getTRIM_INDENT(), StandardClassIds.INSTANCE.getString(), new TrimIndent());
    }
}

